% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/PyObjectList.R
\name{pyList}
\alias{pyList}
\title{Creates a virtual Python list}
\usage{
pyList(key, value, regFinalizer = TRUE)
}
\arguments{
\item{key}{a character string giving the name of the Python object.}

\item{value}{an optional value, allowed values are vectors, lists and NULL.}

\item{regFinalizer}{a logical indicating if a finalizer should be
be registered, the default value is TRUE.}
}
\description{
The function pyList creates a virtual Python object
             of type PythonInR_List.
}
\details{
If no value is provided a virtual Python list for an existing
         Python object is created. If the value is NULL an empty
         virtual Python object for an empty list is created.
         If the value is a vector or a list, a new Python
         object based on the vector or list is created.
}
\examples{
\dontshow{PythonInR:::pyCranConnect()}
if ( pyIsConnected() ){
pyExec('myPyList = [1, 2, 5, "Hello R!"]')
# create a virtual Python list for an existing list
myList <- pyList("myPyList")
myList[0]
myList[1] <- "changed"
myList
# create a new Python list and virtual list
myNewList <- pyList('myNewList', list(1:3, 'Hello Python'))
myNewList[1]
myNewList$append(4L)
ls(myNewList)
## NOTE: Indexing which can not be interpreted as correct R
##       syntax should be provided as a character string.
myNewList['::2']
}
}

