% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumerate_RGs.R
\name{enumerate_RGs}
\alias{enumerate_RGs}
\title{Enumerate relationship graphs (RGs)}
\usage{
enumerate_RGs(MOIs, igraph = TRUE, progress.bar = TRUE)
}
\arguments{
\item{MOIs}{Vector of per-episode multiplicities of infection (MOIs),
i.e., numbers of per-episode genotypes / vertices.}

\item{igraph}{Logical; returns RGs as \code{igraph} objects (default \code{TRUE}).}

\item{progress.bar}{Logical; show progress bar (default \code{TRUE}).}
}
\value{
A list of RGs. If \code{igraph = FALSE},
each RG is a list of length four with:
\describe{
\item{clone}{List of vectors encoding genotypes per clonal cell.}
\item{clone.vec}{Numeric vector with the clonal cell membership of
each genotype.}
\item{sib}{List of vectors encoding clonal cells per sibling cell.}
\item{sib.vec}{Numeric vector with the sibling cell membership of
each clonal cell.}
}
If \code{igraph = TRUE} (default), each RG is encoded as an \code{igraph} object
(see \code{\link{RG_to_igraph}}).
}
\description{
An RG is a graph over all per-person parasite genotypes (each as a
vertex), with edges between clone and sibling genotypes.
Valid RGs satisfy:
\itemize{
\item{Subgraphs induced by clone edges are cluster graphs.}
\item{Subgraphs induced by clone plus sibling edges are cluster graphs.}
\item{Clone edges only link genotypes from different episodes.}
}
}
\details{
RGs are generated by enumerating nested set partitions under specific
constraints; see
\href{https://aimeertaylor.github.io/Pv3Rs/articles/enumerate.pdf}{Understand graph and partition enumeration}.
Each nested set parition is an RG. Clone edges induce a cluster graph,
equivalent to a partition of genotypes, with no intra-episode clones allowed.
Sibling edges refine the clone partition, with no constraints (intra-episode
siblings allowed). Each nested set partition is encoded as a list. Each
partition is represented by a list of vectors (either \code{clone} or \code{sib}) and
by a membership vector (either \code{clone.vec} or \code{sib.vec}). By default, an RG
encoded as a list is converted to an \code{igraph} object.
}
\examples{
graphs <- enumerate_RGs(c(2, 1, 2), progress.bar = FALSE) # nine graphs

}
