% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method-PETPEESE.R
\name{method.PETPEESE}
\alias{method.PETPEESE}
\title{PET-PEESE (Precision-Effect Test and Precision-Effect Estimate with
Standard Errors) Method}
\usage{
\method{method}{PETPEESE}(method_name, data, settings)
}
\arguments{
\item{method_name}{Method name (automatically passed)}

\item{data}{Data frame with yi (effect sizes) and sei (standard errors)}

\item{settings}{List of method settings (see Details)}
}
\value{
Data frame with PET-PEESE results
}
\description{
Implements the Precision-Effect Test and Precision-Effect Estimate with
Standard Errors (PET-PEESE) regresses effect sizes against standard errors^2 to
correct for publication bias. The intercept represents the bias-corrected
effect size estimate. See
\insertCite{stanley2014meta;textual}{PublicationBiasBenchmark} for details.
}
\details{
The following settings are implemented \describe{
\item{\code{"default"}}{
(\code{conditional_alpha = 0.10}) determines whether to use PET
(PET's effect is not significant at alpha = 0.10 or PEESE estimate
(PET's effect is significant at alpha = 0.10)}
}
}
\examples{
# Generate some example data
data <- data.frame(
  yi = c(0.2, 0.3, 0.1, 0.4, 0.25),
  sei = c(0.1, 0.15, 0.08, 0.12, 0.09)
)

# Apply PETPEESE method
result <- run_method("PETPEESE", data)
print(result)

}
\references{
\insertAllCited{}
}
