% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_OBDAP.R
\name{get_data_OBDAP}
\alias{get_data_OBDAP}
\title{Retrieve financial data on public works from the OpenBDAP data base.}
\usage{
get_data_OBDAP(
  cod_reg,
  cod_prov = NULL,
  cod_mun = NULL,
  start = NULL,
  end = NULL,
  geo_ref = NULL,
  soil_defense = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{cod_reg}{character vector. The ISTAT regional code is used to specify one or more regions of interest when retrieving data. (See \code{\link{get_codes}} function)}

\item{cod_prov}{character vector. The ISTAT province code is used to specify one or more provinces of interest when retrieving data. (See \code{\link{get_codes}} function)}

\item{cod_mun}{character vector The ISTAT municipal code is used to specify one or more municipalities of interest when retrieving data. (See \code{\link{get_codes}} function)}

\item{start}{character (format YYYY-mm-dd). Effective starting date of design refers to the specific phase of a public project that marks the beginning of its design process. This date can be of interest for filtering and analyzing relevant data.}

\item{end}{character (format YYYY-mm-dd). Effective ending date of design refers to the specific phase of a public project that marks the conclusion of its design process. This date can be of interest for filtering and analyzing relevant data.}

\item{geo_ref}{character. The georeference data can be specified using the \code{geo_ref} argument. If set to \code{A}, the function returns shape polygons of each municipality. If set to \code{C}, it retrieves the coordinates of the centroids of each municipality.}

\item{soil_defense}{logical.  By default set to \code{FALSE}. If only soil defense data are of interest set the argument to \code{TRUE}.}

\item{verbose}{Logic value (TRUE or FALSE). Toggle warnings and messages. If 'verbose = TRUE' (default) the function
prints on the screen some messages describing the progress of the tasks. If 'verbose = FALSE' any message about
the progression is suppressed.}
}
\value{
Object of class \code{data.frame} showing 22 variables.Descriptive Variables:
\itemize{
\item{Local Project Code (\code{character})}
\item{CUP (\code{character})}
\item{Intervention (\code{character})}
}
Financial Variables:
\itemize{
\item{State Funding (\code{numeric})}
\item{EU Funding (\code{numeric})}
\item{Local Authorities Funding (\code{numeric})}
\item{Private Funding (\code{numeric})}
\item{Other Funding (\code{numeric})}
}

Geographical References:
\itemize{
\item{DEN_REGION (\code{character})}
\item{DEN_PROVINCE (\code{character})}
\item{DEN_MUNICIPALITY (\code{character})}
\item{COD_REGION (\code{character})}
\item{COD_PROVINCE (\code{character})}
\item{COD_MUNICIPALITY (\code{character})}
\item{geom (\code{character})}
}

Legislative process main steps:
\itemize{
\item{Executive Design Starting Date (\code{character})}
\item{Executive Design Ending Date (\code{character})}
\item{Works Execution Starting Date (\code{character})}
\item{Works Execution Ending Date (\code{character})}
\item{Conclusion Starting Date (\code{character})}
\item{Conclusion Ending Date (\code{character})}
\item{Operability (\code{character})}
}
}
\description{
get_data_OBDAP function retrieves data from one or more Italian regions using ISTAT region codes. It allows filtering based on: municipality code, and the project's starting and/or ending dates. Additionally, it provides geospatial references.
}
\examples{
\donttest{data <- get_data_OBDAP("14")}
# Retrieve data for one region filtering for soil defense interventions.
}
\references{
\href{https://bdap-opendata.rgs.mef.gov.it/tema/opere-pubbliche}{Open BDAP}
}
\author{
Lorena Ricciotti
}
