% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03-dynamic.R
\name{text_unmask}
\alias{text_unmask}
\title{<Deprecated> Fill in the blank mask(s) in a query (sentence).}
\usage{
text_unmask(query, model, targets = NULL, topn = 5)
}
\arguments{
\item{query}{A query (sentence/prompt) with masked token(s) \code{[MASK]}.
Multiple queries are also supported. See examples.}

\item{model}{Model name at \href{https://huggingface.co/models}{HuggingFace}.
See \code{\link{text_model_download}}.
If the model has not been downloaded, it would automatically download the model.}

\item{targets}{Specific target word(s) to be filled in the blank \code{[MASK]}.
Defaults to \code{NULL} (i.e., return \code{topn}).
If specified, then \code{topn} will be ignored (see examples).}

\item{topn}{Number of the most likely predictions to return.
Defaults to \code{5}. If \code{targets} is specified,
then it will automatically change to the length of \code{targets}.}
}
\value{
A \code{data.table} of query results:
\describe{
  \item{\code{query_id} (if there are more than one \code{query})}{
    \code{query} ID (indicating multiple queries)}
  \item{\code{mask_id} (if there are more than one \code{[MASK]} in \code{query})}{
    \code{[MASK]} ID (position in sequence, indicating multiple masks)}
  \item{\code{prob}}{
    Probability of the predicted token in the sequence}
  \item{\code{token_id}}{
    Predicted token ID (to replace \code{[MASK]})}
  \item{\code{token}}{
    Predicted token (to replace \code{[MASK]})}
  \item{\code{sequence}}{
    Complete sentence with the predicted token}
}
}
\description{
\emph{Note}: This function has been deprecated and will not be updated
since I have developed new package
\href{https://psychbruce.github.io/FMAT/}{FMAT}
as the integrative toolbox of \emph{Fill-Mask Association Test} (FMAT).

Predict the probably correct masked token(s) in a sequence,
based on the Python module \code{transformers}.
}
\details{
Masked language modeling is the task of masking some of the words in a sentence
and predicting which words should replace those masks.
These models are useful when we want to get a statistical understanding of
the language in which the model is trained in.
See \url{https://huggingface.co/tasks/fill-mask} for details.
}
\examples{
\dontrun{
# text_init()  # initialize the environment

model = "distilbert-base-cased"

text_unmask("Beijing is the [MASK] of China.", model)

# multiple [MASK]s:
text_unmask("Beijing is the [MASK] [MASK] of China.", model)

# multiple queries:
text_unmask(c("The man worked as a [MASK].",
              "The woman worked as a [MASK]."),
            model)

# specific targets:
text_unmask("The [MASK] worked as a nurse.", model,
            targets=c("man", "woman"))
}

}
\seealso{
\code{\link{text_init}}

\code{\link{text_model_download}}

\code{\link{text_model_remove}}

\code{\link{text_to_vec}}
}
