\name{rdata.reader}
\alias{rdata.reader}
\title{Read an RData file with a .rdata or .rda file extension.}
\usage{
  rdata.reader(data.file, filename, variable.name)
}
\arguments{
  \item{data.file}{The name of the data file to be read.}

  \item{filename}{The path to the data set to be loaded.}

  \item{variable.name}{The name to be assigned to in the
  global environment.}
}
\value{
  No value is returned; this function is called for its
  side effects.
}
\description{
  This function will load the specified RData file into
  memory using the \code{\link{load}} function. This may
  generate many data sets simultaneously.
}
\examples{
library('ProjectTemplate')

\dontrun{rdata.reader('example.RData', 'data/example.RData', 'example')}
}

