% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ProbitSpatial_R.R
\name{effects}
\alias{effects}
\title{Effects of a spatial probit model.}
\usage{
effects(object)
}
\arguments{
\item{object}{an object of class \code{SpatialProbit}.}
}
\value{
It returns the marginal effects of the estimated 
	\code{SpatialProbit} model.
}
\description{
Returns the marginal effects of a \code{SpatialProbit} model.
}
\details{
The \code{effects} function has different outputs according to the 
	DGP of the \code{SpatialProbit} model:
\describe{
  \item{\code{"SAR"}}{The marginal effects of a spatial autoregressive 
	model are more complicated than usual measurements of impacts for non 
	spatial models. Here we follow LeSage and Pace and propose the following 
	summaries for impact measures:}
		\describe{
	\item{Average direct effects:}{the average over all the observations of 
      the effects of the change of an explanatory variable of a single 
      observation on the choice probability of that same observation.}
	\item{Average indirect effects:}{the average over all the observations 
      of the effect of a change on a explanatory variable on the choice 
      probability of the neighbouring observations.}
	\item{Average total effects:}{the sum of direct and indirect impacts.}
}
  \item{\code{"SEM"}}{marginal effects should be interpreted as if it were a 
	 standard probit model.}
}
}
\references{
J. LeSage and R.K. Pace. \emph{Introduction to Spatial Econometrics}, CRC 
	Press, chapter 10.1.6, 2009.
}

