## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----tab-effect-commands, echo=FALSE, message=FALSE, warning=FALSE------------
library(ProTrackR2)
library(kableExtra)
data(effect_commands)
effect_commands |> kbl()

## ----select-command-----------------------------------------------------------
## load the demo-mod included with the package
mod <- pt2_read_mod(pt2_demo())

pt2_command(
  mod$patterns[[ 3 ]] [ 1:8, 2 ])

## ----assign-command-----------------------------------------------------------
pt2_command(
  mod$patterns[[ 3 ]] [ 1:8, 2 ]) <- "C10"

## ----command-examples---------------------------------------------------------

## create a new mod te demonstrate commands
mod_command <- pt2_new_mod("commands")
## copy the samples from the mod above
mod_command$samples <- mod$samples

if (interactive()) {
  mod_command$patterns[[1]][1,1] <- "C-3 01 000"
  ## Reduce sample volume
  pt2_command(mod_command$patterns[[1]][,1]) <- "C10"
  play(mod_command)
  
  mod_command$patterns[[1]][1,1] <- "C-3 03 000"
  ## Simulate major chord:
  pt2_command(mod_command$patterns[[1]][,1]) <- "047"
  play(mod_command)
  
  ## Simulate minor chord
  pt2_command(mod_command$patterns[[1]][,1]) <- "037"
  play(mod_command)

  ## Porta up:
  pt2_command(mod_command$patterns[[1]][,1]) <- "101"
  play(mod_command)

  ## Porta down:
  pt2_command(mod_command$patterns[[1]][,1]) <- "201"
  play(mod_command)
  
  ## Porta to note:
  mod_command$patterns[[1]][1,1] <- "C-3 03 000"
  mod_command$patterns[[1]][2:64,1] <- "E-3 03 000"
  pt2_command(mod_command$patterns[[1]][2:64,1]) <- "301"
  play(mod_command)
  
  mod_command$patterns[[1]] <- pt2_new_pattern() # reset pattern
  mod_command$patterns[[1]][1,1] <- "C-3 03 000"
  ## Vibrato:
  pt2_command(mod_command$patterns[[1]][,1]) <- "464"
  play(mod_command)
  
  ## Tremolo:
  pt2_command(mod_command$patterns[[1]][,1]) <- "743"
  play(mod_command)

  ## Fade out:
  pt2_command(mod_command$patterns[[1]][,1]) <- "A01"
  play(mod_command)

  mod_command$patterns[[1]][1,1] <- "C-3 03 C00"
  ## Fade in:
  pt2_command(mod_command$patterns[[1]][2:63,1]) <- "A10"
  play(mod_command)
}


## ----effect-instrument--------------------------------------------------------
mod$patterns[[1]] <- pt2_new_pattern()
mod$patterns[[1]][1,1] <- "C-3 03 000"
## Slide the volume down in the entire track:
pt2_command(mod$patterns[[1]][,1]) <- "A08"
## Reset the volume each row by setting the sample
## number for the entire track
pt2_instrument(mod$patterns[[1]][,1]) <- 3L
if (interactive()) {
  play(mod)
}


