% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02PTCell.r, R/03PTTrack.r, R/04PTPattern.r
\name{noteUp}
\alias{noteUp}
\alias{noteUp,PTCell-method}
\alias{noteDown}
\alias{noteDown,PTCell-method}
\alias{octaveUp}
\alias{octaveUp,PTCell-method}
\alias{octaveDown}
\alias{octaveDown,PTCell-method}
\alias{noteUp,PTTrack-method}
\alias{noteDown,PTTrack-method}
\alias{octaveUp,PTTrack-method}
\alias{octaveDown,PTTrack-method}
\alias{noteUp,PTPattern-method}
\alias{noteDown,PTPattern-method}
\alias{octaveUp,PTPattern-method}
\alias{octaveDown,PTPattern-method}
\title{Raise or lower notes and octaves}
\usage{
\S4method{noteUp}{PTCell}(x, sample.nr = "all")

\S4method{noteDown}{PTCell}(x, sample.nr = "all")

\S4method{octaveUp}{PTCell}(x, sample.nr = "all")

\S4method{octaveDown}{PTCell}(x, sample.nr = "all")

\S4method{noteUp}{PTTrack}(x, sample.nr = "all")

\S4method{noteDown}{PTTrack}(x, sample.nr = "all")

\S4method{octaveUp}{PTTrack}(x, sample.nr = "all")

\S4method{octaveDown}{PTTrack}(x, sample.nr = "all")

\S4method{noteUp}{PTPattern}(x, sample.nr = "all")

\S4method{noteDown}{PTPattern}(x, sample.nr = "all")

\S4method{octaveUp}{PTPattern}(x, sample.nr = "all")

\S4method{octaveDown}{PTPattern}(x, sample.nr = "all")
}
\arguments{
\item{x}{A \code{\link{PTCell}}, \code{\link{PTTrack}} or
\code{\link{PTPattern}} object for which the notes need to be lowered
or raised.}

\item{sample.nr}{A single positive \code{integer} value, or a \code{vector} of
positive \code{integer}s, listing the indices of samples, for which the notes
need to be lowered or raised. A \code{character} string equal to \verb{"all}"
is also allowed (this is in fact the default), in which case notes of all
sample indices are raised or lowered.}
}
\value{
Returns an object of the same class as object \code{x}, in which
the notes for samples selected with \code{sample.nr} are raised or lowered.

In case raised or lowered notes would lead to notes that are out of
ProTracker's range, the returned notes remain unchanged.
}
\description{
Methods to raise or lower notes in \code{\link{PTCell}},
\code{\link{PTTrack}} and \code{\link{PTPattern}} objects.
}
\examples{

## raise note from C-2 to C#2:
noteUp(PTCell("C-2 01 000"))


## lower note from C-2 to B-1:
noteDown(PTCell("C-2 01 000"))


## raise note from octave 2 to octave 3:
octaveUp(PTCell("C-2 01 000"))


## lower note from octave 2 to octave 1:
octaveDown(PTCell("C-2 01 000"))


data("mod.intro")

## Raise the notes of all cells in pattern
## number 2 of mod.intro:
noteUp(PTPattern(mod.intro, 2))

## Raise only the notes of sample number 4
## in pattern number 2 of mod.intro:
noteUp(PTPattern(mod.intro, 2), 4)

## Raise only the notes of samples number 2 and 4
## in pattern number 2 of mod.intro:
noteUp(PTPattern(mod.intro, 2), c(2, 4))

}
\seealso{
Other note.and.octave.operations: 
\code{\link{noteToPeriod}()},
\code{\link{note}()},
\code{\link{octave}()},
\code{\link{periodToChar}()},
\code{\link{sampleRate}}
}
\author{
Pepijn de Vries
}
\concept{note.and.octave.operations}
