% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05PTSample.r
\docType{methods}
\name{read.sample}
\alias{read.sample}
\alias{read.sample,character-method}
\title{Read an audio file and coerce to a PTSample object}
\usage{
\S4method{read.sample}{character}(filename, what = c("wav", "mp3", "8svx",
  "raw"))
}
\arguments{
\item{filename}{A \code{character} string representing the filename to be read.}

\item{what}{A \code{character} string indicating what type of file is to be
read. Can be one of the following: "\code{wav}" (default), "\code{mp3}",
"\code{8svx}" or "\code{raw}".}
}
\value{
Returns a \code{PTSample} object based on the file read.
}
\description{
Reads audio files from "wav" and "mp3" files, using \code{\link[tuneR]{tuneR}}
methods. Commodore Amiga native formats "8svx" and "raw" can also be read.
}
\details{
This method provides a wrapper for the \code{\link[tuneR]{readWave}} and
\code{\link[tuneR]{readMP3}} methods from \code{\link[tuneR]{tuneR}}. It also
provides the means to import audio from file formats native to the Commodore
Amiga. Simple \href{https://en.wikipedia.org/wiki/8SVX}{8svx} files (also known
as "iff" files) can be read, it has not yet been tested with more complex 8svx files.
It was also common practice to store audio samples as raw data on the
Commodore Amiga, where each byte simply represented a signed integer value
of the waveform.

All audio will be coerced to 8 bit mono with a maximum length of
\code{2*0xffff} = {131070} bytes (= samples) as per ProTracker standards.
}
\note{
As per ProTracker standards, a sample should have an even length
(in bytes). If a sample file has an odd length, a \code{raw} \code{0x00} value
is added to the end.
}
\examples{
\dontrun{
data("mod.intro")

## create an audio file which we can then read:
write.sample(PTSample(mod.intro, 2), "snaredrum.iff", "8svx")

## read the created sample:
snare <- read.sample("snaredrum.iff", "8svx")
print(snare)
}

}
\seealso{
Other sample.operations: \code{\link{PTSample-class}},
  \code{\link{PTSample-method}}, \code{\link{fineTune}},
  \code{\link{loopLength}}, \code{\link{loopSample}},
  \code{\link{loopStart}}, \code{\link{loopState}},
  \code{\link{name}}, \code{\link{playSample}},
  \code{\link{sampleLength}}, \code{\link{volume}},
  \code{\link{waveform}}, \code{\link{write.sample}}

Other io.operations: \code{\link{read.module}},
  \code{\link{write.module}}, \code{\link{write.sample}}
}
\author{
Pepijn de Vries
}
