% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{period_table}
\alias{period_table}
\title{ProTracker Period Table}
\format{a \code{data.frame} with fourteen columns:
\itemize{
  \item{The column named `octave': \code{integer} value [1,3]}
  \item{The column named `finetune': \code{integer} value [-8, 7] used to tune a sample}
  \item{The columns named `C-' to `B-': represent the twelve (semi)tones.
  The values in these columns are the period values for the corresponding
  tone, octave and finetune.}
}}
\description{
Table of ProTracker period values and corresponding, octave, tone and fine tune
}
\details{
Table of ProTracker period values used in calculating the
playback sampling rate of samples for specific tones.
These are the values that are actually used by ProTracker,
they cannot be calculated directly due to
undocumented rounding inconsistencies. This lookup table is therefore
a requirement.
}
\examples{
data("period_table")
}
\seealso{
Other period.operations: \code{\link{noteToPeriod}},
  \code{\link{note}}, \code{\link{octave}},
  \code{\link{periodToChar}}, \code{\link{sampleRate}}
}

