% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GPsInElevGaps.R
\name{GPsInElevGaps}
\alias{GPsInElevGaps}
\title{Detect gene predictions in elevations and gaps}
\usage{
GPsInElevGaps(elevGapSummList, windowSize, gffTSV, mode, chunkContigs)
}
\arguments{
\item{elevGapSummList}{A list containing pattern-match information associated with all
elevation and gap classifications. (i.e. no NoPattern classifications)}

\item{windowSize}{The number of basepairs to average read coverage values over.
Options are 100, 200, 500, 1000 ONLY. Default is 1000.}

\item{gffTSV}{Optional, a .gff file (TSV) containing gene predictions associated with the .fasta
file used to generate the pileup.}

\item{mode}{Either "genome" or "metagenome"}

\item{chunkContigs}{TRUE or FALSE, If TRUE and `mode`="metagenome", contigs longer
than the `chunkSize` will be 'chunked' into smaller subsets and pattern-matching
will be performed on each subset. Default is FALSE.}
}
\description{
Extracts subsets of the gffTSV associated with gene predictions that fall within regions
of detected gapped or elevated read coverage.
}
\keyword{internal}
