% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/foo.R
\name{control.mcmc.Bayes.SPDE}
\alias{control.mcmc.Bayes.SPDE}
\title{Control settings for the MCMC algorithm used for Bayesian inference using SPDE}
\usage{
control.mcmc.Bayes.SPDE(
  n.sim,
  burnin,
  thin,
  h.theta1 = 0.01,
  h.theta2 = 0.01,
  start.beta = "prior mean",
  start.sigma2 = "prior mean",
  start.phi = "prior mean",
  start.S = "prior mean",
  n.iter = 1,
  h = 1,
  c1.h.theta1 = 0.01,
  c2.h.theta1 = 1e-04,
  c1.h.theta2 = 0.01,
  c2.h.theta2 = 1e-04
)
}
\arguments{
\item{n.sim}{total number of simulations.}

\item{burnin}{initial number of samples to be discarded.}

\item{thin}{value used to retain only evey \code{thin}-th sampled value.}

\item{h.theta1}{starting value of the tuning parameter of the proposal distribution for \eqn{\theta_{1} = \log(\sigma^2)/2}. See 'Details' in \code{\link{binomial.logistic.Bayes}} or \code{\link{linear.model.Bayes}}.}

\item{h.theta2}{starting value of the tuning parameter of the proposal distribution for \eqn{\theta_{2} = \log(\sigma^2/\phi^{2 \kappa})}. See 'Details' in \code{\link{binomial.logistic.Bayes}} or \code{\link{linear.model.Bayes}}.}

\item{start.beta}{starting value for the regression coefficients \code{beta}. If not provided the prior mean is used.}

\item{start.sigma2}{starting value for \code{sigma2}. If not provided the prior mean is used.}

\item{start.phi}{starting value for \code{phi}. If not provided the prior mean is used.}

\item{start.S}{starting value for the spatial random effect. If not provided the prior mean is used.}

\item{n.iter}{number of iteration of the Newton-Raphson procedure used to compute the mean and coviariance matrix of the Gaussian proposal in the MCMC; defaut is \code{n.iter=1}.}

\item{h}{tuning parameter for the covariance matrix of the Gaussian proposal. Default is \code{h=1}.}

\item{c1.h.theta1}{value of \eqn{c_{1}} used to adaptively tune the variance of the Gaussian proposal for the transformed parameter \code{log(sigma2)/2}; see 'Details' in \code{\link{binomial.logistic.Bayes}} or \code{\link{linear.model.Bayes}}.}

\item{c2.h.theta1}{value of \eqn{c_{2}} used to adaptively tune the variance of the Gaussian proposal for the transformed parameter \code{log(sigma2)/2}; see 'Details' in \code{\link{binomial.logistic.Bayes}} or \code{\link{linear.model.Bayes}}.}

\item{c1.h.theta2}{value of \eqn{c_{1}} used to adaptively tune the variance of the Gaussian proposal for the transformed parameter \code{log(sigma2.curr/(phi.curr^(2*kappa)))}; see 'Details' in \code{\link{binomial.logistic.Bayes}} or \code{\link{linear.model.Bayes}}.}

\item{c2.h.theta2}{value of \eqn{c_{2}} used to adaptively tune the variance of the Gaussian proposal for the transformed parameter \code{log(sigma2.curr/(phi.curr^(2*kappa)))}; see 'Details' in \code{\link{binomial.logistic.Bayes}} or \code{\link{linear.model.Bayes}}.}
}
\value{
an object of class "mcmc.Bayes.PrevMap".
}
\description{
This function defines the different tuning parameter that are used in the MCMC algorithm for Bayesian inference using a SPDE approximation for the spatial Gaussian process.
}
\author{
Emanuele Giorgi \email{e.giorgi@lancaster.ac.uk}

Peter J. Diggle \email{p.diggle@lancaster.ac.uk}
}
