test_that("scales functions works", {
  fill_scale <- scale_fill_pretty_c(name = "Greens")
  expect_equal(fill_scale$is_discrete(), FALSE)
  fill_scale <- scale_fill_pretty_c(name = "Greens", legend_title = "New Title")
  expect_equal(fill_scale$is_discrete(), FALSE)
  expect_error(scale_fill_pretty_c(name = "Green"))
  expect_error(scale_fill_pretty_c(name = "Greens", direction = 0))

  fill_scale <- scale_fill_pretty_d(name = "Relax")
  expect_equal(fill_scale$is_discrete(), TRUE)
  fill_scale <- scale_fill_pretty_d(name = "Relax", legend_title = "New Title")
  expect_equal(fill_scale$is_discrete(), TRUE)
  fill_scale <- scale_fill_pretty_d(name = "Relax", direction = -1)
  expect_equal(fill_scale$is_discrete(), TRUE)
  expect_error(scale_fill_pretty_d(name = "Relaxing"))
  expect_error(scale_fill_pretty_d(name = "Relax", direction = 0))

  colour_scale <- scale_colour_pretty_c(name = "Greens")
  expect_equal(colour_scale$is_discrete(), FALSE)
  colour_scale <- scale_colour_pretty_c(name = "Greens", legend_title = "New Title")
  expect_equal(colour_scale$is_discrete(), FALSE)
  expect_error(scale_colour_pretty_c(name = "Green"))
  expect_error(scale_colour_pretty_c(name = "Greens", direction = 0))

  colour_scale <- scale_color_pretty_c(name = "Greens")
  expect_equal(colour_scale$is_discrete(), FALSE)
  colour_scale <- scale_color_pretty_c(name = "Greens", legend_title = "New Title")
  expect_equal(colour_scale$is_discrete(), FALSE)
  expect_error(scale_color_pretty_c(name = "Green"))
  expect_error(scale_color_pretty_c(name = "Greens", direction = 0))

  colour_scale <- scale_colour_pretty_d(name = "Relax")
  expect_equal(colour_scale$is_discrete(), TRUE)
  colour_scale <- scale_colour_pretty_d(name = "Relax", legend_title = "New Title")
  expect_equal(colour_scale$is_discrete(), TRUE)
  colour_scale <- scale_colour_pretty_d(name = "Relax", direction = -1)
  expect_equal(colour_scale$is_discrete(), TRUE)
  expect_error(scale_colour_pretty_d(name = "Relaxing"))
  expect_error(scale_colour_pretty_d(name = "Relax", direction = 0))

  colour_scale <- scale_color_pretty_d(name = "Relax")
  expect_equal(colour_scale$is_discrete(), TRUE)
  colour_scale <- scale_color_pretty_d(name = "Relax", legend_title = "New Title")
  expect_equal(colour_scale$is_discrete(), TRUE)
  colour_scale <- scale_color_pretty_d(name = "Relax", direction = -1)
  expect_equal(colour_scale$is_discrete(), TRUE)
  expect_error(scale_color_pretty_d(name = "Relaxing"))
  expect_error(scale_color_pretty_d(name = "Relax", direction = 0))
})
