% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BilomaxPR.R
\name{dBilomaxPR}
\alias{dBilomaxPR}
\title{BilomaxPR}
\usage{
dBilomaxPR(x, a, b, c, alpha, beta, theta)
}
\arguments{
\item{x}{single positive scalar for quotient}

\item{a}{parameter for Bivariate lomax distribution}

\item{b}{parameter for Bivariate lomax distribution}

\item{c}{parameter for Bivariate lomax distribution}

\item{alpha}{parameter for Bivariate lomax distribution}

\item{beta}{parameter for Bivariate lomax distribution}

\item{theta}{parameter for Bivariate lomax distribution}
}
\value{
\code{dBilomaxPR} gives the probability density function for bivariate lomax random variables conditioned to the positive quadrant.

Invalid arguments will return an error message.
}
\description{
probability density function of quotient of Bivariate Lomax random variables  conditioned to the positive quadrant.For more detailed information please read the first reference paper.
}
\details{
Probability density function
\deqn{f_R (r \mid X > 0, Y > 0) = \frac {c^2 \theta^2 r}{\Pr (X > 0, Y > 0)} J_3 \left( \theta r, \beta - \theta a + \left( \alpha - \theta b \right) r, 1 - \alpha a - \beta b + \theta a b, c + 2 \right) +\frac {c^2 \theta \left[ (\alpha - \theta b) r + \beta - \theta a \right]} {\Pr (X > 0, Y > 0)} J_2 \left( \theta r, \beta - \theta a + \left( \alpha - \theta b \right) r, 1 - \alpha a - \beta b + \theta a b, c + 2 \right) +\frac {c \left[ c (\alpha - \theta b) (\beta - \theta a) + \alpha \beta - \theta \right]}{\Pr (X > 0, Y > 0)}J_1 \left( \theta r, \beta - \theta a + \left( \alpha - \theta b \right) r,1 - \alpha a - \beta b + \theta a b, c + 2 \right)}

For \eqn{r > 0},\eqn{\alpha > 0}, \eqn{\beta > 0}, \eqn{\theta > 0}, \eqn{0 \leq \theta \leq (c + 1) \alpha \beta} where \eqn{J_1,J_2,J_3} are given by  first reference paper section (2.5)
}
\references{
Yuancheng Si and Saralees Nadarajah and Xiaodong Song, (2020). On the distribution of quotient of random variables conditioned to the positive quadrant. \emph{Communications in Statistics - Theory and Methods}, \bold{49}, pp2514-2528.


Balakrishnan, N. and Lai, C. -D. (2009).\emph{Continuous Bivariate Distributions}.Springer Verlag, New York.
}
\author{
Saralees Nadarajah & Yuancheng Si \email{siyuanchengman@gmail.com}
}
