/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.examples.xml;

import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openfast.Context;
import org.openfast.FieldValue;
import org.openfast.GroupValue;
import org.openfast.Message;
import org.openfast.MessageOutputStream;
import org.openfast.SequenceValue;
import org.openfast.extensions.MapFieldParser;
import org.openfast.template.MessageTemplate;
import org.openfast.template.Sequence;
import org.openfast.template.TemplateRegistry;
import org.openfast.template.loader.XMLMessageTemplateLoader;

public class XmlToFastConverter {
    private final TemplateRegistry templateRegistry;
    private final MessageTemplate elementTemplate;
    private final int nodeNameIdx;
    private final int attributesIdx;
    private final int childrenIdx;
    private final int valueIdx;
    private final int attributeNameIdx;
    private final int attributeValueIdx;
    private final Sequence childrenSequence;
    private final Sequence attributesSequence;

    public XmlToFastConverter() {
        XMLMessageTemplateLoader xmlTemplateLoader = new XMLMessageTemplateLoader();
        xmlTemplateLoader.setLoadTemplateIdFromAuxId(true);
        xmlTemplateLoader.addFieldParser(new MapFieldParser());
        xmlTemplateLoader.load(this.getClass().getResourceAsStream("xmlOverFastTemplates.xml"));
        this.templateRegistry = xmlTemplateLoader.getTemplateRegistry();
        this.elementTemplate = this.templateRegistry.get("element");
        this.nodeNameIdx = this.elementTemplate.getFieldIndex("name");
        this.attributesIdx = this.elementTemplate.getFieldIndex("attributes");
        this.childrenSequence = this.elementTemplate.getSequence("children");
        this.attributesSequence = this.elementTemplate.getSequence("attributes");
        this.attributeNameIdx = this.attributesSequence.getGroup().getFieldIndex("name");
        this.attributeValueIdx = this.attributesSequence.getGroup().getFieldIndex("value");
        this.childrenIdx = this.elementTemplate.getFieldIndex("children");
        this.valueIdx = this.elementTemplate.getFieldIndex("value");
    }

    public void convert(InputStream in, OutputStream out) {
        try {
            HierarchicalStreamReader reader = new XppDriver().createReader(in);
            Context context = new Context();
            context.setTemplateRegistry(this.templateRegistry);
            MessageOutputStream messageOut = new MessageOutputStream(out, context);
            Message message = this.convertElementToMessage(reader);
            messageOut.writeMessage(message);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            try {
                out.close();
            }
            catch (IOException iOException) {}
        }
    }

    private Message convertElementToMessage(HierarchicalStreamReader reader) {
        Message message = new Message(this.elementTemplate);
        message.setString(this.nodeNameIdx, reader.getNodeName());
        SequenceValue attributes = new SequenceValue(this.attributesSequence);
        int i = 0;
        while (i < reader.getAttributeCount()) {
            GroupValue attribute = new GroupValue(this.attributesSequence.getGroup());
            attribute.setString(this.attributeNameIdx, reader.getAttributeName(i));
            attribute.setString(this.attributeValueIdx, reader.getAttribute(i));
            attributes.add(attribute);
            ++i;
        }
        message.setFieldValue(this.attributesIdx, (FieldValue)attributes);
        if (reader.getValue() != null && !"".equals(reader.getValue())) {
            message.setString(this.valueIdx, reader.getValue());
        }
        SequenceValue children = new SequenceValue(this.childrenSequence);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            GroupValue childValue = new GroupValue(this.childrenSequence.getGroup());
            Message child = this.convertElementToMessage(reader);
            childValue.setFieldValue(0, (FieldValue)child);
            children.add(childValue);
            reader.moveUp();
        }
        message.setFieldValue(this.childrenIdx, (FieldValue)children);
        return message;
    }
}

