/*
 * Decompiled with CFR 0.152.
 */
package org.openfast;

import org.openfast.BitVector;

public class BitVectorReader {
    public static final BitVectorReader NULL = new BitVectorReader(null){

        public boolean read() {
            throw new IllegalStateException();
        }

        public boolean hasMoreBitsSet() {
            return false;
        }
    };
    public static final BitVectorReader INFINITE_TRUE = new BitVectorReader(null){

        public boolean read() {
            return true;
        }
    };
    private final BitVector vector;
    private int index = 0;

    public BitVectorReader(BitVector vector) {
        this.vector = vector;
    }

    public boolean read() {
        return this.vector.isSet(this.index++);
    }

    public BitVector getBitVector() {
        return this.vector;
    }

    public boolean hasMoreBitsSet() {
        return this.vector.indexOfLastSet() > this.index;
    }

    public String toString() {
        return this.vector.toString();
    }

    public boolean peek() {
        return this.vector.isSet(this.index);
    }

    public int getIndex() {
        return this.index;
    }
}

