/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.portfolio;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.portfolioeffect.quant.client.ClientConnection;
import com.portfolioeffect.quant.client.model.ConnectFailedException;
import com.portfolioeffect.quant.client.portfolio.ArrayCache;
import com.portfolioeffect.quant.client.portfolio.CacheKey;
import com.portfolioeffect.quant.client.portfolio.PortfolioContainer;
import com.portfolioeffect.quant.client.portfolio.PortfolioData;
import com.portfolioeffect.quant.client.portfolio.Position;
import com.portfolioeffect.quant.client.result.LazyMetric;
import com.portfolioeffect.quant.client.result.Metric;
import com.portfolioeffect.quant.client.util.Console;
import com.portfolioeffect.quant.client.util.DateTimeUtil;
import com.portfolioeffect.quant.client.util.LazyMetricBuilder;
import com.portfolioeffect.quant.client.util.MetricUpdateCallback;
import com.portfolioeffect.quant.client.util.SimpleMetricUpdateCallback;
import com.portfolioeffect.quant.client.util.Util;
import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class Portfolio {
    private PortfolioContainer container;

    public boolean isBatchOn() {
        return this.container.isBatchOn;
    }

    public void setAutoBatchEnabled(boolean isEnabled) {
        this.container.isBatchOn = isEnabled;
    }

    public void del() {
        this.container = null;
    }

    public Portfolio(Portfolio portfolio) throws Exception {
        this(new PortfolioContainer(portfolio.container));
    }

    public Portfolio(PortfolioContainer portfolio) {
        this.container = portfolio;
    }

    public Portfolio(ClientConnection clientConnection) {
        this.container = new PortfolioContainer(clientConnection);
        this.setDefaultParams();
    }

    public Portfolio(ClientConnection clientConnection, String fromTime, String toTime, String indexName) {
        this.container = new PortfolioContainer(clientConnection);
        this.setDefaultParams();
        this.setFromTime(fromTime);
        this.setToTime(toTime);
        this.addIndex(indexName);
    }

    public Portfolio(ClientConnection clientConnection, String fromTime, String toTime) {
        this(clientConnection, fromTime, toTime, "SPY");
    }

    private void setDefaultParams() {
        this.clearCache();
        this.container.portfolioData.setFromTime("#");
        this.container.portfolioData.setToTime("#");
    }

    private String getMetricTypeList(String metric) throws Exception {
        String result = "";
        try {
            Gson gson = new Gson();
            Type mapTypeMetrics = new TypeToken<HashMap<String, String>>(){}.getType();
            HashMap metricArgs = (HashMap)gson.fromJson(metric, mapTypeMetrics);
            ArrayList<HashMap> paramsArgs = new ArrayList<HashMap>();
            paramsArgs.add(metricArgs);
            result = gson.toJson(paramsArgs);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage().split(":")[1]);
        }
        return result;
    }

    private String getFullMetricType(String metric) throws Exception {
        String result = "";
        try {
            Gson gson = new Gson();
            Type mapTypeMetrics = new TypeToken<HashMap<String, String>>(){}.getType();
            HashMap metricArgsGson = (HashMap)gson.fromJson(metric, mapTypeMetrics);
            HashMap<String, String> metricArgs = new HashMap<String, String>(this.container.portfolioData.getSettings());
            for (String e : metricArgs.keySet()) {
                Util.putIfAbsent(metricArgsGson, e, metricArgs.get(e));
            }
            result = gson.toJson((Object)metricArgsGson);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage().split(":")[1]);
        }
        return result;
    }

    private String getMetricTypeList(ArrayList<String> metrics) throws Exception {
        String result = "";
        try {
            Gson gson = new Gson();
            ArrayList<HashMap> paramsArgs = new ArrayList<HashMap>();
            for (String e : metrics) {
                Type mapTypeMetrics = new TypeToken<HashMap<String, String>>(){}.getType();
                HashMap metricArgsGson = (HashMap)gson.fromJson(e, mapTypeMetrics);
                paramsArgs.add(metricArgsGson);
            }
            result = gson.toJson(paramsArgs);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage().split(":")[1]);
        }
        return result;
    }

    public boolean isMultiBatch() {
        return this.container.isMultiBatch;
    }

    public void setMultiBatchEnabled(boolean isMultiBatch) {
        this.container.isMultiBatch = isMultiBatch;
    }

    public void setParam(String key, String value) {
        if (this.container.portfolioData.containsParam(key) && this.container.portfolioData.getParam(key).equals(value)) {
            return;
        }
        if (!this.container.isMultiBatch || this.container.portfolioData.checkEstimatorParams(key)) {
            this.clearCache();
        }
        if (key.equals("windowLength")) {
            this.updateBurnWindowLength(Portfolio.parseWindowLength(value));
        }
        this.container.portfolioData.setParam(key, value);
        if (key.equals("samplingInterval")) {
            this.removeUserData("sampligTimes");
        }
    }

    private void updateBurnWindowLength(int windowLength) {
        this.container.windowLength = Math.max(this.container.windowLength, windowLength);
    }

    private void updateBurnWindowLength(String windowLength, String rollingWindow) {
        int w = Portfolio.parseWindowLength(windowLength);
        int rw = Portfolio.parseWindowLength(rollingWindow);
        this.container.windowLength = Math.max(this.container.windowLength, w + rw);
    }

    public void removeParam(String key) {
        this.clearCache();
        this.container.portfolioData.removeParam(key);
    }

    public String getParam(String key) {
        if (this.container.portfolioData.containsParam(key)) {
            return this.container.portfolioData.getParam(key);
        }
        return "";
    }

    public void setPortfolioSettings(Map<String, String> map) {
        this.clearCache();
        this.container.portfolioData.setSettings(new HashMap<String, String>(map));
    }

    public void setPortfolioSettings(String settingsJSON) {
        this.clearCache();
        this.container.portfolioData.setSettingJSON(settingsJSON);
    }

    public HashMap<String, String> getPortfolioSettings() {
        return this.container.portfolioData.getSettings();
    }

    public String getPortfolioSettingsJSON() {
        return this.container.portfolioData.getSettingJSON();
    }

    public Metric addIndex(String assetName) {
        this.clearCache();
        if (this.container.portfolioData.getIndexPrice() != null) {
            this.container.portfolioData.setIndexPrice(null);
            this.container.portfolioData.setIndexTimeMillisec(null);
        }
        this.container.portfolioData.getPriceID().put(assetName, this.container.portfolioData.getNextDataId());
        this.container.portfolioData.setIndexSymbol(assetName);
        return new Metric();
    }

    public Metric addIndex(double[] indexPrice, long timeStepMilliSec) {
        this.clearCache();
        long[] timeMilliSec = new long[indexPrice.length];
        int i = 0;
        while (i < indexPrice.length) {
            timeMilliSec[i] = (long)i * timeStepMilliSec + 1000L;
            ++i;
        }
        return this.addIndex(indexPrice, timeMilliSec);
    }

    public Metric addIndex(double[] price, long[] timeMilliSec) {
        this.clearCache();
        if (this.container.portfolioData.getIndexPrice() != null) {
            this.container.portfolioData.setIndexPrice(null);
            this.container.portfolioData.setIndexTimeMillisec(null);
        }
        if (price.length == 0) {
            return new Metric("Wrong length of price vector.");
        }
        if (timeMilliSec.length == 0) {
            return new Metric("Wrong length of time vector.");
        }
        if (timeMilliSec.length != price.length) {
            return new Metric("Length of price and time vector must be the same.");
        }
        try {
            this.container.portfolioData.setIndexPrice(new ArrayCache(price));
            this.container.portfolioData.setIndexTimeMillisec(new ArrayCache(timeMilliSec));
        }
        catch (IOException e) {
            return this.processException(e);
        }
        this.container.portfolioData.setIndexSymbol("index");
        this.container.portfolioData.getPriceID().put("index", this.container.portfolioData.getNextDataId());
        return new Metric();
    }

    public Metric addIndex(float[] indexPrice, long timeStepMilliSec) {
        this.clearCache();
        long[] timeMilliSec = new long[indexPrice.length];
        int i = 0;
        while (i < indexPrice.length) {
            timeMilliSec[i] = (long)i * timeStepMilliSec + 1000L;
            ++i;
        }
        return this.addIndex(indexPrice, timeMilliSec);
    }

    public Metric addIndex(float[] price, long[] timeMilliSec) {
        this.clearCache();
        if (this.container.portfolioData.getIndexPrice() != null) {
            this.container.portfolioData.setIndexPrice(null);
            this.container.portfolioData.setIndexTimeMillisec(null);
        }
        if (price.length == 0) {
            return new Metric("Wrong length of price vector.");
        }
        if (timeMilliSec.length == 0) {
            return new Metric("Wrong length of time vector.");
        }
        if (timeMilliSec.length != price.length) {
            return new Metric("Length of price and time vector must be the same.");
        }
        try {
            this.container.portfolioData.setIndexPrice(new ArrayCache(price));
            this.container.portfolioData.setIndexTimeMillisec(new ArrayCache(timeMilliSec));
        }
        catch (IOException e) {
            return this.processException(e);
        }
        this.container.portfolioData.setIndexSymbol("index");
        this.container.portfolioData.getPriceID().put("index", this.container.portfolioData.getNextDataId());
        return new Metric();
    }

    public ClientConnection getClient() {
        return this.container.clientConnection;
    }

    public void clearCache() {
        try {
            this.container = new PortfolioContainer(this.container);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.container.clearCache();
    }

    public Metric addPosition(String[] assetName, int[] quantity) {
        this.clearCache();
        int i = 0;
        while (i < assetName.length) {
            Metric result = this.addPosition(assetName[i], quantity[i]);
            if (result.hasError()) {
                return result;
            }
            ++i;
        }
        return new Metric();
    }

    public Metric addPosition(String assetName, int quantity) {
        this.clearCache();
        if (this.container.portfolioData.getIndexSymbol() == null) {
            return new Metric("Add index first");
        }
        int[] quantityArray = new int[]{quantity};
        long[] quantityTime = new long[]{-1L};
        return this.addPosition(assetName, quantityArray, quantityTime);
    }

    public Metric addPosition(String assetName, int[] quantity, long[] timeMillSec) {
        this.clearCache();
        this.removePositionQuantity(assetName);
        this.removePositionPrice(assetName);
        this.container.portfolioData.getPriceID().put(assetName, this.container.portfolioData.getNextDataId());
        if (this.container.portfolioData.getIndexSymbol() == null) {
            return new Metric("Add index first");
        }
        Metric result = this.addQuantity(assetName, quantity, timeMillSec);
        this.container.portfolioData.getSymbolNamesList().add(assetName);
        return result;
    }

    public Metric setStreamQuantity(String assetName, int quantity) {
        return this.setStreamQuantity(assetName, quantity, System.currentTimeMillis() + DateTimeUtil.CLIENT_TIME_DELTA);
    }

    public Metric setStreamQuantity(String assetName, int quantity, String time) {
        return this.setStreamQuantity(assetName, quantity, DateTimeUtil.toPOSIXTimeWithDelta(time)[0]);
    }

    public Metric setStreamQuantity(String assetName, int quantity, long timeMilles) {
        try {
            this.container.clientConnection.transmitStreamQuantity(assetName, quantity, timeMilles);
            this.container.portfolioData.getSymbolQuantityMap().get(assetName).writeAsLong(new int[]{quantity});
            this.container.portfolioData.getSymbolQuantityTimeMap().get(assetName).write(new long[]{timeMilles});
            Thread.sleep(10L);
        }
        catch (Exception e) {
            return this.processException(e);
        }
        return new Metric();
    }

    private Metric addQuantity(String assetName, int[] quantity, long[] timeMillSec) {
        this.clearCache();
        this.container.portfolioData.getQuantityID().put(assetName, this.container.portfolioData.getNextDataId());
        if (timeMillSec.length != quantity.length) {
            return new Metric("Length of qunatity and time vector must be the same.");
        }
        try {
            ArrayCache cashQuantity = new ArrayCache(quantity);
            this.container.portfolioData.getSymbolQuantityMap().put(assetName, cashQuantity);
            ArrayCache cashQuantityTime = new ArrayCache(timeMillSec);
            this.container.portfolioData.getSymbolQuantityTimeMap().put(assetName, cashQuantityTime);
        }
        catch (IOException e) {
            return this.processException(e);
        }
        return new Metric();
    }

    private Metric addQuantity(String assetName, ArrayCache quantity, ArrayCache timeMillSec) {
        this.clearCache();
        this.container.portfolioData.getQuantityID().put(assetName, this.container.portfolioData.getNextDataId());
        this.container.portfolioData.getSymbolQuantityMap().put(assetName, quantity);
        this.container.portfolioData.getSymbolQuantityTimeMap().put(assetName, timeMillSec);
        return new Metric();
    }

    public Metric addPosition(String assetName, double[] price, int[] quantity, long[] timeMillSec) {
        return this.addPosition(assetName, price, timeMillSec, quantity, timeMillSec);
    }

    public Metric addPosition(String assetName, double[] price, int[] quantity, long timeStepMilliSec) {
        if (price.length != quantity.length) {
            return new Metric("Length of qunatity and time vector must be the same.");
        }
        long[] timeMilliSec = new long[price.length];
        int i = 0;
        while (i < price.length) {
            timeMilliSec[i] = (long)i * timeStepMilliSec + 1000L;
            ++i;
        }
        return this.addPosition(assetName, price, quantity, timeMilliSec);
    }

    public Metric addPosition(String assetName, double[] price, int quantity, long timeStepMilliSec) {
        long[] timeMilliSec = new long[price.length];
        int i = 0;
        while (i < price.length) {
            timeMilliSec[i] = (long)i * timeStepMilliSec + 1000L;
            ++i;
        }
        return this.addPosition(assetName, price, quantity, timeMilliSec);
    }

    public Metric addPosition(String assetName, double[] price, int quantity, long[] priceTimeMillSec) {
        int[] quantityArray = new int[]{quantity};
        long[] quantityTime = new long[]{-1L};
        return this.addPosition(assetName, price, priceTimeMillSec, quantityArray, quantityTime);
    }

    public Metric addPosition(String assetName, float[] price, int quantity, long[] priceTimeMillSec) {
        int[] quantityArray = new int[]{quantity};
        long[] quantityTime = new long[]{-1L};
        return this.addPosition(assetName, price, priceTimeMillSec, quantityArray, quantityTime);
    }

    public Metric addPosition(String assetName, double[] price, long[] priceTimeMillSec, int[] quantity, long[] quantityTimeMillSec) {
        this.clearCache();
        this.container.portfolioData.getPriceID().put(assetName, this.container.portfolioData.getNextDataId());
        if (price.length == 0) {
            return new Metric("Wrong length of price vector.");
        }
        if (priceTimeMillSec.length == 0) {
            return new Metric("Wrong length of time vector.");
        }
        if (quantity.length == 0) {
            return new Metric("Wrong length of quantity vector.");
        }
        if (quantityTimeMillSec.length == 0) {
            return new Metric("Wrong length of quantity time vector.");
        }
        if (this.container.portfolioData.getIndexSymbol() == null) {
            return new Metric("Add index first.");
        }
        if (quantityTimeMillSec.length != quantity.length) {
            return new Metric("Length of qunatity and time vector must be the same.");
        }
        if (priceTimeMillSec.length != price.length) {
            return new Metric("Length of price and time vector must be the same.");
        }
        this.removePositionQuantity(assetName);
        this.removePositionPrice(assetName);
        Metric resultQuantity = this.addQuantity(assetName, quantity, quantityTimeMillSec);
        if (resultQuantity.hasError()) {
            return resultQuantity;
        }
        try {
            ArrayCache cashPrice = new ArrayCache(price);
            this.container.portfolioData.getSymbolPriceMap().put(assetName, cashPrice);
            ArrayCache cashPriceTime = new ArrayCache(priceTimeMillSec);
            this.container.portfolioData.getSymbolPriceTimeMap().put(assetName, cashPriceTime);
        }
        catch (IOException e) {
            return this.processException(e);
        }
        this.container.portfolioData.getSymbolNamesList().add(assetName);
        this.container.portfolioData.getUserPrice().add(assetName);
        return new Metric();
    }

    public Metric addPosition(String assetName, float[] price, long[] priceTimeMillSec, int[] quantity, long[] quantityTimeMillSec) {
        this.clearCache();
        this.container.portfolioData.getPriceID().put(assetName, this.container.portfolioData.getNextDataId());
        if (price.length == 0) {
            return new Metric("Wrong length of price vector.");
        }
        if (priceTimeMillSec.length == 0) {
            return new Metric("Wrong length of price time vector length.");
        }
        if (quantity.length == 0) {
            return new Metric("Wrong length of quantity vector.");
        }
        if (quantityTimeMillSec.length == 0) {
            return new Metric("Wrong length of quantity time vector.");
        }
        if (this.container.portfolioData.getIndexSymbol() == null) {
            return new Metric("Add index first.");
        }
        if (quantityTimeMillSec.length != quantity.length) {
            return new Metric("Length of qunatity and time vector must be the same.");
        }
        if (priceTimeMillSec.length != price.length) {
            return new Metric("Length of price and time vector must be the same.");
        }
        this.removePositionQuantity(assetName);
        this.removePositionPrice(assetName);
        Metric resultQuantity = this.addQuantity(assetName, quantity, quantityTimeMillSec);
        if (resultQuantity.hasError()) {
            return resultQuantity;
        }
        try {
            ArrayCache cashPrice = new ArrayCache(price);
            this.container.portfolioData.getSymbolPriceMap().put(assetName, cashPrice);
            ArrayCache cashPriceTime = new ArrayCache(priceTimeMillSec);
            this.container.portfolioData.getSymbolPriceTimeMap().put(assetName, cashPriceTime);
        }
        catch (IOException e) {
            return this.processException(e);
        }
        this.container.portfolioData.getSymbolNamesList().add(assetName);
        this.container.portfolioData.getUserPrice().add(assetName);
        return new Metric();
    }

    public Metric addUserData(String dataName, double[] value, long[] timeMillSec) {
        this.clearCache();
        this.container.portfolioData.getPriceID().put(dataName, this.container.portfolioData.getNextDataId());
        if (value.length == 0) {
            return new Metric("Wrong length of data vector.");
        }
        if (timeMillSec.length == 0) {
            return new Metric("Wrong length of time vector.");
        }
        if (value.length != timeMillSec.length) {
            return new Metric("Length of data and time vector must be the same.");
        }
        this.removeUserData(dataName);
        try {
            ArrayCache cashData = new ArrayCache(value);
            this.container.symbolUserDataMap.put(dataName, cashData);
            ArrayCache cashTime = new ArrayCache(timeMillSec);
            this.container.symbolUserDataTimeMap.put(dataName, cashTime);
        }
        catch (IOException e) {
            return this.processException(e);
        }
        this.container.userData.add(dataName);
        return new Metric();
    }

    public Metric addUserData(String dataName, ArrayCache value, ArrayCache timeMillSec) {
        this.clearCache();
        this.container.portfolioData.getPriceID().put(dataName, this.container.portfolioData.getNextDataId());
        if (value.getSize() == 0) {
            return new Metric("Wrong length of data vector.");
        }
        if (timeMillSec.getSize() == 0) {
            return new Metric("Wrong length of time vector.");
        }
        this.removeUserData(dataName);
        this.container.symbolUserDataMap.put(dataName, value);
        this.container.symbolUserDataTimeMap.put(dataName, timeMillSec);
        this.container.userData.add(dataName);
        return new Metric();
    }

    public void removePositionPrice(String symbol) {
        this.clearCache();
        if (this.container.portfolioData.getSymbolNamesList().contains(symbol)) {
            if (this.container.portfolioData.getUserPrice().contains(symbol)) {
                this.container.portfolioData.getUserPrice().remove(symbol);
                this.container.portfolioData.getSymbolPriceMap().remove(symbol);
                this.container.portfolioData.getSymbolPriceTimeMap().remove(symbol);
                this.container.portfolioData.getSymbolNamesList().remove(symbol);
            }
            this.container.portfolioData.getSymbolNamesList().remove(symbol);
        }
    }

    public void removeUserData(String symbol) {
        this.clearCache();
        if (this.container.userData.contains(symbol)) {
            this.container.userData.remove(symbol);
            this.container.symbolUserDataMap.remove(symbol);
            this.container.symbolUserDataTimeMap.remove(symbol);
        }
    }

    public void removePositionQuantity(String symbol) {
        this.clearCache();
        if (this.container.portfolioData.getSymbolNamesList().contains(symbol)) {
            this.container.portfolioData.getSymbolQuantityMap().remove(symbol);
            this.container.portfolioData.getSymbolQuantityTimeMap().remove(symbol);
        }
    }

    public Metric setPositionQuantity(String name, int quantity) {
        int[] quantityArray = new int[]{quantity};
        long[] quantityTime = new long[]{-1L};
        return this.setPositionQuantity(name, quantityArray, quantityTime);
    }

    public Metric setPositionQuantity(String name, int[] quantity, long[] timeMillesc) {
        this.clearCache();
        if (this.container.portfolioData.getSymbolNamesList().contains(name)) {
            this.removePositionQuantity(name);
            return this.addQuantity(name, quantity, timeMillesc);
        }
        return new Metric(String.format("Position for symbol %s not found.", name));
    }

    public Metric setPositionQuantity(String name, ArrayCache quantity, ArrayCache timeMillesc) {
        this.clearCache();
        if (this.container.portfolioData.getSymbolNamesList().contains(name)) {
            this.removePositionQuantity(name);
            return this.addQuantity(name, quantity, timeMillesc);
        }
        return new Metric(String.format("Position for symbol %s not found.", name));
    }

    public Metric setPositionQuantity(String name, double[] quantityD, long[] timeMillesc) {
        this.clearCache();
        int[] quantity = new int[quantityD.length];
        int i = 0;
        while (i < quantity.length) {
            quantity[i] = (int)quantityD[i];
            ++i;
        }
        if (this.container.portfolioData.getSymbolNamesList().contains(name)) {
            this.removePositionQuantity(name);
            return this.addQuantity(name, quantity, timeMillesc);
        }
        return new Metric(String.format("Position for symbol %s not found.", name));
    }

    public Metric setPositionQuantity(String name, int[] quantity, String[] timeMillesc) {
        this.clearCache();
        if (this.container.portfolioData.getUserPrice().contains(name)) {
            long[] time;
            double[] price;
            try {
                price = this.container.portfolioData.getSymbolPriceMap().get(name).getDoubleArray();
                time = this.container.portfolioData.getSymbolPriceTimeMap().get(name).getLongArray();
            }
            catch (Exception e) {
                return new Metric(e.getMessage());
            }
            return this.addPosition(name, price, time, quantity, DateTimeUtil.toPOSIXTime(timeMillesc));
        }
        return this.addPosition(name, quantity, DateTimeUtil.toPOSIXTime(timeMillesc));
    }

    public PortfolioData getPortfolioData() {
        return this.container.portfolioData;
    }

    public Portfolio setMetricKey(String key) {
        this.container.batchMetricKey = key;
        return this;
    }

    public void addMetricToBatch(String metricType) {
        try {
            metricType = this.getFullMetricType(metricType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.container.batchMetricsPortfolio != null || this.container.batchMetricsPosition != null) {
            if (metricType.contains("PORTFOLIO")) {
                this.container.batchMetricsPortfolio.add(metricType);
                if (this.container.batchMetricKey != null) {
                    this.container.batchMetricPortfolioKeys.add(this.container.batchMetricKey);
                    this.container.batchMetricKey = null;
                } else {
                    this.container.batchMetricPortfolioKeys.add(metricType);
                }
            }
            if (metricType.contains("POSITION") || metricType.contains("INDEX")) {
                this.container.batchMetricsPosition.add(metricType);
                if (this.container.batchMetricKey != null) {
                    this.container.batchMetricPositionKeys.add(this.container.batchMetricKey);
                    this.container.batchMetricKey = null;
                } else {
                    this.container.batchMetricPositionKeys.add(metricType);
                }
            }
        }
    }

    public void addMetricToBatch(Map<String, String> metricType) {
        Gson gson = new Gson();
        this.addMetricToBatch(gson.toJson(metricType));
    }

    public Metric runBatch(List<Map<String, String>> metrics) {
        this.startBatch();
        for (Map<String, String> e : metrics) {
            this.addMetricToBatch(e);
        }
        return this.finishBatch();
    }

    public List<LazyMetric> runBatchLazy(List<Map<String, String>> metrics) {
        Type mapType = new TypeToken<HashMap<String, String>>(){}.getType();
        Gson gson = new Gson();
        ArrayList<LazyMetric> result = new ArrayList<LazyMetric>();
        for (Map<String, String> map : metrics) {
            LazyMetricBuilder builder = new LazyMetricBuilder(map);
            result.add(this.getLazyMetric(builder));
        }
        for (LazyMetric lazyMetric : result) {
            lazyMetric.compute();
        }
        return result;
    }

    public Metric runBatch(List<Map<String, String>> metrics, List<String> metricKeys) {
        this.startBatch();
        int i = 0;
        for (Map<String, String> e : metrics) {
            this.setMetricKey(metricKeys.get(i));
            ++i;
            this.addMetricToBatch(e);
        }
        return this.finishBatch();
    }

    public Metric runBatchList(List<String> metrics, List<String> metricKeys) {
        this.startBatch();
        int i = 0;
        for (String e : metrics) {
            this.setMetricKey(metricKeys.get(i));
            ++i;
            this.addMetricToBatch(e);
        }
        return this.finishBatch();
    }

    public Metric runBatchList(List<String> metrics) {
        this.startBatch();
        for (String e : metrics) {
            this.addMetricToBatch(e);
        }
        return this.finishBatch();
    }

    public Metric runBatch(String metricsStr) {
        Gson gson = new Gson();
        Type mapType = new TypeToken<List<Map<String, String>>>(){}.getType();
        List list = (List)gson.fromJson(metricsStr, mapType);
        return this.runBatch(list);
    }

    public Metric runBatch(String metricsStr, String metricsKeys) {
        Gson gson = new Gson();
        Type mapType = new TypeToken<List<Map<String, String>>>(){}.getType();
        List list = (List)gson.fromJson(metricsStr, mapType);
        mapType = new TypeToken<List<String>>(){}.getType();
        List keys = (List)gson.fromJson(metricsKeys, mapType);
        return this.runBatch(list, keys);
    }

    public Metric getMetric(Map<String, String> metricType) {
        Gson gson = new Gson();
        Metric result = this.getMetric(gson.toJson(metricType), "");
        return result;
    }

    public Metric getMetric(String metricType) {
        try {
            metricType = this.getFullMetricType(metricType);
        }
        catch (Exception e) {
            Console.writeln(e.getMessage());
        }
        if (this.container.isBatchStart) {
            this.addMetricToBatch(metricType);
            return new Metric();
        }
        Metric result = this.getMetric(metricType, "");
        result.setDebug(this.container.isDebug);
        return result;
    }

    private String selectPortfolioParamsT(String metricType) {
        Gson gson = new Gson();
        Type mapTypeMetrics = new TypeToken<HashMap<String, String>>(){}.getType();
        HashMap argsGson = (HashMap)gson.fromJson(metricType, mapTypeMetrics);
        HashMap argsGsonNew = new HashMap(argsGson);
        for (String e : argsGson.keySet()) {
            if (!this.container.portfolioData.checkPortfolioParams(e)) continue;
            this.setParam(e, (String)argsGson.get(e));
            argsGsonNew.remove(e);
        }
        metricType = gson.toJson(argsGsonNew, mapTypeMetrics);
        return metricType;
    }

    public LazyMetric getLazyMetric(LazyMetricBuilder metricBuilder) {
        HashMap<String, String> portfolioSetting = new HashMap<String, String>(this.container.portfolioData.getPortfolioSettings());
        HashMap<String, String> estimatorSetting = new HashMap<String, String>(this.container.portfolioData.getEstimatorSettings());
        String metricTypeB = metricBuilder.getParam("metricType");
        metricBuilder.removeParam("metricType");
        this.updateBurnWindowLength(metricBuilder.getActualWindowLenght());
        String metricType = this.selectPortfolioParamsT(metricBuilder.getJsonString());
        metricBuilder.setParam("metricType", metricTypeB);
        try {
            String metricTypeFull = this.getFullMetricType(metricType);
            if (this.isContainsResult(metricTypeFull)) {
                this.container.portfolioData.setPortfolioSettings(portfolioSetting);
                this.container.portfolioData.setEstimatorSettings(estimatorSetting);
                return new LazyMetric(this.container, metricType, metricTypeFull, metricBuilder);
            }
            if (!this.container.isBatchStart) {
                this.startBatch();
            }
            LazyMetric result = new LazyMetric(this.container, metricType, metricTypeFull, metricBuilder);
            this.addMetricToBatch(metricTypeFull);
            if (!this.isBatchOn()) {
                this.finishBatch();
            }
            if (this.isMultiBatch()) {
                this.container.portfolioData.setPortfolioSettings(portfolioSetting);
                this.container.portfolioData.setEstimatorSettings(estimatorSetting);
            }
            return result;
        }
        catch (Exception e) {
            this.container.portfolioData.setPortfolioSettings(portfolioSetting);
            this.container.portfolioData.setEstimatorSettings(estimatorSetting);
            return new LazyMetric("Exception error:" + e.getMessage());
        }
    }

    public String getStrRequest(LazyMetricBuilder metricBuilder) {
        String metricTypeFull;
        HashMap<String, String> portfolioSetting = new HashMap<String, String>(this.container.portfolioData.getPortfolioSettings());
        HashMap<String, String> estimatorSetting = new HashMap<String, String>(this.container.portfolioData.getEstimatorSettings());
        String metricTypeB = metricBuilder.getParam("metricType");
        metricBuilder.removeParam("metricType");
        this.updateBurnWindowLength(metricBuilder.getActualWindowLenght());
        String metricType = this.selectPortfolioParamsT(metricBuilder.getJsonString());
        metricBuilder.setParam("metricType", metricTypeB);
        try {
            metricTypeFull = this.getFullMetricType(metricType);
        }
        catch (Exception e) {
            this.container.portfolioData.setPortfolioSettings(portfolioSetting);
            this.container.portfolioData.setEstimatorSettings(estimatorSetting);
            return "Exception error:" + e.getMessage();
        }
        return metricTypeFull;
    }

    private void processNoCashError(String str) throws Exception {
        if (str.contains("No data in cache")) {
            throw new Exception(str);
        }
    }

    private Metric transmitData(ArrayList<String> dataList) throws Exception {
        String[] dataTransmit;
        String windowLength = String.valueOf(this.container.windowLength) + "s";
        String priceSamplingInterval = this.getParam("priceSamplingInterval");
        String momentsModel = this.getParam("riskMethodology");
        Metric result = this.container.clientConnection.transmitDataList(this.container.portfolioData.getFromTime(), this.container.portfolioData.getToTime(), dataList, windowLength, priceSamplingInterval, momentsModel, this.getTrainingModel());
        if (result.hasError()) {
            this.processNoCashError(result.getErrorMessage());
            return result;
        }
        if (result.getMessage().length() == 0) {
            return new Metric();
        }
        Gson gson = new Gson();
        Type mapType = new TypeToken<String[]>(){}.getType();
        String[] stringArray = dataTransmit = (String[])gson.fromJson(result.getMessage(), mapType);
        int n = dataTransmit.length;
        int n2 = 0;
        while (n2 < n) {
            String position;
            String e = stringArray[n2];
            String[] ePars = e.split("-");
            if (ePars[0].equals("h") || ePars[0].equals("hI")) {
                result = new Metric("Error with historical price.");
                if (result.hasError()) {
                    this.processNoCashError(result.getErrorMessage());
                    return result;
                }
            } else if (ePars[0].equals("u")) {
                position = ePars[1].split(":")[1];
                if (position.equals("index")) {
                    result = this.container.clientConnection.transmitUserPrice(ePars[1], this.container.portfolioData.getIndexPrice().getDoubleAsFloatArray(), this.container.portfolioData.getIndexTimeMillisec().getLongArray());
                    if (result.hasError()) {
                        this.processNoCashError(result.getErrorMessage());
                        return result;
                    }
                } else {
                    ArrayCache cache = this.container.portfolioData.getSymbolPriceMap().get(position);
                    if (cache == null) {
                        cache = this.container.symbolUserDataMap.get(position);
                    }
                    if (cache == null) {
                        throw new Exception(String.format("Price values for symbol %s not found.", position));
                    }
                    float[] price = cache.getDoubleAsFloatArray();
                    cache = this.container.portfolioData.getSymbolPriceTimeMap().get(position);
                    if (cache == null) {
                        cache = this.container.symbolUserDataTimeMap.get(position);
                    }
                    if (cache == null) {
                        throw new Exception(String.format("Time values for symbol %s not found.", position));
                    }
                    long[] time = cache.getLongArray();
                    if (price == null || time == null) {
                        throw new Exception(String.format("Price values for symbol %s not found.", position));
                    }
                    result = this.container.clientConnection.transmitUserPrice(ePars[1], price, time);
                    if (result.hasError()) {
                        this.processNoCashError(result.getErrorMessage());
                        return result;
                    }
                }
            } else if (ePars[0].equals("q")) {
                position = ePars[1].split(":")[1];
                ArrayCache xq = this.container.portfolioData.getSymbolQuantityMap().get(position);
                if (xq == null) {
                    throw new Exception(String.format("Quantity values for symbol %s not found.", position));
                }
                int[] quantity = xq.getIntArray();
                ArrayCache xt = this.container.portfolioData.getSymbolQuantityTimeMap().get(position);
                if (xt == null) {
                    throw new Exception(String.format("Time values for symbol %s not found.", position));
                }
                long[] time = xt.getLongArray();
                result = this.container.clientConnection.transmitQuantity(ePars[1], quantity, time);
                if (result.hasError()) {
                    this.processNoCashError(result.getErrorMessage());
                    return result;
                }
            } else {
                return new Metric("Error while transmitting data.");
            }
            ++n2;
        }
        return new Metric();
    }

    public boolean isContainsResult(String metricType) throws Exception {
        String metricTypeFull = this.getMetricTypeList(metricType);
        CacheKey key = new CacheKey(metricTypeFull, "");
        return this.container.portfolioCache.containsKey(key);
    }

    public Metric getMetric(String metricType, String params) {
        try {
            metricType = this.getFullMetricType(metricType);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.container.portfolioData.getFromTime().length() == 0 || this.container.portfolioData.getToTime().length() == 0) {
            this.container.clientConnection.resetProgressBar();
            return new Metric("Set time interval  first");
        }
        int ii = 0;
        while (ii < 20) {
            try {
                if (this.container.portfolioData.getSymbolNamesList().size() == 0) {
                    this.container.clientConnection.resetProgressBar();
                    return new Metric("Empty portfolio.");
                }
                String metricTypeFull = this.getMetricTypeList(metricType);
                String[] positions = null;
                CacheKey key = new CacheKey(metricTypeFull, params);
                if (this.container.portfolioCache.containsKey(key)) {
                    Metric result = new Metric();
                    result.setData("value", this.container.portfolioCache.getMetric(key));
                    result.setData("time", this.container.portfolioCache.getTime(key));
                    result.setDebug(this.container.isDebug);
                    result.setNaNFiltered(this.isNaNFiltered());
                    result.setNaN2Zero(this.isNaN2Zero());
                    return result;
                }
                this.container.clientConnection.printProgressBar(0.0);
                Metric result = this.container.clientConnection.validateStringRequest(metricTypeFull);
                if (result.hasError()) {
                    throw new Exception(result.getErrorMessage());
                }
                positions = result.getStringArray("positions");
                result = null;
                ArrayList<String> positionList = new ArrayList<String>();
                String indexPosition = "";
                if (Arrays.asList(positions).contains("@_ALL_PORTFOLIO_")) {
                    String[] firstSplit;
                    String position = "";
                    if (metricTypeFull.contains("position") && (firstSplit = metricTypeFull.split(":")).length == 2) {
                        firstSplit[1] = firstSplit[1].trim();
                        if (firstSplit[1].length() != 0) {
                            String[] secondSplit = firstSplit[1].split(",");
                            int i = 0;
                            while (i < secondSplit.length) {
                                String[] thirdSplit = secondSplit[i].split("=");
                                if (thirdSplit[0].trim().equals("position")) {
                                    position = thirdSplit[1].trim();
                                }
                                ++i;
                            }
                        }
                    }
                    if (position.length() != 0 && !this.container.portfolioData.getSymbolNamesList().contains(position)) {
                        this.container.clientConnection.resetProgressBar();
                        return new Metric(String.format("Position for symbol %s not found.", position));
                    }
                    if (position.length() != 0) {
                        positionList.add(position);
                    }
                    for (String symbol : this.container.portfolioData.getSymbolNamesList()) {
                        if (symbol.equals(position)) continue;
                        positionList.add(symbol);
                    }
                } else {
                    int i = 0;
                    while (i < positions.length) {
                        if (!positions[i].equals("@_INDEX_")) {
                            if (!this.container.portfolioData.getSymbolNamesList().contains(positions[i])) {
                                this.container.clientConnection.resetProgressBar();
                                return new Metric(String.format("Position for symbol %s not found.", positions[i]));
                            }
                            positionList.add(positions[i]);
                        }
                        ++i;
                    }
                }
                ArrayList<String> dataList = new ArrayList<String>();
                if (this.container.portfolioData.getIndexPrice() == null) {
                    dataList.add("hI-" + this.container.portfolioData.getPortfolioId() + ":" + this.container.portfolioData.getIndexSymbol() + ":" + this.container.portfolioData.getPriceID().get(this.container.portfolioData.getIndexSymbol()));
                    indexPosition = this.container.portfolioData.getIndexSymbol();
                } else {
                    dataList.add("u-" + this.container.portfolioData.getPortfolioId() + ":" + "index" + ":" + this.container.portfolioData.getPriceID().get(this.container.portfolioData.getIndexSymbol()));
                    indexPosition = "index";
                }
                for (String symbol : this.container.portfolioData.getSymbolNamesList()) {
                    if (this.container.portfolioData.getUserPrice().contains(symbol)) {
                        dataList.add("u-" + this.container.portfolioData.getPortfolioId() + ":" + symbol + ":" + this.container.portfolioData.getPriceID().get(symbol));
                    } else {
                        dataList.add("h-" + this.container.portfolioData.getPortfolioId() + ":" + symbol + ":" + this.container.portfolioData.getPriceID().get(symbol));
                    }
                    dataList.add("q-" + this.container.portfolioData.getPortfolioId() + ":" + symbol + ":" + this.container.portfolioData.getQuantityID().get(symbol));
                }
                ArrayList<String> positionNames = new ArrayList<String>();
                for (String e : positionList) {
                    if (this.container.portfolioData.getUserPrice().contains(e)) {
                        positionNames.add(String.valueOf(this.container.portfolioData.getPortfolioId()) + ":" + e + ":" + this.container.portfolioData.getPriceID().get(e) + "=" + this.container.portfolioData.getPortfolioId() + ":" + e + ":" + this.container.portfolioData.getQuantityID().get(e));
                        continue;
                    }
                    positionNames.add("h-" + this.container.portfolioData.getPortfolioId() + ":" + e + ":" + this.container.portfolioData.getPriceID().get(e) + "=" + this.container.portfolioData.getPortfolioId() + ":" + e + ":" + this.container.portfolioData.getQuantityID().get(e));
                }
                if (indexPosition.length() != 0) {
                    indexPosition = this.container.portfolioData.getIndexPrice() != null ? String.valueOf(this.container.portfolioData.getPortfolioId()) + ":" + indexPosition + ":" + this.container.portfolioData.getPriceID().get(indexPosition) + "=" + this.container.portfolioData.getPortfolioId() + ":" + indexPosition + ":" + this.container.portfolioData.getQuantityID().get(indexPosition) : "hI-" + this.container.portfolioData.getPortfolioId() + ":" + indexPosition + ":" + this.container.portfolioData.getPriceID().get(indexPosition) + "=" + this.container.portfolioData.getPortfolioId() + ":" + indexPosition + ":" + this.container.portfolioData.getQuantityID().get(indexPosition);
                }
                for (String e : this.container.userData) {
                    dataList.add("u-" + this.container.portfolioData.getPortfolioId() + ":" + e + ":" + this.container.portfolioData.getPriceID().get(e));
                    positionNames.add(String.valueOf(this.container.portfolioData.getPortfolioId()) + ":" + e + ":" + this.container.portfolioData.getPriceID().get(e));
                }
                Metric resultTransmit = this.transmitData(dataList);
                if (resultTransmit.hasError()) {
                    throw new Exception(resultTransmit.getErrorMessage());
                }
                result = this.container.clientConnection.estimateTransactional(metricTypeFull, indexPosition, positionNames, params);
                if (!result.hasError()) {
                    this.container.portfolioCache.addMetric(key, result.getDataArrayCacheArray("values")[0]);
                    this.container.portfolioCache.addTime(key, result.getDataArrayCacheArray("times")[0]);
                    this.container.cachedValueList.add(key);
                    Metric resultT = new Metric();
                    resultT.setData("value", result.getDataArrayCacheArray("values")[0]);
                    resultT.setData("time", result.getDataArrayCacheArray("times")[0]);
                    resultT.setInfo(result.getInfoParams());
                    resultT.setDebug(this.container.isDebug);
                    resultT.setNaNFiltered(this.isNaNFiltered());
                    resultT.setNaN2Zero(this.isNaN2Zero());
                    result = resultT;
                } else {
                    this.container.clientConnection.createCallGroup(1);
                }
                return result;
            }
            catch (Exception e) {
                Metric result = this.processException(e);
                if (!result.getErrorMessage().equals("Server too busy, try again later")) {
                    return result;
                }
                ++ii;
            }
        }
        this.container.clientConnection.resetProgressBar();
        return new Metric("Failed to complete estimation procedure - cannot connect to server. Server request failed due to a timeout.");
    }

    public Metric getAllSymbolsList() {
        int ii = 0;
        while (ii < 20) {
            CacheKey keyId = new CacheKey("[{name:\"allSymbolsId\"}]", "");
            CacheKey keyDescription = new CacheKey("[{name:\"allSymbolsDescription\"}]", "");
            CacheKey keyExchange = new CacheKey("[{name:\"allSymbolsExchange\"}]", "");
            if (this.container.portfolioCache.containsKey(keyId)) {
                Metric result = new Metric();
                result.setData("id", this.container.portfolioCache.getMetric(keyId));
                result.setData("description", this.container.portfolioCache.getMetric(keyDescription));
                result.setData("exchange", this.container.portfolioCache.getMetric(keyExchange));
                return result;
            }
            try {
                Metric result = this.container.clientConnection.getAllSymbolsList();
                this.container.portfolioCache.addMetric(keyId, result.getDataArrayCache("id"));
                this.container.portfolioCache.addMetric(keyDescription, result.getDataArrayCache("description"));
                this.container.portfolioCache.addMetric(keyExchange, result.getDataArrayCache("exchange"));
                return result;
            }
            catch (Exception e) {
                Metric result = this.processException(e);
                if (!result.getErrorMessage().equals("Server too busy, try again later")) {
                    return result;
                }
                ++ii;
            }
        }
        return new Metric("Failed to complete estimation procedure - cannot connect to server. Server request failed due to a timeout.");
    }

    public void clearBatchMetric() {
        this.container.batchMetricsPortfolio.clear();
        this.container.batchMetricsPosition.clear();
        this.container.batchMetricsPortfolio = null;
        this.container.batchMetricsPosition = null;
    }

    public Metric finishBatch() {
        if (!this.container.isBatchStart) {
            return new Metric();
        }
        if (this.container.clientConnection.isStreamEnabled().get()) {
            ClientConnection cfr_ignored_0 = this.container.clientConnection;
            return new Metric("Stream is already running");
        }
        this.container.isBatchStart = false;
        if (this.container.batchMetricsPortfolio == null && this.container.batchMetricsPosition == null) {
            return new Metric();
        }
        String factorModel = this.container.portfolioData.getParam("factorModel");
        if (factorModel == "sim" || factorModel == null) {
            this.container.batchMetricsPortfolio.addAll(this.container.batchMetricsPosition);
            this.container.batchMetricPortfolioKeys.addAll(this.container.batchMetricPositionKeys);
            Metric result = this.computeBatch(this.container.batchMetricsPortfolio, this.container.batchMetricPortfolioKeys);
            this.clearBatchMetric();
            return result;
        }
        if (this.getParam("stream").equals("on") && factorModel != "sim") {
            return new Metric("Streaming mode is supported only with SIM portfolio");
        }
        if (this.container.batchMetricsPortfolio.size() != 0 && this.container.batchMetricsPosition.size() != 0) {
            this.container.clientConnection.createCallGroup(2);
            Metric result = this.computeBatch(this.container.batchMetricsPortfolio);
            if (result.hasError()) {
                this.clearBatchMetric();
                this.container.clientConnection.createCallGroup(1);
                return result;
            }
            result = this.computeBatch(this.container.batchMetricsPosition);
            this.clearBatchMetric();
            this.container.clientConnection.createCallGroup(1);
            return result;
        }
        this.container.batchMetricsPortfolio.addAll(this.container.batchMetricsPosition);
        Metric result = this.computeBatch(this.container.batchMetricsPortfolio);
        this.clearBatchMetric();
        return result;
    }

    private Metric processException(Exception e) {
        if (this.container.isDebug && (e.getMessage() == null || !e.getMessage().equals("Cannot connect to server. Server request failed due to a timeout."))) {
            Console.writeStackTrace(e);
        }
        if (e instanceof ConnectFailedException) {
            Metric isRestarted = this.container.clientConnection.restart();
            if (isRestarted.hasError()) {
                this.container.clientConnection.resetProgressBar();
                return new Metric(isRestarted.getErrorMessage());
            }
            return new Metric("Server too busy, try again later");
        }
        if (e.getMessage() == null || e.getMessage().contains("No data in cache") || e.getMessage().contains("null")) {
            Metric isRestarted = this.container.clientConnection.restart();
            if (isRestarted.hasError()) {
                this.container.clientConnection.resetProgressBar();
                return new Metric(isRestarted.getErrorMessage());
            }
            return new Metric("Server too busy, try again later");
        }
        if (e.getMessage() == null) {
            Console.writeStackTrace(e);
            return new Metric("Unknown error.");
        }
        this.container.clientConnection.resetProgressBar();
        return new Metric(e.getMessage());
    }

    private Metric computeBatch(ArrayList<String> batchMetrics) {
        return this.computeBatch(batchMetrics, new ArrayList<String>());
    }

    private Metric computeBatch(ArrayList<String> batchMetrics, ArrayList<String> batchMetricKeys) {
        ArrayList<String> metricsTypeNewList = new ArrayList<String>();
        for (String e : batchMetrics) {
            CacheKey key;
            try {
                String metricTypeFull = this.getMetricTypeList(e);
                key = new CacheKey(metricTypeFull, "");
            }
            catch (Exception e1) {
                return this.processException(e1);
            }
            if (this.container.portfolioCache.containsKey(key) && !this.getParam("stream").equals("on")) continue;
            metricsTypeNewList.add(e);
        }
        if (metricsTypeNewList.size() == 0) {
            return new Metric();
        }
        batchMetrics.clear();
        this.container.clientConnection.printProgressBar(0.0);
        if (this.container.portfolioData.getFromTime().length() == 0 || this.container.portfolioData.getToTime().length() == 0) {
            this.container.clientConnection.resetProgressBar();
            return new Metric("Set time interval  first");
        }
        int ii = 0;
        while (ii < 20) {
            try {
                String metricsType = this.getMetricTypeList(metricsTypeNewList);
                if (this.container.portfolioData.getSymbolNamesList().size() == 0) {
                    this.container.clientConnection.resetProgressBar();
                    return new Metric("Empty portfolio.");
                }
                String[] positions = null;
                Metric result = this.container.clientConnection.validateStringRequest(metricsType);
                if (result.hasError()) {
                    throw new Exception(result.getErrorMessage());
                }
                positions = result.getStringArray("positions");
                result = null;
                ArrayList<String> positionList = new ArrayList<String>();
                String indexPosition = "";
                if (Arrays.asList(positions).contains("@_ALL_PORTFOLIO_")) {
                    for (String symbol : this.container.portfolioData.getSymbolNamesList()) {
                        positionList.add(symbol);
                    }
                } else {
                    int i = 0;
                    while (i < positions.length) {
                        if (!positions[i].equals("@_INDEX_")) {
                            if (!this.container.portfolioData.getSymbolNamesList().contains(positions[i])) {
                                this.container.clientConnection.resetProgressBar();
                                return new Metric(String.format("Position for symbol %s not found.", positions[i]));
                            }
                            positionList.add(positions[i]);
                        }
                        ++i;
                    }
                }
                ArrayList<String> positionNames = new ArrayList<String>();
                for (String e : positionList) {
                    if (this.container.portfolioData.getUserPrice().contains(e)) {
                        positionNames.add(String.valueOf(this.container.portfolioData.getPortfolioId()) + ":" + e + ":" + this.container.portfolioData.getPriceID().get(e) + "=" + this.container.portfolioData.getPortfolioId() + ":" + e + ":" + this.container.portfolioData.getQuantityID().get(e));
                        continue;
                    }
                    positionNames.add("h-" + this.container.portfolioData.getPortfolioId() + ":" + e + ":" + this.container.portfolioData.getPriceID().get(e) + "=" + this.container.portfolioData.getPortfolioId() + ":" + e + ":" + this.container.portfolioData.getQuantityID().get(e));
                }
                ArrayList<String> dataList = new ArrayList<String>();
                if (this.container.portfolioData.getIndexPrice() == null) {
                    dataList.add("hI-" + this.container.portfolioData.getPortfolioId() + ":" + this.container.portfolioData.getIndexSymbol() + ":" + this.container.portfolioData.getPriceID().get(this.container.portfolioData.getIndexSymbol()));
                    indexPosition = this.container.portfolioData.getIndexSymbol();
                } else {
                    dataList.add("u-" + this.container.portfolioData.getPortfolioId() + ":" + "index" + ":" + this.container.portfolioData.getPriceID().get(this.container.portfolioData.getIndexSymbol()));
                    indexPosition = "index";
                }
                for (String symbol : this.container.portfolioData.getSymbolNamesList()) {
                    if (this.container.portfolioData.getUserPrice().contains(symbol)) {
                        dataList.add("u-" + this.container.portfolioData.getPortfolioId() + ":" + symbol + ":" + this.container.portfolioData.getPriceID().get(symbol));
                    } else {
                        dataList.add("h-" + this.container.portfolioData.getPortfolioId() + ":" + symbol + ":" + this.container.portfolioData.getPriceID().get(symbol));
                    }
                    dataList.add("q-" + this.container.portfolioData.getPortfolioId() + ":" + symbol + ":" + this.container.portfolioData.getQuantityID().get(symbol));
                }
                if (indexPosition.length() != 0) {
                    indexPosition = this.container.portfolioData.getIndexPrice() != null ? String.valueOf(this.container.portfolioData.getPortfolioId()) + ":" + indexPosition + ":" + this.container.portfolioData.getPriceID().get(indexPosition) + "=" + this.container.portfolioData.getPortfolioId() + ":" + indexPosition + ":" + this.container.portfolioData.getQuantityID().get(indexPosition) : "hI-" + this.container.portfolioData.getPortfolioId() + ":" + indexPosition + ":" + this.container.portfolioData.getPriceID().get(indexPosition) + "=" + this.container.portfolioData.getPortfolioId() + ":" + indexPosition + ":" + this.container.portfolioData.getQuantityID().get(indexPosition);
                }
                for (String e : this.container.userData) {
                    dataList.add("u-" + this.container.portfolioData.getPortfolioId() + ":" + e + ":" + this.container.portfolioData.getPriceID().get(e));
                }
                for (String e : this.container.userData) {
                    dataList.add("u-" + this.container.portfolioData.getPortfolioId() + ":" + e + ":" + this.container.portfolioData.getPriceID().get(e));
                    positionNames.add(String.valueOf(this.container.portfolioData.getPortfolioId()) + ":" + e + ":" + this.container.portfolioData.getPriceID().get(e));
                }
                Metric resultTransmit = this.transmitData(dataList);
                if (resultTransmit.hasError()) {
                    throw new Exception(resultTransmit.getErrorMessage());
                }
                this.container.clientConnection.setBatchMetricKeys(batchMetricKeys, this.container.portfolioData.getPortfolioId());
                result = this.container.clientConnection.estimateTransactional(metricsType, indexPosition, positionNames, "");
                if (!result.hasError()) {
                    int k = 0;
                    while (k < result.getDataArrayCacheArray("values").length) {
                        String metricTypeFull = this.getMetricTypeList(metricsTypeNewList.get(k));
                        CacheKey key = new CacheKey(metricTypeFull, "");
                        this.container.portfolioCache.addMetric(key, result.getDataArrayCacheArray("values")[k]);
                        this.container.portfolioCache.addTime(key, result.getDataArrayCacheArray("times")[k]);
                        this.container.cachedValueList.add(key);
                        ++k;
                    }
                    metricsTypeNewList.clear();
                } else {
                    this.container.clientConnection.createCallGroup(1);
                }
                return new Metric();
            }
            catch (Exception e) {
                Metric result = this.processException(e);
                if (!result.getErrorMessage().equals("Server too busy, try again later")) {
                    return result;
                }
                ++ii;
            }
        }
        this.container.clientConnection.resetProgressBar();
        return new Metric("Failed to complete estimation procedure - cannot connect to server. Server request failed due to a timeout.");
    }

    private Metric processException(IOException e) {
        if (this.container.isDebug) {
            Console.writeStackTrace(e);
        }
        if (e.getMessage() != null) {
            return new Metric(e.getMessage());
        }
        return new Metric("Error while working with the local file system");
    }

    public LazyMetric getPDF(double from, double to, int number) throws Exception {
        return this.getPDF(from, to, number, "");
    }

    public LazyMetric getPDF(int number) throws Exception {
        return this.getPDF(0.0, 1.0, number, "");
    }

    public LazyMetric getPDF(int number, String position) throws Exception {
        return this.getPDF(0.0, 1.0, number, position);
    }

    public LazyMetric getPDF(double from, double to, int number, String position) throws Exception {
        int i;
        if (this.getSymbolNamesList().size() == 0) {
            return new LazyMetric("Empty portfolio.");
        }
        number = number > 300 ? 300 : number;
        HashMap<String, String> params = new HashMap<String, String>();
        String sampling = this.getSamplingInterval();
        Gson gson = new Gson();
        if (position.length() == 0) {
            params.put("metric", "PORTFOLIO_PDF");
        } else {
            params.put("metric", "POSITION_PDF");
            params.put("position", position);
        }
        params.put("from", "" + from);
        params.put("to", "" + to);
        params.put("number", "" + number);
        Metric result = this.getMetric(gson.toJson(params));
        long[] time = null;
        double[][] PDF = null;
        double[][] x = null;
        if (!result.hasError()) {
            time = result.getLongArray("time");
            PDF = new double[time.length][number];
            x = new double[time.length][number];
            ArrayCache qResult = result.getDataArrayCache("value");
            try {
                qResult.lockToRead();
                int j = 0;
                while (j < time.length) {
                    i = 0;
                    while (i < number) {
                        x[j][i] = qResult.getNextDouble();
                        PDF[j][i] = qResult.getNextDouble();
                        ++i;
                    }
                    ++j;
                }
                qResult.unlockToRead();
            }
            catch (Exception e) {
                if (this.isDebug()) {
                    Console.writeStackTrace(e);
                }
                if (e.getMessage() != null) {
                    return new LazyMetric(e.getMessage());
                }
                return new LazyMetric("Error while working with the local file system");
            }
        } else {
            return new LazyMetric(result.getErrorMessage());
        }
        if (sampling.equals("last")) {
            double[][] newPDF = new double[1][number];
            double[][] newX = new double[1][number];
            i = 0;
            while (i < number) {
                newPDF[0][i] = PDF[PDF.length - 1][i];
                newX[0][i] = x[x.length - 1][i];
                ++i;
            }
            PDF = newPDF;
            x = newX;
            long[] newTime = new long[]{time[time.length - 1]};
            time = newTime;
        }
        this.getClient().resetProgressBar();
        Metric resultP = new Metric();
        resultP.setData("time", new ArrayCache(time));
        resultP.setData("x", new ArrayCache(x));
        resultP.setData("pdf", new ArrayCache(PDF));
        return new LazyMetric(resultP);
    }

    public Metric getPositionQuantity(String symbol) {
        if (this.container.portfolioData.getSymbolQuantityMap().containsKey(symbol)) {
            try {
                double[] value = this.container.portfolioData.getSymbolQuantityMap().get(symbol).getIntAsDoubleArray();
                long[] time = this.container.portfolioData.getSymbolQuantityTimeMap().get(symbol).getLongArray();
                String samplingInterval = this.getParam("samplingInterval");
                if (samplingInterval.equals("last")) {
                    Metric result = new Metric();
                    result.setData("value", new ArrayCache(new double[]{value[value.length - 1]}));
                    result.setData("time", new ArrayCache(new long[]{time[time.length - 1]}));
                    return result;
                }
                Metric result = new Metric();
                result.setData("value", new ArrayCache(value));
                result.setData("time", new ArrayCache(time));
                return result;
            }
            catch (Exception e) {
                return this.processException(e);
            }
        }
        return new Metric(String.format("Position for symbol %s not found.", symbol));
    }

    public String[] getSymbols() {
        String[] names = new String[this.container.portfolioData.getSymbolNamesList().size()];
        int i = 0;
        Iterator<String> iterator = this.container.portfolioData.getSymbolNamesList().iterator();
        while (iterator.hasNext()) {
            String name;
            names[i] = name = iterator.next();
            ++i;
        }
        return names;
    }

    public int[] getQuantities() throws Exception {
        String[] positions = this.getSymbols();
        int[] quantities = new int[positions.length];
        int i = 0;
        while (i < positions.length) {
            quantities[i] = this.container.portfolioData.getSymbolQuantityMap().get(positions[i]).getIntArray()[0];
            ++i;
        }
        return quantities;
    }

    public void createCallGroup(int groupSize) {
        this.container.clientConnection.createCallGroup(groupSize);
    }

    public List<String> getSymbolNamesList() {
        return this.container.portfolioData.getSymbolNamesList();
    }

    public Map<String, ArrayCache> getSymbolQuantityMap() {
        return this.container.portfolioData.getSymbolQuantityMap();
    }

    public boolean isPriceJumpsFilterEnabled() {
        return this.getParam("isPriceJumpsFilterEnabled").equals("true");
    }

    public boolean isHoldingPeriodEnabled() {
        return this.getParam("isHoldingPeriodEnabled").equals("true");
    }

    public void setHoldingPeriodEnabled(boolean isHoldingPeriodEnabled) {
        this.setParam("isHoldingPeriodEnabled", String.valueOf(isHoldingPeriodEnabled));
    }

    public void setHoldingPeriodEnabled(String isHoldingPeriodEnabled) {
        this.setParam("isHoldingPeriodEnabled", isHoldingPeriodEnabled);
    }

    public String getFromTime() {
        return this.container.portfolioData.getFromTime();
    }

    public Metric setFromTime(String fromTime) {
        this.clearCache();
        this.updatePriceData();
        this.container.portfolioData.setFromTime("");
        if (fromTime.contains("t")) {
            if (fromTime.trim().equals("t")) {
                this.container.portfolioData.setFromTime(fromTime);
                return new Metric();
            }
            String[] a = fromTime.trim().split("-");
            try {
                this.container.portfolioData.setFromTime(fromTime);
                return new Metric();
            }
            catch (Exception e) {
                return new Metric(String.format("Wrong time format: fromTime= %s", fromTime));
            }
        }
        if (!fromTime.contains(":")) {
            String s = String.valueOf(fromTime.trim()) + " 09:30:01";
            try {
                Timestamp t = Timestamp.valueOf(s);
                this.container.portfolioData.setFromTime(fromTime);
                return new Metric();
            }
            catch (Exception e) {
                return new Metric(String.format("Wrong time format: fromTime= %s", fromTime));
            }
        }
        try {
            Timestamp s = Timestamp.valueOf(fromTime);
        }
        catch (Exception e) {
            return new Metric(String.format("Wrong time format: fromTime= %s", fromTime));
        }
        this.container.portfolioData.setFromTime(fromTime);
        return new Metric();
    }

    public String getToTime() {
        return this.container.portfolioData.getToTime();
    }

    public void updatePriceData() {
        this.clearCache();
        for (String e : this.container.portfolioData.getPriceID().keySet()) {
            if (this.container.portfolioData.getUserPrice().contains(e)) continue;
            this.container.portfolioData.getPriceID().put(e, this.container.portfolioData.getNextDataId());
        }
    }

    public Metric setToTime(String toTime) {
        this.clearCache();
        this.updatePriceData();
        this.container.portfolioData.setToTime("");
        if (toTime.contains("t")) {
            if (toTime.trim().equals("t")) {
                this.container.portfolioData.setToTime(toTime);
                return new Metric();
            }
            String[] a = toTime.trim().split("-");
            try {
                int daysBack = Integer.parseInt(a[1].split("d")[0]);
                this.container.portfolioData.setToTime(toTime);
                return new Metric();
            }
            catch (Exception e) {
                return new Metric(String.format("Wrong time format: toTime= %s", toTime));
            }
        }
        if (!toTime.contains(":")) {
            String s = String.valueOf(toTime.trim()) + " 09:30:01";
            try {
                Timestamp t = Timestamp.valueOf(s);
                this.container.portfolioData.setToTime(toTime);
                return new Metric();
            }
            catch (Exception e) {
                return new Metric(String.format("Wrong time format: toTime= %s", toTime));
            }
        }
        try {
            Timestamp s = Timestamp.valueOf(toTime);
        }
        catch (Exception e) {
            return new Metric(String.format("Wrong time format: toTime= %s", toTime));
        }
        this.container.portfolioData.setToTime(toTime);
        return new Metric();
    }

    public String getSamplingInterval() {
        return this.getParam("samplingInterval");
    }

    public void setSamplingInterval(String samplingIntervalServer) {
        this.setParam("samplingInterval", samplingIntervalServer);
        this.removeUserData("sampligTimes");
        this.container.samplingTimes = null;
    }

    public long[] getSamplingIntervalArray() {
        return this.container.samplingTimes;
    }

    public void setSamplingInterval(long[] samplingTimes) {
        this.clearCache();
        this.container.samplingTimes = samplingTimes;
        double[] value = new double[samplingTimes.length + 1];
        long[] time = new long[samplingTimes.length + 1];
        value[0] = 0.0;
        time[0] = samplingTimes[0] - 1000L;
        int i = 1;
        while (i < value.length) {
            value[i] = i;
            time[i] = samplingTimes[i - 1];
            ++i;
        }
        this.setParam("samplingInterval", "all");
        this.addUserData("sampligTimes", value, time);
    }

    public void startBatch() {
        if (this.container.clientConnection.isStreamEnabled().get()) {
            return;
        }
        if (this.container.isBatchStart) {
            return;
        }
        this.container.isBatchStart = true;
        this.container.batchMetricKey = null;
        this.container.batchMetricsPosition = new ArrayList();
        this.container.batchMetricsPortfolio = new ArrayList();
        this.container.batchMetricPortfolioKeys = new ArrayList();
        this.container.batchMetricPositionKeys = new ArrayList();
    }

    protected void finalize() throws Throwable {
        this.clearCache();
        super.finalize();
    }

    public boolean isNoiseModelEnabled() {
        return this.getParam("isNoiseModelEnabled").equals("true");
    }

    public void setNoiseModelEnabled(boolean isNoiseFilterEnabled) {
        this.setParam("isNoiseModelEnabled", String.valueOf(isNoiseFilterEnabled));
    }

    public void setNoiseModelEnabled(String isNoiseFilterEnabled) {
        this.setParam("isNoiseModelEnabled", isNoiseFilterEnabled);
    }

    public boolean isNonGaussianModelEnabled() {
        return this.getParam("isNonGaussianModelEnabled").equals("true");
    }

    public void setNonGaussianModelEnabled(boolean isNonGaussianModelEnabled) {
        this.setParam("isNonGaussianModelEnabled", String.valueOf(isNonGaussianModelEnabled));
    }

    public String getShortSalesMode() {
        return this.getParam("shortSalesMode");
    }

    public void setShortSalesMode(String shortSalesMode) {
        this.setParam("shortSalesMode", shortSalesMode);
    }

    public String getPriceSamplingInterval() {
        return this.getParam("priceSamplingInterval");
    }

    public void setPriceSamplingInterval(String priceSamplingInterval) {
        this.setParam("priceSamplingInterval", priceSamplingInterval);
    }

    public String getIndexSymbol() {
        return this.container.portfolioData.getIndexSymbol();
    }

    public void setFactorModel(String factorModel) {
        this.setParam("factorModel", factorModel);
    }

    public String getFactorModel() {
        return this.getParam("factorModel");
    }

    public boolean isJumpsModelEnabled() {
        return this.getParam("isJumpsModelEnabled").equals("true");
    }

    public void setJumpsModel(String jumpsModel) {
        this.setParam("jumpsModel", jumpsModel);
    }

    public String getJumpsModel() {
        return this.getParam("jumpsModel");
    }

    public void setWindowLength(String windowLengthString) {
        this.setParam("windowLength", windowLengthString);
    }

    public String getWindowLength() {
        return this.getParam("windowLength");
    }

    public void setTimeScale(String timeScaleSecString) {
        this.setParam("timeScale", timeScaleSecString);
    }

    public String getTimeScale() {
        return this.getParam("timeScale");
    }

    public boolean isDebug() {
        return this.container.isDebug;
    }

    public void setDebug(boolean isDebug) {
        this.container.isDebug = isDebug;
        this.container.clientConnection.setDebugModeEnabled(isDebug);
    }

    public long getNewDataId() {
        return this.container.portfolioData.getNextDataId();
    }

    public ClientConnection getClientConnection() {
        return this.container.clientConnection;
    }

    public void setClientConnection(ClientConnection clientConnection) {
        this.container.clientConnection = clientConnection;
    }

    public void setTxnCostPerShare(double value) {
        this.setParam("txnCostPerShare", String.valueOf(value));
    }

    public double getTxnCostPerShare() {
        return Double.valueOf(this.getParam("txnCostPerShare"));
    }

    public void setTxnCostFixed(double value) {
        this.setParam("txnCostFixed", String.valueOf(value));
    }

    public double getTxnCostFixed() {
        return Double.valueOf(this.getParam("txnCostFixed"));
    }

    public boolean isDriftEnabled() {
        return Boolean.valueOf(this.getParam("isDriftEnabled"));
    }

    public void setDriftEnabled(boolean isDriftEnabled) {
        this.setParam("isDriftEnabled", String.valueOf(isDriftEnabled));
    }

    public void setDriftEnabled(String isDriftEnabled) {
        this.setParam("isDriftEnabled", isDriftEnabled);
    }

    public void setRiskMethodology(String model) {
        this.setParam("riskMethodology", model);
        if (this.getParam("priceSamplingInterval").equals("") && model.equals("RiskMetrics")) {
            this.setParam("priceSamplingInterval", "1d");
        }
    }

    public String getRiskMethodology() {
        return this.getParam("riskMethodology");
    }

    public void setLambdaRiskMetrics(double lambda) {
        this.setParam("lambdaRiskMetrics", String.valueOf(lambda));
    }

    public double getLambdaRiskMetrics() {
        return Double.valueOf(this.getParam("lambdaRiskMetrics"));
    }

    public void setDensityApproxModel(String densityApproxModel) {
        this.setParam("densityApproxModel", densityApproxModel);
    }

    public String getDensityApproxModelString() {
        return this.getParam("densityApproxModel");
    }

    public void setPortfolioMetricsMode(String mode) {
        this.setParam("portfolioMetricsMode", mode);
    }

    public String getPortfolioMetricsMode() {
        return this.getParam("portfolioMetricsMode");
    }

    public void setStartWhenBurn(boolean mode) {
        this.setParam("isStartWhenBurn", "" + mode);
    }

    public boolean isStartWhenBurn() {
        return Boolean.valueOf(this.getParam("isStartWhenBurn"));
    }

    public void setFractalPriceModelEnabled(boolean flag) {
        this.setParam("isFractalPriceModelEnabled", "" + flag);
    }

    public void setFractalPriceModelEnabled(String flag) {
        this.setParam("isFractalPriceModelEnabled", flag);
    }

    public void setSynchonizationModelEnabled(String flag) {
        this.setParam("synchronizationModel", flag);
    }

    public void setSynchonizationModelEnabled(boolean flag) {
        this.setParam("synchronizationModel", "" + flag);
    }

    public boolean getSynchronizationModelEnabled() {
        return Boolean.parseBoolean(this.getParam("synchronizationModel"));
    }

    public void setSpotWindowLength(String value) {
        this.setParam("spotWindowLength", value);
    }

    public void setTrainingModel(boolean flag) {
        this.setParam("trainingModel", "" + flag);
    }

    public void setTrainingModel(String flag) {
        this.setParam("trainingModel", flag);
    }

    public String getTrainingModel() {
        return this.getParam("trainingModel");
    }

    public boolean isTrainingModel() {
        return Boolean.parseBoolean(this.getParam("trainingModel"));
    }

    public String getSpotWindowLength(String value) {
        return this.getParam("spotWindowLength");
    }

    public boolean isFractalPriceModelEnabled() {
        return Boolean.valueOf(this.getParam("isFractalPriceModelEnabled"));
    }

    public Metric findSymbols(String searchStr, int numResults) throws Exception {
        ArrayList<String> id = new ArrayList<String>();
        ArrayList<String> description = new ArrayList<String>();
        ArrayList<String> exchange = new ArrayList<String>();
        Metric allSymbols = this.getAllSymbolsList();
        String[] idStrings = allSymbols.getStringArray("id");
        String[] descriptionString = allSymbols.getStringArray("description");
        String[] exchangeString = allSymbols.getStringArray("exchange");
        int i = 0;
        while (i < idStrings.length) {
            if (StringUtils.containsIgnoreCase((String)idStrings[i], (String)searchStr) || StringUtils.containsIgnoreCase((String)descriptionString[i], (String)searchStr)) {
                id.add(idStrings[i]);
                description.add(descriptionString[i]);
                exchange.add(exchangeString[i]);
            }
            if (id.size() >= numResults) break;
            ++i;
        }
        Metric result = new Metric();
        ArrayCache idCache = new ArrayCache(id.toArray(new String[0]));
        result.setData("id", idCache);
        ArrayCache descriptionCache = new ArrayCache(description.toArray(new String[0]));
        result.setData("description", descriptionCache);
        ArrayCache exchangeCache = new ArrayCache(exchange.toArray(new String[0]));
        result.setData("exchange", exchangeCache);
        return result;
    }

    public void initStreamSingleMetric() {
        this.container.clientConnection.stop();
        ClientConnection tClient = new ClientConnection();
        tClient.setUsername(this.container.clientConnection.getUsername());
        tClient.setPassword(this.container.clientConnection.getPassword());
        tClient.setApiKey(this.container.clientConnection.getApiKey());
        tClient.setHost(this.container.clientConnection.getHost());
        tClient.setPort(this.container.clientConnection.getPort());
        this.container.clientConnection = tClient;
        this.setParam("stream", "on");
    }

    public void initStreamSingleMetric(SimpleMetricUpdateCallback callback) {
        this.initStreamSingleMetric();
        this.setStreamRefreshCallbackPureData(callback);
    }

    public void initStream() {
        this.initStreamSingleMetric();
        this.startBatch();
    }

    public void initStream(MetricUpdateCallback callback) {
        this.initStream();
        this.setStreamRefreshCallback(callback);
    }

    public Metric startStream() {
        return this.finishBatch();
    }

    public void stopStream() {
        this.container.clientConnection.stopStream();
        this.removeParam("stream");
    }

    public void setStreamRefreshCallback(MetricUpdateCallback streamRefreshCallback) {
        this.container.clientConnection.setStreamRefreshCallback(streamRefreshCallback);
    }

    public void setStreamRefreshCallbackPureData(SimpleMetricUpdateCallback streamRefreshCallbackPureData) {
        this.container.clientConnection.setStreamRefreshCallbackPureData(streamRefreshCallbackPureData);
    }

    public long getId() {
        return this.container.portfolioData.getPortfolioId();
    }

    public boolean isNaNFiltered() {
        return this.container.portfolioData.isNaNFiltered();
    }

    public void setNaNFiltered(boolean isNaNFiltered) {
        this.container.portfolioData.setNaNFiltered(isNaNFiltered);
    }

    public boolean isNaN2Zero() {
        return this.container.portfolioData.isNaN2Zero();
    }

    public void setNaN2Zero(boolean isNaN2Zero) {
        this.container.portfolioData.setNaN2Zero(isNaN2Zero);
    }

    public static int parseWindowLength(String s) {
        String[] res = s.split("(?<=\\D)(?=\\d)|(?<=\\d)(?=\\D)");
        boolean error = false;
        if (s.equals("all")) {
            return -1;
        }
        if (s.equals("last")) {
            return 0;
        }
        if (s.equals("none")) {
            return -1;
        }
        int number = 1;
        int scale = 0;
        if (res.length != 2) {
            error = true;
        } else {
            try {
                number = Integer.parseInt(res[0]);
            }
            catch (Exception e) {
                error = true;
            }
            if (res[1].equals("s")) {
                scale = 1;
            }
            if (res[1].equals("m")) {
                scale = 60;
            }
            if (res[1].equals("h")) {
                scale = 3600;
            }
            if (res[1].equals("d")) {
                scale = 23400;
            }
            if (res[1].equals("w")) {
                scale = 117000;
            }
            if (res[1].equals("mo")) {
                scale = 491400;
            }
            if (res[1].equals("y")) {
                scale = 5990400;
            }
            if (scale == 0) {
                error = true;
            }
        }
        if (error) {
            return -1;
        }
        return number * scale;
    }

    public Position[] getPositions() {
        Position[] positions = new Position[this.getSymbolNamesList().size()];
        int i = 0;
        for (String e : this.getSymbolNamesList()) {
            positions[i] = new Position(this, e);
            ++i;
        }
        return positions;
    }
}

