/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.portfolio;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.portfolioeffect.quant.client.ClientConnection;
import com.portfolioeffect.quant.client.model.ConnectFailedException;
import com.portfolioeffect.quant.client.portfolio.ArrayCache;
import com.portfolioeffect.quant.client.portfolio.CacheKey;
import com.portfolioeffect.quant.client.portfolio.PortfolioCache;
import com.portfolioeffect.quant.client.portfolio.PortfolioData;
import com.portfolioeffect.quant.client.result.MethodResult;
import com.portfolioeffect.quant.client.util.Console;
import com.portfolioeffect.quant.client.util.DateTimeUtil;
import com.portfolioeffect.quant.client.util.StreamQuantCallBack;
import com.portfolioeffect.quant.client.util.StreamQuantCallBackPureData;
import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class Portfolio {
    private static final int MAX_PDF_POINTS = 300;
    private static final int NUMBER_OF_TRIES = 20;
    private boolean isDebug = false;
    private PortfolioData portfolioData = new PortfolioData();
    private HashMap<String, ArrayCache> symbolUserDataMap;
    private HashMap<String, ArrayCache> symbolUserDataTimeMap;
    private Set<String> userData;
    private ClientConnection clientConnection;
    private ArrayList<String> batchMetricsPosition;
    private ArrayList<String> batchMetricPortfolioKeys;
    private ArrayList<String> batchMetricPositionKeys;
    private ArrayList<String> batchMetricsPortfolio;
    private String batchMetricKey = null;
    private long[] samplingTimes = null;
    private boolean isBatchStart = false;
    private List<CacheKey> cachedValueList;
    private PortfolioCache portfolioCache;

    public Portfolio(Portfolio portfolio) throws Exception {
        this.portfolioData = new PortfolioData(portfolio.portfolioData);
        this.clientConnection = portfolio.clientConnection;
        this.symbolUserDataMap = new HashMap();
        this.symbolUserDataTimeMap = new HashMap();
        this.cachedValueList = new ArrayList<CacheKey>();
        this.userData = new HashSet<String>();
        this.isDebug = portfolio.isDebug;
        this.portfolioCache = new PortfolioCache();
        for (String symbol : portfolio.userData) {
            this.addUserData(symbol, portfolio.symbolUserDataMap.get(symbol).getDoubleArray(), portfolio.symbolUserDataTimeMap.get(symbol).getLongArray());
        }
        this.batchMetricsPosition = null;
        this.batchMetricsPortfolio = null;
        this.batchMetricPortfolioKeys = null;
        this.batchMetricPositionKeys = null;
    }

    public Portfolio(ClientConnection clientConnection) {
        this.portfolioCache = new PortfolioCache();
        this.clientConnection = clientConnection;
        this.symbolUserDataMap = new HashMap();
        this.symbolUserDataTimeMap = new HashMap();
        this.cachedValueList = new ArrayList<CacheKey>();
        this.userData = new HashSet<String>();
        this.batchMetricsPosition = null;
        this.batchMetricsPortfolio = null;
        this.setDefaultParams();
    }

    private void setDefaultParams() {
        this.portfolioData.setFromTime("#");
        this.portfolioData.setToTime("#");
        this.clearCache();
    }

    private String getMetricTypeList(String metric) throws Exception {
        String result = "";
        try {
            Gson gson = new Gson();
            Type mapTypeMetrics = new TypeToken<HashMap<String, String>>(){}.getType();
            HashMap metricArgs = (HashMap)gson.fromJson(metric, mapTypeMetrics);
            metricArgs.putAll(this.portfolioData.getSettings());
            ArrayList<HashMap> paramsArgs = new ArrayList<HashMap>();
            paramsArgs.add(metricArgs);
            result = gson.toJson(paramsArgs);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage().split(":")[1]);
        }
        return result;
    }

    private String getMetricTypeList(ArrayList<String> metrics) throws Exception {
        String result = "";
        try {
            Gson gson = new Gson();
            ArrayList<HashMap> paramsArgs = new ArrayList<HashMap>();
            for (String e : metrics) {
                Type mapTypeMetrics = new TypeToken<HashMap<String, String>>(){}.getType();
                HashMap metricArgs = (HashMap)gson.fromJson(e, mapTypeMetrics);
                metricArgs.putAll(this.portfolioData.getSettings());
                paramsArgs.add(metricArgs);
            }
            result = gson.toJson(paramsArgs);
        }
        catch (Exception e) {
            throw new Exception(e.getMessage().split(":")[1]);
        }
        return result;
    }

    public void setParam(String key, String value) {
        this.portfolioData.getSettings().put(key, value);
        if (key.equals("samplingInterval")) {
            this.removeUserData("sampligTimes");
        }
        this.clearCache();
    }

    public void removeParam(String key) {
        this.portfolioData.getSettings().remove(key);
    }

    public String getParam(String key) {
        if (this.portfolioData.getSettings().containsKey(key)) {
            return this.portfolioData.getSettings().get(key);
        }
        return "";
    }

    public void setPortfolioSettings(Map<String, String> map) {
        this.portfolioData.setSettings(new HashMap<String, String>(map));
        this.clearCache();
    }

    public void setPortfolioSettings(String settingsJSON) {
        this.portfolioData.setSettingJSON(settingsJSON);
        this.clearCache();
    }

    public HashMap<String, String> getPortfolioSettings() {
        return this.portfolioData.getSettings();
    }

    public String getPortfolioSettingsJSON() {
        return this.portfolioData.getSettingJSON();
    }

    public MethodResult addIndex(String assetName) {
        if (this.portfolioData.getIndexPrice() != null) {
            this.portfolioData.setIndexPrice(null);
            this.portfolioData.setIndexTimeMillisec(null);
        }
        this.portfolioData.getPriceID().put(assetName, this.portfolioData.getNextDataId());
        this.portfolioData.setIndexSymbol(assetName);
        this.clearCache();
        return new MethodResult();
    }

    public MethodResult addIndex(double[] indexPrice, long timeStepMilliSec) {
        long[] timeMilliSec = new long[indexPrice.length];
        for (int i = 0; i < indexPrice.length; ++i) {
            timeMilliSec[i] = (long)i * timeStepMilliSec + 1000L;
        }
        return this.addIndex(indexPrice, timeMilliSec);
    }

    public MethodResult addIndex(double[] price, long[] timeMilliSec) {
        if (this.portfolioData.getIndexPrice() != null) {
            this.portfolioData.setIndexPrice(null);
            this.portfolioData.setIndexTimeMillisec(null);
        }
        if (price.length == 0) {
            return new MethodResult("Wrong length of price vector.");
        }
        if (timeMilliSec.length == 0) {
            return new MethodResult("Wrong length of time vector.");
        }
        if (timeMilliSec.length != price.length) {
            return new MethodResult("Length of price and time vector must be the same.");
        }
        try {
            this.portfolioData.setIndexPrice(new ArrayCache(price));
            this.portfolioData.setIndexTimeMillisec(new ArrayCache(timeMilliSec));
        }
        catch (IOException e) {
            return this.processException(e);
        }
        this.portfolioData.setIndexSymbol("index");
        this.portfolioData.getPriceID().put("index", this.portfolioData.getNextDataId());
        this.clearCache();
        return new MethodResult();
    }

    public MethodResult addIndex(float[] indexPrice, long timeStepMilliSec) {
        long[] timeMilliSec = new long[indexPrice.length];
        for (int i = 0; i < indexPrice.length; ++i) {
            timeMilliSec[i] = (long)i * timeStepMilliSec + 1000L;
        }
        return this.addIndex(indexPrice, timeMilliSec);
    }

    public MethodResult addIndex(float[] price, long[] timeMilliSec) {
        if (this.portfolioData.getIndexPrice() != null) {
            this.portfolioData.setIndexPrice(null);
            this.portfolioData.setIndexTimeMillisec(null);
        }
        if (price.length == 0) {
            return new MethodResult("Wrong length of price vector.");
        }
        if (timeMilliSec.length == 0) {
            return new MethodResult("Wrong length of time vector.");
        }
        if (timeMilliSec.length != price.length) {
            return new MethodResult("Length of price and time vector must be the same.");
        }
        try {
            this.portfolioData.setIndexPrice(new ArrayCache(price));
            this.portfolioData.setIndexTimeMillisec(new ArrayCache(timeMilliSec));
        }
        catch (IOException e) {
            return this.processException(e);
        }
        this.portfolioData.setIndexSymbol("index");
        this.portfolioData.getPriceID().put("index", this.portfolioData.getNextDataId());
        this.clearCache();
        return new MethodResult();
    }

    public ClientConnection getClient() {
        return this.clientConnection;
    }

    public void clearCache() {
        for (CacheKey key : this.cachedValueList) {
            try {
                this.portfolioCache.remove(key);
            }
            catch (IOException e) {
                this.processException(e);
            }
        }
        this.cachedValueList = new ArrayList<CacheKey>();
    }

    public MethodResult addPosition(String[] assetName, int[] quantity) {
        for (int i = 0; i < assetName.length; ++i) {
            MethodResult result = this.addPosition(assetName[i], quantity[i]);
            if (!result.hasError()) continue;
            return result;
        }
        return new MethodResult();
    }

    public MethodResult addPosition(String assetName, int quantity) {
        if (this.portfolioData.getIndexSymbol() == null) {
            return new MethodResult("Add index first");
        }
        int[] quantityArray = new int[]{quantity};
        long[] quantityTime = new long[]{-1L};
        return this.addPosition(assetName, quantityArray, quantityTime);
    }

    public MethodResult addPosition(String assetName, int[] quantity, long[] timeMillSec) {
        this.removePositionQuantity(assetName);
        this.removePositionPrice(assetName);
        this.portfolioData.getPriceID().put(assetName, this.portfolioData.getNextDataId());
        if (this.portfolioData.getIndexSymbol() == null) {
            return new MethodResult("Add index first");
        }
        MethodResult result = this.addQuantity(assetName, quantity, timeMillSec);
        this.portfolioData.getSymbolNamesList().add(assetName);
        this.clearCache();
        return result;
    }

    public MethodResult setStreamQuantity(String assetName, int quantity) {
        return this.setStreamQuantity(assetName, quantity, System.currentTimeMillis() + DateTimeUtil.CLIENT_TIME_DELTA);
    }

    public MethodResult setStreamQuantity(String assetName, int quantity, String time) {
        return this.setStreamQuantity(assetName, quantity, DateTimeUtil.toPOSIXTimeWithDelta(time)[0]);
    }

    public MethodResult setStreamQuantity(String assetName, int quantity, long timeMilles) {
        try {
            this.clientConnection.transmitStreamQuantity(assetName, quantity, timeMilles);
            this.portfolioData.getSymbolQuantityMap().get(assetName).writeAsLong(new int[]{quantity});
            this.portfolioData.getSymbolQuantityTimeMap().get(assetName).write(new long[]{timeMilles});
            Thread.sleep(10L);
        }
        catch (Exception e) {
            return this.processException(e);
        }
        return new MethodResult();
    }

    private MethodResult addQuantity(String assetName, int[] quantity, long[] timeMillSec) {
        this.portfolioData.getQuantityID().put(assetName, this.portfolioData.getNextDataId());
        if (timeMillSec.length != quantity.length) {
            return new MethodResult("Length of qunatity and time vector must be the same.");
        }
        try {
            ArrayCache cashQuantity = new ArrayCache(quantity);
            this.portfolioData.getSymbolQuantityMap().put(assetName, cashQuantity);
            ArrayCache cashQuantityTime = new ArrayCache(timeMillSec);
            this.portfolioData.getSymbolQuantityTimeMap().put(assetName, cashQuantityTime);
        }
        catch (IOException e) {
            return this.processException(e);
        }
        this.clearCache();
        return new MethodResult();
    }

    private MethodResult addQuantity(String assetName, ArrayCache quantity, ArrayCache timeMillSec) {
        this.portfolioData.getQuantityID().put(assetName, this.portfolioData.getNextDataId());
        this.portfolioData.getSymbolQuantityMap().put(assetName, quantity);
        this.portfolioData.getSymbolQuantityTimeMap().put(assetName, timeMillSec);
        this.clearCache();
        return new MethodResult();
    }

    public MethodResult addPosition(String assetName, double[] price, int[] quantity, long[] timeMillSec) {
        return this.addPosition(assetName, price, timeMillSec, quantity, timeMillSec);
    }

    public MethodResult addPosition(String assetName, double[] price, int[] quantity, long timeStepMilliSec) {
        if (price.length != quantity.length) {
            return new MethodResult("Length of qunatity and time vector must be the same.");
        }
        long[] timeMilliSec = new long[price.length];
        for (int i = 0; i < price.length; ++i) {
            timeMilliSec[i] = (long)i * timeStepMilliSec + 1000L;
        }
        return this.addPosition(assetName, price, quantity, timeMilliSec);
    }

    public MethodResult addPosition(String assetName, double[] price, int quantity, long timeStepMilliSec) {
        long[] timeMilliSec = new long[price.length];
        for (int i = 0; i < price.length; ++i) {
            timeMilliSec[i] = (long)i * timeStepMilliSec + 1000L;
        }
        return this.addPosition(assetName, price, quantity, timeMilliSec);
    }

    public MethodResult addPosition(String assetName, double[] price, int quantity, long[] priceTimeMillSec) {
        int[] quantityArray = new int[]{quantity};
        long[] quantityTime = new long[]{-1L};
        return this.addPosition(assetName, price, priceTimeMillSec, quantityArray, quantityTime);
    }

    public MethodResult addPosition(String assetName, float[] price, int quantity, long[] priceTimeMillSec) {
        int[] quantityArray = new int[]{quantity};
        long[] quantityTime = new long[]{-1L};
        return this.addPosition(assetName, price, priceTimeMillSec, quantityArray, quantityTime);
    }

    public MethodResult addPosition(String assetName, double[] price, long[] priceTimeMillSec, int[] quantity, long[] quantityTimeMillSec) {
        this.portfolioData.getPriceID().put(assetName, this.portfolioData.getNextDataId());
        if (price.length == 0) {
            return new MethodResult("Wrong length of price vector.");
        }
        if (priceTimeMillSec.length == 0) {
            return new MethodResult("Wrong length of time vector.");
        }
        if (quantity.length == 0) {
            return new MethodResult("Wrong length of quantity vector.");
        }
        if (quantityTimeMillSec.length == 0) {
            return new MethodResult("Wrong length of quantity time vector.");
        }
        if (this.portfolioData.getIndexSymbol() == null) {
            return new MethodResult("Add index first.");
        }
        if (quantityTimeMillSec.length != quantity.length) {
            return new MethodResult("Length of qunatity and time vector must be the same.");
        }
        if (priceTimeMillSec.length != price.length) {
            return new MethodResult("Length of price and time vector must be the same.");
        }
        this.removePositionQuantity(assetName);
        this.removePositionPrice(assetName);
        MethodResult resultQuantity = this.addQuantity(assetName, quantity, quantityTimeMillSec);
        if (resultQuantity.hasError()) {
            return resultQuantity;
        }
        try {
            ArrayCache cashPrice = new ArrayCache(price);
            this.portfolioData.getSymbolPriceMap().put(assetName, cashPrice);
            ArrayCache cashPriceTime = new ArrayCache(priceTimeMillSec);
            this.portfolioData.getSymbolPriceTimeMap().put(assetName, cashPriceTime);
        }
        catch (IOException e) {
            return this.processException(e);
        }
        this.portfolioData.getSymbolNamesList().add(assetName);
        this.portfolioData.getUserPrice().add(assetName);
        this.clearCache();
        return new MethodResult();
    }

    public MethodResult addPosition(String assetName, float[] price, long[] priceTimeMillSec, int[] quantity, long[] quantityTimeMillSec) {
        this.portfolioData.getPriceID().put(assetName, this.portfolioData.getNextDataId());
        if (price.length == 0) {
            return new MethodResult("Wrong length of price vector.");
        }
        if (priceTimeMillSec.length == 0) {
            return new MethodResult("Wrong length of price time vector length.");
        }
        if (quantity.length == 0) {
            return new MethodResult("Wrong length of quantity vector.");
        }
        if (quantityTimeMillSec.length == 0) {
            return new MethodResult("Wrong length of quantity time vector.");
        }
        if (this.portfolioData.getIndexSymbol() == null) {
            return new MethodResult("Add index first.");
        }
        if (quantityTimeMillSec.length != quantity.length) {
            return new MethodResult("Length of qunatity and time vector must be the same.");
        }
        if (priceTimeMillSec.length != price.length) {
            return new MethodResult("Length of price and time vector must be the same.");
        }
        this.removePositionQuantity(assetName);
        this.removePositionPrice(assetName);
        MethodResult resultQuantity = this.addQuantity(assetName, quantity, quantityTimeMillSec);
        if (resultQuantity.hasError()) {
            return resultQuantity;
        }
        try {
            ArrayCache cashPrice = new ArrayCache(price);
            this.portfolioData.getSymbolPriceMap().put(assetName, cashPrice);
            ArrayCache cashPriceTime = new ArrayCache(priceTimeMillSec);
            this.portfolioData.getSymbolPriceTimeMap().put(assetName, cashPriceTime);
        }
        catch (IOException e) {
            return this.processException(e);
        }
        this.portfolioData.getSymbolNamesList().add(assetName);
        this.portfolioData.getUserPrice().add(assetName);
        this.clearCache();
        return new MethodResult();
    }

    public MethodResult addUserData(String dataName, double[] value, long[] timeMillSec) {
        this.portfolioData.getPriceID().put(dataName, this.portfolioData.getNextDataId());
        if (value.length == 0) {
            return new MethodResult("Wrong length of data vector.");
        }
        if (timeMillSec.length == 0) {
            return new MethodResult("Wrong length of time vector.");
        }
        if (value.length != timeMillSec.length) {
            return new MethodResult("Length of data and time vector must be the same.");
        }
        this.removeUserData(dataName);
        try {
            ArrayCache cashData = new ArrayCache(value);
            this.symbolUserDataMap.put(dataName, cashData);
            ArrayCache cashTime = new ArrayCache(timeMillSec);
            this.symbolUserDataTimeMap.put(dataName, cashTime);
        }
        catch (IOException e) {
            return this.processException(e);
        }
        this.userData.add(dataName);
        this.clearCache();
        return new MethodResult();
    }

    public MethodResult addUserData(String dataName, ArrayCache value, ArrayCache timeMillSec) {
        this.portfolioData.getPriceID().put(dataName, this.portfolioData.getNextDataId());
        if (value.getSize() == 0) {
            return new MethodResult("Wrong length of data vector.");
        }
        if (timeMillSec.getSize() == 0) {
            return new MethodResult("Wrong length of time vector.");
        }
        this.removeUserData(dataName);
        this.symbolUserDataMap.put(dataName, value);
        this.symbolUserDataTimeMap.put(dataName, timeMillSec);
        this.userData.add(dataName);
        this.clearCache();
        return new MethodResult();
    }

    public void removePositionPrice(String symbol) {
        if (this.portfolioData.getSymbolNamesList().contains(symbol)) {
            if (this.portfolioData.getUserPrice().contains(symbol)) {
                this.portfolioData.getUserPrice().remove(symbol);
                this.portfolioData.getSymbolPriceMap().remove(symbol);
                this.portfolioData.getSymbolPriceTimeMap().remove(symbol);
                this.portfolioData.getSymbolNamesList().remove(symbol);
            }
            this.portfolioData.getSymbolNamesList().remove(symbol);
            this.clearCache();
        }
    }

    public void removeUserData(String symbol) {
        if (this.userData.contains(symbol)) {
            this.userData.remove(symbol);
            this.symbolUserDataMap.remove(symbol);
            this.symbolUserDataTimeMap.remove(symbol);
        }
        this.clearCache();
    }

    public void removePositionQuantity(String symbol) {
        if (this.portfolioData.getSymbolNamesList().contains(symbol)) {
            this.portfolioData.getSymbolQuantityMap().remove(symbol);
            this.portfolioData.getSymbolQuantityTimeMap().remove(symbol);
            this.clearCache();
        }
    }

    public MethodResult setPositionQuantity(String name, int quantity) {
        int[] quantityArray = new int[]{quantity};
        long[] quantityTime = new long[]{-1L};
        return this.setPositionQuantity(name, quantityArray, quantityTime);
    }

    public MethodResult setPositionQuantity(String name, int[] quantity, long[] timeMillesc) {
        if (this.portfolioData.getSymbolNamesList().contains(name)) {
            this.removePositionQuantity(name);
            return this.addQuantity(name, quantity, timeMillesc);
        }
        return new MethodResult(String.format("Position for symbol %s not found.", name));
    }

    public MethodResult setPositionQuantity(String name, ArrayCache quantity, ArrayCache timeMillesc) {
        if (this.portfolioData.getSymbolNamesList().contains(name)) {
            this.removePositionQuantity(name);
            return this.addQuantity(name, quantity, timeMillesc);
        }
        return new MethodResult(String.format("Position for symbol %s not found.", name));
    }

    public MethodResult setPositionQuantity(String name, double[] quantityD, long[] timeMillesc) {
        int[] quantity = new int[quantityD.length];
        for (int i = 0; i < quantity.length; ++i) {
            quantity[i] = (int)quantityD[i];
        }
        if (this.portfolioData.getSymbolNamesList().contains(name)) {
            this.removePositionQuantity(name);
            return this.addQuantity(name, quantity, timeMillesc);
        }
        return new MethodResult(String.format("Position for symbol %s not found.", name));
    }

    public MethodResult setPositionQuantity(String name, int[] quantity, String[] timeMillesc) {
        if (this.portfolioData.getUserPrice().contains(name)) {
            long[] time;
            double[] price;
            try {
                price = this.portfolioData.getSymbolPriceMap().get(name).getDoubleArray();
                time = this.portfolioData.getSymbolPriceTimeMap().get(name).getLongArray();
            }
            catch (Exception e) {
                return new MethodResult(e.getMessage());
            }
            return this.addPosition(name, price, time, quantity, DateTimeUtil.toPOSIXTime(timeMillesc));
        }
        return this.addPosition(name, quantity, DateTimeUtil.toPOSIXTime(timeMillesc));
    }

    public PortfolioData getPortfolioData() {
        return this.portfolioData;
    }

    public Portfolio setMetricKey(String key) {
        this.batchMetricKey = key;
        return this;
    }

    public void addMetricToBatch(String metricType) {
        if (this.batchMetricsPortfolio != null || this.batchMetricsPosition != null) {
            if (metricType.contains("PORTFOLIO")) {
                this.batchMetricsPortfolio.add(metricType);
                if (this.batchMetricKey != null) {
                    this.batchMetricPortfolioKeys.add(this.batchMetricKey);
                    this.batchMetricKey = null;
                } else {
                    this.batchMetricPortfolioKeys.add(metricType);
                }
            }
            if (metricType.contains("POSITION") || metricType.contains("INDEX")) {
                this.batchMetricsPosition.add(metricType);
                if (this.batchMetricKey != null) {
                    this.batchMetricPositionKeys.add(this.batchMetricKey);
                    this.batchMetricKey = null;
                } else {
                    this.batchMetricPositionKeys.add(metricType);
                }
            }
        }
    }

    public void addMetricToBatch(Map<String, String> metricType) {
        Gson gson = new Gson();
        this.addMetricToBatch(gson.toJson(metricType));
    }

    public MethodResult runBatch(List<Map<String, String>> metrics) {
        this.startBatch();
        for (Map<String, String> e : metrics) {
            this.addMetricToBatch(e);
        }
        return this.finishBatch();
    }

    public MethodResult runBatch(List<Map<String, String>> metrics, List<String> metricKeys) {
        this.startBatch();
        int i = 0;
        for (Map<String, String> e : metrics) {
            this.setMetricKey(metricKeys.get(i));
            ++i;
            this.addMetricToBatch(e);
        }
        return this.finishBatch();
    }

    public MethodResult runBatchList(List<String> metrics, List<String> metricKeys) {
        this.startBatch();
        int i = 0;
        for (String e : metrics) {
            this.setMetricKey(metricKeys.get(i));
            ++i;
            this.addMetricToBatch(e);
        }
        return this.finishBatch();
    }

    public MethodResult runBatchList(List<String> metrics) {
        this.startBatch();
        for (String e : metrics) {
            this.addMetricToBatch(e);
        }
        return this.finishBatch();
    }

    public MethodResult runBatch(String metricsStr) {
        Gson gson = new Gson();
        Type mapType = new TypeToken<List<Map<String, String>>>(){}.getType();
        List list = (List)gson.fromJson(metricsStr, mapType);
        return this.runBatch(list);
    }

    public MethodResult runBatch(String metricsStr, String metricsKeys) {
        Gson gson = new Gson();
        Type mapType = new TypeToken<List<Map<String, String>>>(){}.getType();
        List list = (List)gson.fromJson(metricsStr, mapType);
        mapType = new TypeToken<List<String>>(){}.getType();
        List keys = (List)gson.fromJson(metricsKeys, mapType);
        return this.runBatch(list, keys);
    }

    public MethodResult getMetric(Map<String, String> metricType) {
        Gson gson = new Gson();
        MethodResult result = this.getMetric(gson.toJson(metricType), "");
        return result;
    }

    public MethodResult getMetric(String metricType) {
        if (this.isBatchStart) {
            this.addMetricToBatch(metricType);
            return new MethodResult();
        }
        MethodResult result = this.getMetric(metricType, "");
        result.setDebug(this.isDebug);
        return result;
    }

    private void processNoCashError(String str) throws Exception {
        if (str.contains("No data in cache")) {
            throw new Exception(str);
        }
    }

    private MethodResult transmitData(ArrayList<String> dataList) throws Exception {
        String[] dataTransmit;
        String windowLength = this.getParam("windowLength");
        String priceSamplingInterval = this.getParam("priceSamplingInterval");
        String momentsModel = this.getParam("riskMethodology");
        MethodResult result = this.clientConnection.transmitDataList(this.portfolioData.getFromTime(), this.portfolioData.getToTime(), dataList, windowLength, priceSamplingInterval, momentsModel);
        if (result.hasError()) {
            this.processNoCashError(result.getErrorMessage());
            return result;
        }
        if (result.getMessage().length() == 0) {
            return new MethodResult();
        }
        Gson gson = new Gson();
        Type mapType = new TypeToken<String[]>(){}.getType();
        for (String e : dataTransmit = (String[])gson.fromJson(result.getMessage(), mapType)) {
            String position;
            String[] ePars = e.split("-");
            if (ePars[0].equals("h") || ePars[0].equals("hI")) {
                result = new MethodResult("Error with historical price.");
                if (!result.hasError()) continue;
                this.processNoCashError(result.getErrorMessage());
                return result;
            }
            if (ePars[0].equals("u")) {
                position = ePars[1].split(":")[1];
                if (position.equals("index")) {
                    result = this.clientConnection.transmitUserPrice(ePars[1], this.portfolioData.getIndexPrice().getDoubleAsFloatArray(), this.portfolioData.getIndexTimeMillisec().getLongArray());
                    if (!result.hasError()) continue;
                    this.processNoCashError(result.getErrorMessage());
                    return result;
                }
                ArrayCache cache = this.portfolioData.getSymbolPriceMap().get(position);
                if (cache == null) {
                    cache = this.symbolUserDataMap.get(position);
                }
                if (cache == null) {
                    throw new Exception(String.format("Price values for symbol %s not found.", position));
                }
                float[] price = cache.getDoubleAsFloatArray();
                cache = this.portfolioData.getSymbolPriceTimeMap().get(position);
                if (cache == null) {
                    cache = this.symbolUserDataTimeMap.get(position);
                }
                if (cache == null) {
                    throw new Exception(String.format("Time values for symbol %s not found.", position));
                }
                long[] time = cache.getLongArray();
                if (price == null || time == null) {
                    throw new Exception(String.format("Price values for symbol %s not found.", position));
                }
                result = this.clientConnection.transmitUserPrice(ePars[1], price, time);
                if (!result.hasError()) continue;
                this.processNoCashError(result.getErrorMessage());
                return result;
            }
            if (ePars[0].equals("q")) {
                position = ePars[1].split(":")[1];
                ArrayCache xq = this.portfolioData.getSymbolQuantityMap().get(position);
                if (xq == null) {
                    throw new Exception(String.format("Quantity values for symbol %s not found.", position));
                }
                int[] quantity = xq.getIntArray();
                ArrayCache xt = this.portfolioData.getSymbolQuantityTimeMap().get(position);
                if (xt == null) {
                    throw new Exception(String.format("Time values for symbol %s not found.", position));
                }
                long[] time = xt.getLongArray();
                result = this.clientConnection.transmitQuantity(ePars[1], quantity, time);
                if (!result.hasError()) continue;
                this.processNoCashError(result.getErrorMessage());
                return result;
            }
            return new MethodResult("Error while transmitting data.");
        }
        return new MethodResult();
    }

    public MethodResult getMetric(String metricType, String params) {
        if (this.portfolioData.getFromTime().length() == 0 || this.portfolioData.getToTime().length() == 0) {
            this.clientConnection.resetProgressBar();
            return new MethodResult("Set time interval  first");
        }
        for (int ii = 0; ii < 20; ++ii) {
            try {
                if (this.portfolioData.getSymbolNamesList().size() == 0) {
                    this.clientConnection.resetProgressBar();
                    return new MethodResult("Empty portfolio.");
                }
                String metricTypeFull = this.getMetricTypeList(metricType);
                String[] positions = null;
                CacheKey key = new CacheKey(metricTypeFull, params);
                if (this.portfolioCache.containsKey(key)) {
                    MethodResult result = new MethodResult();
                    result.setData("value", this.portfolioCache.getMetric(key));
                    result.setData("time", this.portfolioCache.getTime(key));
                    result.setDebug(this.isDebug);
                    result.setNaNFiltered(this.isNaNFiltered());
                    result.setNaN2Zero(this.isNaN2Zero());
                    return result;
                }
                this.clientConnection.printProgressBar(0.0);
                MethodResult result = this.clientConnection.validateStringRequest(metricTypeFull);
                if (result.hasError()) {
                    throw new Exception(result.getErrorMessage());
                }
                positions = result.getStringArray("positions");
                result = null;
                ArrayList<String> positionList = new ArrayList<String>();
                String indexPosition = "";
                if (Arrays.asList(positions).contains("@_ALL_PORTFOLIO_")) {
                    Object firstSplit;
                    String position = "";
                    if (metricTypeFull.contains("position") && ((String[])(firstSplit = metricTypeFull.split(":"))).length == 2) {
                        firstSplit[1] = firstSplit[1].trim();
                        if (((String)firstSplit[1]).length() != 0) {
                            String[] stringArray = ((String)firstSplit[1]).split(",");
                            for (int i = 0; i < stringArray.length; ++i) {
                                String[] thirdSplit = stringArray[i].split("=");
                                if (!thirdSplit[0].trim().equals("position")) continue;
                                position = thirdSplit[1].trim();
                            }
                        }
                    }
                    if (position.length() != 0 && !this.portfolioData.getSymbolNamesList().contains(position)) {
                        this.clientConnection.resetProgressBar();
                        return new MethodResult(String.format("Position for symbol %s not found.", position));
                    }
                    if (position.length() != 0) {
                        positionList.add(position);
                    }
                    for (String string : this.portfolioData.getSymbolNamesList()) {
                        if (string.equals(position)) continue;
                        positionList.add(string);
                    }
                } else {
                    for (int i = 0; i < positions.length; ++i) {
                        if (positions[i].equals("@_INDEX_")) continue;
                        if (!this.portfolioData.getSymbolNamesList().contains(positions[i])) {
                            this.clientConnection.resetProgressBar();
                            return new MethodResult(String.format("Position for symbol %s not found.", positions[i]));
                        }
                        positionList.add(positions[i]);
                    }
                }
                ArrayList<String> dataList = new ArrayList<String>();
                if (this.portfolioData.getIndexPrice() == null) {
                    dataList.add("hI-" + this.portfolioData.getPortfolioId() + ":" + this.portfolioData.getIndexSymbol() + ":" + this.portfolioData.getPriceID().get(this.portfolioData.getIndexSymbol()));
                    indexPosition = this.portfolioData.getIndexSymbol();
                } else {
                    dataList.add("u-" + this.portfolioData.getPortfolioId() + ":" + "index" + ":" + this.portfolioData.getPriceID().get(this.portfolioData.getIndexSymbol()));
                    indexPosition = "index";
                }
                for (String string : this.portfolioData.getSymbolNamesList()) {
                    if (this.portfolioData.getUserPrice().contains(string)) {
                        dataList.add("u-" + this.portfolioData.getPortfolioId() + ":" + string + ":" + this.portfolioData.getPriceID().get(string));
                    } else {
                        dataList.add("h-" + this.portfolioData.getPortfolioId() + ":" + string + ":" + this.portfolioData.getPriceID().get(string));
                    }
                    dataList.add("q-" + this.portfolioData.getPortfolioId() + ":" + string + ":" + this.portfolioData.getQuantityID().get(string));
                }
                ArrayList<String> positionNames = new ArrayList<String>();
                for (String e : positionList) {
                    if (this.portfolioData.getUserPrice().contains(e)) {
                        positionNames.add(this.portfolioData.getPortfolioId() + ":" + e + ":" + this.portfolioData.getPriceID().get(e) + "=" + this.portfolioData.getPortfolioId() + ":" + e + ":" + this.portfolioData.getQuantityID().get(e));
                        continue;
                    }
                    positionNames.add("h-" + this.portfolioData.getPortfolioId() + ":" + e + ":" + this.portfolioData.getPriceID().get(e) + "=" + this.portfolioData.getPortfolioId() + ":" + e + ":" + this.portfolioData.getQuantityID().get(e));
                }
                if (indexPosition.length() != 0) {
                    indexPosition = this.portfolioData.getIndexPrice() != null ? this.portfolioData.getPortfolioId() + ":" + indexPosition + ":" + this.portfolioData.getPriceID().get(indexPosition) + "=" + this.portfolioData.getPortfolioId() + ":" + indexPosition + ":" + this.portfolioData.getQuantityID().get(indexPosition) : "hI-" + this.portfolioData.getPortfolioId() + ":" + indexPosition + ":" + this.portfolioData.getPriceID().get(indexPosition) + "=" + this.portfolioData.getPortfolioId() + ":" + indexPosition + ":" + this.portfolioData.getQuantityID().get(indexPosition);
                }
                for (String e : this.userData) {
                    dataList.add("u-" + this.portfolioData.getPortfolioId() + ":" + e + ":" + this.portfolioData.getPriceID().get(e));
                    positionNames.add(this.portfolioData.getPortfolioId() + ":" + e + ":" + this.portfolioData.getPriceID().get(e));
                }
                MethodResult methodResult = this.transmitData(dataList);
                if (methodResult.hasError()) {
                    throw new Exception(methodResult.getErrorMessage());
                }
                result = this.clientConnection.estimateTransactional(metricTypeFull, indexPosition, positionNames, params);
                if (!result.hasError()) {
                    this.portfolioCache.addMetric(key, result.getDataArrayCacheArray("values")[0]);
                    this.portfolioCache.addTime(key, result.getDataArrayCacheArray("times")[0]);
                    this.cachedValueList.add(key);
                    MethodResult resultT = new MethodResult();
                    resultT.setData("value", result.getDataArrayCacheArray("values")[0]);
                    resultT.setData("time", result.getDataArrayCacheArray("times")[0]);
                    resultT.setInfo(result.getInfoParams());
                    resultT.setDebug(this.isDebug);
                    resultT.setNaNFiltered(this.isNaNFiltered());
                    resultT.setNaN2Zero(this.isNaN2Zero());
                    result = resultT;
                } else {
                    this.clientConnection.createCallGroup(1);
                }
                return result;
            }
            catch (Exception e) {
                MethodResult result = this.processException(e);
                if (result.getErrorMessage().equals("Server too busy, try again later")) continue;
                return result;
            }
        }
        this.clientConnection.resetProgressBar();
        return new MethodResult("Failed to complete estimation procedure - cannot connect to server. Server request failed due to a timeout.");
    }

    public MethodResult getAllSymbolsList() {
        for (int ii = 0; ii < 20; ++ii) {
            CacheKey keyId = new CacheKey("[{name:\"allSymbolsId\"}]", "");
            CacheKey keyDescription = new CacheKey("[{name:\"allSymbolsDescription\"}]", "");
            CacheKey keyExchange = new CacheKey("[{name:\"allSymbolsExchange\"}]", "");
            if (this.portfolioCache.containsKey(keyId)) {
                MethodResult result = new MethodResult();
                result.setData("id", this.portfolioCache.getMetric(keyId));
                result.setData("description", this.portfolioCache.getMetric(keyDescription));
                result.setData("exchange", this.portfolioCache.getMetric(keyExchange));
                return result;
            }
            try {
                MethodResult result = this.clientConnection.getAllSymbolsList();
                this.portfolioCache.addMetric(keyId, result.getDataArrayCache("id"));
                this.portfolioCache.addMetric(keyDescription, result.getDataArrayCache("description"));
                this.portfolioCache.addMetric(keyExchange, result.getDataArrayCache("exchange"));
                return result;
            }
            catch (Exception e) {
                MethodResult result = this.processException(e);
                if (result.getErrorMessage().equals("Server too busy, try again later")) continue;
                return result;
            }
        }
        return new MethodResult("Failed to complete estimation procedure - cannot connect to server. Server request failed due to a timeout.");
    }

    public void clearBatchMetricT() {
        this.batchMetricsPortfolio.clear();
        this.batchMetricsPosition.clear();
        this.batchMetricsPortfolio = null;
        this.batchMetricsPosition = null;
    }

    public MethodResult finishBatch() {
        if (this.clientConnection.isStreamEnabled().get()) {
            return new MethodResult("Stream is already running");
        }
        this.isBatchStart = false;
        if (this.batchMetricsPortfolio == null && this.batchMetricsPosition == null) {
            return new MethodResult();
        }
        String factorModel = this.portfolioData.getParam("factorModel");
        if (factorModel == "sim" || factorModel == null) {
            this.batchMetricsPortfolio.addAll(this.batchMetricsPosition);
            this.batchMetricPortfolioKeys.addAll(this.batchMetricPositionKeys);
            MethodResult result = this.computeBatch(this.batchMetricsPortfolio, this.batchMetricPortfolioKeys);
            this.clearBatchMetricT();
            return result;
        }
        if (this.getParam("stream").equals("on") && factorModel != "sim") {
            return new MethodResult("Streaming mode is supported only with SIM portfolio");
        }
        if (this.batchMetricsPortfolio.size() != 0 && this.batchMetricsPosition.size() != 0) {
            this.clientConnection.createCallGroup(2);
            MethodResult result = this.computeBatch(this.batchMetricsPortfolio);
            if (result.hasError()) {
                this.clearBatchMetricT();
                this.clientConnection.createCallGroup(1);
                return result;
            }
            result = this.computeBatch(this.batchMetricsPosition);
            this.clearBatchMetricT();
            this.clientConnection.createCallGroup(1);
            return result;
        }
        this.batchMetricsPortfolio.addAll(this.batchMetricsPosition);
        MethodResult result = this.computeBatch(this.batchMetricsPortfolio);
        this.clearBatchMetricT();
        return result;
    }

    private MethodResult processException(Exception e) {
        if (this.isDebug && (e.getMessage() == null || !e.getMessage().equals("Cannot connect to server. Server request failed due to a timeout."))) {
            Console.writeStackTrace(e);
        }
        if (e instanceof ConnectFailedException) {
            MethodResult isRestarted = this.clientConnection.restart();
            if (isRestarted.hasError()) {
                this.clientConnection.resetProgressBar();
                return new MethodResult(isRestarted.getErrorMessage());
            }
            return new MethodResult("Server too busy, try again later");
        }
        if (e.getMessage() == null || e.getMessage().contains("No data in cache") || e.getMessage().contains("null")) {
            MethodResult isRestarted = this.clientConnection.restart();
            if (isRestarted.hasError()) {
                this.clientConnection.resetProgressBar();
                return new MethodResult(isRestarted.getErrorMessage());
            }
            return new MethodResult("Server too busy, try again later");
        }
        if (e.getMessage() == null) {
            Console.writeStackTrace(e);
            return new MethodResult("Unknown error.");
        }
        this.clientConnection.resetProgressBar();
        return new MethodResult(e.getMessage());
    }

    private MethodResult computeBatch(ArrayList<String> batchMetrics) {
        return this.computeBatch(batchMetrics, new ArrayList<String>());
    }

    private MethodResult computeBatch(ArrayList<String> batchMetrics, ArrayList<String> batchMetricKeys) {
        ArrayList<String> metricsTypeNewList = new ArrayList<String>();
        for (String e : batchMetrics) {
            CacheKey key;
            try {
                String metricTypeFull = this.getMetricTypeList(e);
                key = new CacheKey(metricTypeFull, "");
            }
            catch (Exception e1) {
                return this.processException(e1);
            }
            if (this.portfolioCache.containsKey(key) && !this.getParam("stream").equals("on")) continue;
            metricsTypeNewList.add(e);
        }
        if (metricsTypeNewList.size() == 0) {
            return new MethodResult();
        }
        batchMetrics.clear();
        this.clientConnection.printProgressBar(0.0);
        if (this.portfolioData.getFromTime().length() == 0 || this.portfolioData.getToTime().length() == 0) {
            this.clientConnection.resetProgressBar();
            return new MethodResult("Set time interval  first");
        }
        for (int ii = 0; ii < 20; ++ii) {
            try {
                String metricsType = this.getMetricTypeList(metricsTypeNewList);
                if (this.portfolioData.getSymbolNamesList().size() == 0) {
                    this.clientConnection.resetProgressBar();
                    return new MethodResult("Empty portfolio.");
                }
                String[] positions = null;
                MethodResult result = this.clientConnection.validateStringRequest(metricsType);
                if (result.hasError()) {
                    throw new Exception(result.getErrorMessage());
                }
                positions = result.getStringArray("positions");
                result = null;
                ArrayList<String> positionList = new ArrayList<String>();
                String indexPosition = "";
                if (Arrays.asList(positions).contains("@_ALL_PORTFOLIO_")) {
                    for (String string : this.portfolioData.getSymbolNamesList()) {
                        positionList.add(string);
                    }
                } else {
                    for (int i = 0; i < positions.length; ++i) {
                        if (positions[i].equals("@_INDEX_")) continue;
                        if (!this.portfolioData.getSymbolNamesList().contains(positions[i])) {
                            this.clientConnection.resetProgressBar();
                            return new MethodResult(String.format("Position for symbol %s not found.", positions[i]));
                        }
                        positionList.add(positions[i]);
                    }
                }
                ArrayList<String> positionNames = new ArrayList<String>();
                for (String string : positionList) {
                    if (this.portfolioData.getUserPrice().contains(string)) {
                        positionNames.add(this.portfolioData.getPortfolioId() + ":" + string + ":" + this.portfolioData.getPriceID().get(string) + "=" + this.portfolioData.getPortfolioId() + ":" + string + ":" + this.portfolioData.getQuantityID().get(string));
                        continue;
                    }
                    positionNames.add("h-" + this.portfolioData.getPortfolioId() + ":" + string + ":" + this.portfolioData.getPriceID().get(string) + "=" + this.portfolioData.getPortfolioId() + ":" + string + ":" + this.portfolioData.getQuantityID().get(string));
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                if (this.portfolioData.getIndexPrice() == null) {
                    arrayList.add("hI-" + this.portfolioData.getPortfolioId() + ":" + this.portfolioData.getIndexSymbol() + ":" + this.portfolioData.getPriceID().get(this.portfolioData.getIndexSymbol()));
                    indexPosition = this.portfolioData.getIndexSymbol();
                } else {
                    arrayList.add("u-" + this.portfolioData.getPortfolioId() + ":" + "index" + ":" + this.portfolioData.getPriceID().get(this.portfolioData.getIndexSymbol()));
                    indexPosition = "index";
                }
                for (String symbol : this.portfolioData.getSymbolNamesList()) {
                    if (this.portfolioData.getUserPrice().contains(symbol)) {
                        arrayList.add("u-" + this.portfolioData.getPortfolioId() + ":" + symbol + ":" + this.portfolioData.getPriceID().get(symbol));
                    } else {
                        arrayList.add("h-" + this.portfolioData.getPortfolioId() + ":" + symbol + ":" + this.portfolioData.getPriceID().get(symbol));
                    }
                    arrayList.add("q-" + this.portfolioData.getPortfolioId() + ":" + symbol + ":" + this.portfolioData.getQuantityID().get(symbol));
                }
                if (indexPosition.length() != 0) {
                    indexPosition = this.portfolioData.getIndexPrice() != null ? this.portfolioData.getPortfolioId() + ":" + indexPosition + ":" + this.portfolioData.getPriceID().get(indexPosition) + "=" + this.portfolioData.getPortfolioId() + ":" + indexPosition + ":" + this.portfolioData.getQuantityID().get(indexPosition) : "hI-" + this.portfolioData.getPortfolioId() + ":" + indexPosition + ":" + this.portfolioData.getPriceID().get(indexPosition) + "=" + this.portfolioData.getPortfolioId() + ":" + indexPosition + ":" + this.portfolioData.getQuantityID().get(indexPosition);
                }
                for (String e : this.userData) {
                    arrayList.add("u-" + this.portfolioData.getPortfolioId() + ":" + e + ":" + this.portfolioData.getPriceID().get(e));
                }
                for (String e : this.userData) {
                    arrayList.add("u-" + this.portfolioData.getPortfolioId() + ":" + e + ":" + this.portfolioData.getPriceID().get(e));
                    positionNames.add(this.portfolioData.getPortfolioId() + ":" + e + ":" + this.portfolioData.getPriceID().get(e));
                }
                MethodResult methodResult = this.transmitData(arrayList);
                if (methodResult.hasError()) {
                    throw new Exception(methodResult.getErrorMessage());
                }
                this.clientConnection.setBatchMetricKeys(batchMetricKeys, this.portfolioData.getPortfolioId());
                result = this.clientConnection.estimateTransactional(metricsType, indexPosition, positionNames, "");
                if (!result.hasError()) {
                    for (int k = 0; k < result.getDataArrayCacheArray("values").length; ++k) {
                        String metricTypeFull = this.getMetricTypeList(metricsTypeNewList.get(k));
                        CacheKey key = new CacheKey(metricTypeFull, "");
                        this.portfolioCache.addMetric(key, result.getDataArrayCacheArray("values")[k]);
                        this.portfolioCache.addTime(key, result.getDataArrayCacheArray("times")[k]);
                        this.cachedValueList.add(key);
                    }
                    metricsTypeNewList.clear();
                } else {
                    this.clientConnection.createCallGroup(1);
                }
                return new MethodResult();
            }
            catch (Exception e) {
                MethodResult result = this.processException(e);
                if (result.getErrorMessage().equals("Server too busy, try again later")) continue;
                return result;
            }
        }
        this.clientConnection.resetProgressBar();
        return new MethodResult("Failed to complete estimation procedure - cannot connect to server. Server request failed due to a timeout.");
    }

    private MethodResult processException(IOException e) {
        if (this.isDebug) {
            Console.writeStackTrace(e);
        }
        if (e.getMessage() != null) {
            return new MethodResult(e.getMessage());
        }
        return new MethodResult("Error while working with the local file system");
    }

    public MethodResult getPDF(double from, double to, int number) throws Exception {
        return this.getPDF(from, to, number, "");
    }

    public MethodResult getPDF(int number) throws Exception {
        return this.getPDF(0.0, 1.0, number, "");
    }

    public MethodResult getPDF(int number, String position) throws Exception {
        return this.getPDF(0.0, 1.0, number, position);
    }

    public MethodResult getPDF(double from, double to, int number, String position) throws Exception {
        int i;
        if (this.getSymbolNamesList().size() == 0) {
            return new MethodResult("Empty portfolio.");
        }
        number = number > 300 ? 300 : number;
        HashMap<String, String> params = new HashMap<String, String>();
        String sampling = this.getSamplingInterval();
        Gson gson = new Gson();
        if (position.length() == 0) {
            params.put("metric", "PORTFOLIO_PDF");
        } else {
            params.put("metric", "POSITION_PDF");
            params.put("position", position);
        }
        params.put("from", "" + from);
        params.put("to", "" + to);
        params.put("number", "" + number);
        MethodResult result = this.getMetric(gson.toJson(params));
        long[] time = null;
        double[][] PDF = null;
        double[][] x = null;
        if (!result.hasError()) {
            time = result.getLongArray("time");
            PDF = new double[time.length][number];
            x = new double[time.length][number];
            ArrayCache qResult = result.getDataArrayCache("value");
            try {
                qResult.lockToRead();
                for (int j = 0; j < time.length; ++j) {
                    for (i = 0; i < number; ++i) {
                        x[j][i] = qResult.getNextDouble();
                        PDF[j][i] = qResult.getNextDouble();
                    }
                }
                qResult.unlockToRead();
            }
            catch (Exception e) {
                if (this.isDebug()) {
                    Console.writeStackTrace(e);
                }
                if (e.getMessage() != null) {
                    return new MethodResult(e.getMessage());
                }
                return new MethodResult("Error while working with the local file system");
            }
        } else {
            return new MethodResult(result.getErrorMessage());
        }
        if (sampling.equals("last")) {
            double[][] newPDF = new double[1][number];
            double[][] newX = new double[1][number];
            for (i = 0; i < number; ++i) {
                newPDF[0][i] = PDF[PDF.length - 1][i];
                newX[0][i] = x[x.length - 1][i];
            }
            PDF = newPDF;
            x = newX;
            long[] newTime = new long[]{time[time.length - 1]};
            time = newTime;
        }
        this.getClient().resetProgressBar();
        MethodResult resultP = new MethodResult();
        resultP.setData("time", new ArrayCache(time));
        resultP.setData("x", new ArrayCache(x));
        resultP.setData("pdf", new ArrayCache(PDF));
        return resultP;
    }

    public MethodResult getPositionQuantity(String symbol) {
        if (this.portfolioData.getSymbolQuantityMap().containsKey(symbol)) {
            try {
                double[] value = this.portfolioData.getSymbolQuantityMap().get(symbol).getIntAsDoubleArray();
                long[] time = this.portfolioData.getSymbolQuantityTimeMap().get(symbol).getLongArray();
                String samplingInterval = this.getParam("samplingInterval");
                if (samplingInterval.equals("last")) {
                    MethodResult result = new MethodResult();
                    result.setData("value", new ArrayCache(new double[]{value[value.length - 1]}));
                    result.setData("time", new ArrayCache(new long[]{time[time.length - 1]}));
                    return result;
                }
                MethodResult result = new MethodResult();
                result.setData("value", new ArrayCache(value));
                result.setData("time", new ArrayCache(time));
                return result;
            }
            catch (Exception e) {
                return this.processException(e);
            }
        }
        return new MethodResult(String.format("Position for symbol %s not found.", symbol));
    }

    public String[] getSymbols() {
        String[] names = new String[this.portfolioData.getSymbolNamesList().size()];
        int i = 0;
        Iterator<String> iterator = this.portfolioData.getSymbolNamesList().iterator();
        while (iterator.hasNext()) {
            String name;
            names[i] = name = iterator.next();
            ++i;
        }
        return names;
    }

    public int[] getQuantities() throws Exception {
        String[] positions = this.getSymbols();
        int[] quantities = new int[positions.length];
        for (int i = 0; i < positions.length; ++i) {
            quantities[i] = this.portfolioData.getSymbolQuantityMap().get(positions[i]).getIntArray()[0];
        }
        return quantities;
    }

    public void createCallGroup(int groupSize) {
        this.clientConnection.createCallGroup(groupSize);
    }

    public List<String> getSymbolNamesList() {
        return this.portfolioData.getSymbolNamesList();
    }

    public Map<String, ArrayCache> getSymbolQuantityMap() {
        return this.portfolioData.getSymbolQuantityMap();
    }

    public boolean isPriceJumpsFilterEnabled() {
        return this.getParam("isPriceJumpsFilterEnabled").equals("true");
    }

    public boolean isHoldingPeriodEnabled() {
        return this.getParam("isHoldingPeriodEnabled").equals("true");
    }

    public void setHoldingPeriodEnabled(boolean isHoldingPeriodEnabled) {
        this.setParam("isHoldingPeriodEnabled", String.valueOf(isHoldingPeriodEnabled));
    }

    public String getFromTime() {
        return this.portfolioData.getFromTime();
    }

    public MethodResult setFromTime(String fromTime) {
        this.updatePriceData();
        this.portfolioData.setFromTime("");
        if (fromTime.contains("t")) {
            if (fromTime.trim().equals("t")) {
                this.portfolioData.setFromTime(fromTime);
                return new MethodResult();
            }
            String[] a = fromTime.trim().split("-");
            try {
                this.portfolioData.setFromTime(fromTime);
                return new MethodResult();
            }
            catch (Exception e) {
                return new MethodResult(String.format("Wrong time format: fromTime= %s", fromTime));
            }
        }
        if (!fromTime.contains(":")) {
            String s = fromTime.trim() + " 09:30:01";
            try {
                Timestamp t = Timestamp.valueOf(s);
                this.portfolioData.setFromTime(fromTime);
                return new MethodResult();
            }
            catch (Exception e) {
                return new MethodResult(String.format("Wrong time format: fromTime= %s", fromTime));
            }
        }
        try {
            Timestamp t = Timestamp.valueOf(fromTime);
        }
        catch (Exception e) {
            return new MethodResult(String.format("Wrong time format: fromTime= %s", fromTime));
        }
        this.portfolioData.setFromTime(fromTime);
        return new MethodResult();
    }

    public String getToTime() {
        return this.portfolioData.getToTime();
    }

    public void updatePriceData() {
        for (String e : this.portfolioData.getPriceID().keySet()) {
            if (this.portfolioData.getUserPrice().contains(e)) continue;
            this.portfolioData.getPriceID().put(e, this.portfolioData.getNextDataId());
        }
        this.clearCache();
    }

    public MethodResult setToTime(String toTime) {
        this.updatePriceData();
        this.portfolioData.setToTime("");
        if (toTime.contains("t")) {
            if (toTime.trim().equals("t")) {
                this.portfolioData.setToTime(toTime);
                return new MethodResult();
            }
            String[] a = toTime.trim().split("-");
            try {
                int daysBack = Integer.parseInt(a[1].split("d")[0]);
                this.portfolioData.setToTime(toTime);
                return new MethodResult();
            }
            catch (Exception e) {
                return new MethodResult(String.format("Wrong time format: toTime= %s", toTime));
            }
        }
        if (!toTime.contains(":")) {
            String s = toTime.trim() + " 09:30:01";
            try {
                Timestamp t = Timestamp.valueOf(s);
                this.portfolioData.setToTime(toTime);
                return new MethodResult();
            }
            catch (Exception e) {
                return new MethodResult(String.format("Wrong time format: toTime= %s", toTime));
            }
        }
        try {
            Timestamp t = Timestamp.valueOf(toTime);
        }
        catch (Exception e) {
            return new MethodResult(String.format("Wrong time format: toTime= %s", toTime));
        }
        this.portfolioData.setToTime(toTime);
        return new MethodResult();
    }

    public String getSamplingInterval() {
        return this.getParam("samplingInterval");
    }

    public void setSamplingInterval(String samplingIntervalServer) {
        this.setParam("samplingInterval", samplingIntervalServer);
        this.removeUserData("sampligTimes");
        this.samplingTimes = null;
        this.clearCache();
    }

    public long[] getSamplingIntervalArray() {
        return this.samplingTimes;
    }

    public void setSamplingInterval(long[] samplingTimes) {
        this.samplingTimes = samplingTimes;
        double[] value = new double[samplingTimes.length + 1];
        long[] time = new long[samplingTimes.length + 1];
        value[0] = 0.0;
        time[0] = samplingTimes[0] - 1000L;
        for (int i = 1; i < value.length; ++i) {
            value[i] = i;
            time[i] = samplingTimes[i - 1];
        }
        this.setParam("samplingInterval", "all");
        this.addUserData("sampligTimes", value, time);
        this.clearCache();
    }

    public void startBatch() {
        if (this.clientConnection.isStreamEnabled().get()) {
            return;
        }
        this.isBatchStart = true;
        this.batchMetricKey = null;
        this.batchMetricsPosition = new ArrayList();
        this.batchMetricsPortfolio = new ArrayList();
        this.batchMetricPortfolioKeys = new ArrayList();
        this.batchMetricPositionKeys = new ArrayList();
    }

    protected void finalize() throws Throwable {
        this.clearCache();
        super.finalize();
    }

    public boolean isNoiseModelEnabled() {
        return this.getParam("isNoiseModelEnabled").equals("true");
    }

    public void setNoiseModelEnabled(boolean isNoiseFilterEnabled) {
        this.setParam("isNoiseModelEnabled", String.valueOf(isNoiseFilterEnabled));
        this.clearCache();
    }

    public boolean isNonGaussianModelEnabled() {
        return this.getParam("isNonGaussianModelEnabled").equals("true");
    }

    public void setNonGaussianModelEnabled(boolean isNonGaussianModelEnabled) {
        this.setParam("isNonGaussianModelEnabled", String.valueOf(isNonGaussianModelEnabled));
        this.clearCache();
    }

    public String getShortSalesMode() {
        return this.getParam("shortSalesMode");
    }

    public void setShortSalesMode(String shortSalesMode) {
        this.setParam("shortSalesMode", shortSalesMode);
        this.clearCache();
    }

    public String getPriceSamplingInterval() {
        return this.getParam("priceSamplingInterval");
    }

    public void setPriceSamplingInterval(String priceSamplingInterval) {
        this.setParam("priceSamplingInterval", priceSamplingInterval);
        this.clearCache();
    }

    public String getIndexSymbol() {
        return this.portfolioData.getIndexSymbol();
    }

    public void setFactorModel(String factorModel) {
        this.setParam("factorModel", factorModel);
        this.clearCache();
    }

    public String getFactorModel() {
        return this.getParam("factorModel");
    }

    public boolean isJumpsModelEnabled() {
        return this.getParam("isJumpsModelEnabled").equals("true");
    }

    public void setJumpsModel(String jumpsModel) {
        this.setParam("jumpsModel", jumpsModel);
        this.clearCache();
    }

    public String getJumpsModel() {
        return this.getParam("jumpsModel");
    }

    public void setWindowLength(String windowLengthString) {
        this.setParam("windowLength", windowLengthString);
        this.clearCache();
    }

    public String getWindowLength() {
        return this.getParam("windowLength");
    }

    public void setTimeScale(String timeScaleSecString) {
        this.setParam("timeScale", timeScaleSecString);
        this.clearCache();
    }

    public String getTimeScale() {
        return this.getParam("timeScale");
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void setDebug(boolean isDebug) {
        this.isDebug = isDebug;
        this.clientConnection.setDebugModeEnabled(isDebug);
    }

    public long getNewDataId() {
        return this.portfolioData.getNextDataId();
    }

    public ClientConnection getClientConnection() {
        return this.clientConnection;
    }

    public void setClientConnection(ClientConnection clientConnection) {
        this.clientConnection = clientConnection;
    }

    public void setTxnCostPerShare(double value) {
        this.setParam("txnCostPerShare", String.valueOf(value));
    }

    public double getTxnCostPerShare() {
        return Double.valueOf(this.getParam("txnCostPerShare"));
    }

    public void setTxnCostFixed(double value) {
        this.setParam("txnCostFixed", String.valueOf(value));
    }

    public double getTxnCostFixed() {
        return Double.valueOf(this.getParam("txnCostFixed"));
    }

    public boolean isDriftEnabled() {
        return Boolean.valueOf(this.getParam("isDriftEnabled"));
    }

    public void setDriftEnabled(boolean isDriftEnabled) {
        this.setParam("isDriftEnabled", String.valueOf(isDriftEnabled));
    }

    public void setRiskMethodology(String model) {
        this.setParam("riskMethodology", model);
        if (this.getParam("priceSamplingInterval").equals("") && model.equals("RiskMetrics")) {
            this.setParam("priceSamplingInterval", "1d");
        }
    }

    public String getRiskMethodology() {
        return this.getParam("riskMethodology");
    }

    public void setLambdaRiskMetrics(double lambda) {
        this.setParam("lambdaRiskMetrics", String.valueOf(lambda));
    }

    public double getLambdaRiskMetrics() {
        return Double.valueOf(this.getParam("lambdaRiskMetrics"));
    }

    public void setDensityApproxModel(String densityApproxModel) {
        this.setParam("densityApproxModel", densityApproxModel);
    }

    public String getDensityApproxModelString() {
        return this.getParam("densityApproxModel");
    }

    public void setPortfolioMetricsMode(String mode) {
        this.setParam("portfolioMetricsMode", mode);
    }

    public String getPortfolioMetricsMode() {
        return this.getParam("portfolioMetricsMode");
    }

    public void setStartWhenBurn(boolean mode) {
        this.setParam("isStartWhenBurn", "" + mode);
    }

    public boolean isStartWhenBurn() {
        return Boolean.valueOf(this.getParam("isStartWhenBurn"));
    }

    public void setFractalPriceModelEnabled(boolean flag) {
        this.setParam("isFractalPriceModelEnabled", "" + flag);
    }

    public boolean isFractalPriceModelEnabled() {
        return Boolean.valueOf(this.getParam("isFractalPriceModelEnabled"));
    }

    public MethodResult findSymbols(String searchStr, int numResults) throws IOException {
        ArrayList<String> id = new ArrayList<String>();
        ArrayList<String> description = new ArrayList<String>();
        ArrayList<String> exchange = new ArrayList<String>();
        MethodResult allSymbols = this.getAllSymbolsList();
        String[] idStrings = allSymbols.getStringArray("id");
        String[] descriptionString = allSymbols.getStringArray("description");
        String[] exchangeString = allSymbols.getStringArray("exchange");
        for (int i = 0; i < idStrings.length; ++i) {
            if (StringUtils.containsIgnoreCase((String)idStrings[i], (String)searchStr) || StringUtils.containsIgnoreCase((String)descriptionString[i], (String)searchStr)) {
                id.add(idStrings[i]);
                description.add(descriptionString[i]);
                exchange.add(exchangeString[i]);
            }
            if (id.size() >= numResults) break;
        }
        MethodResult result = new MethodResult();
        ArrayCache idCache = new ArrayCache(id.toArray(new String[0]));
        result.setData("id", idCache);
        ArrayCache descriptionCache = new ArrayCache(description.toArray(new String[0]));
        result.setData("description", descriptionCache);
        ArrayCache exchangeCache = new ArrayCache(exchange.toArray(new String[0]));
        result.setData("exchange", exchangeCache);
        return result;
    }

    public void initStreamSingleMetric() {
        this.clientConnection.stop();
        ClientConnection tClient = new ClientConnection();
        tClient.setUsername(this.clientConnection.getUsername());
        tClient.setPassword(this.clientConnection.getPassword());
        tClient.setApiKey(this.clientConnection.getApiKey());
        tClient.setHost(this.clientConnection.getHost());
        tClient.setPort(this.clientConnection.getPort());
        this.clientConnection = tClient;
        this.setParam("stream", "on");
    }

    public void initStreamSingleMetric(StreamQuantCallBackPureData callback) {
        this.initStreamSingleMetric();
        this.setStreamRefreshCallbackPureData(callback);
    }

    public void initStream() {
        this.initStreamSingleMetric();
        this.startBatch();
    }

    public void initStream(StreamQuantCallBack callback) {
        this.initStream();
        this.setStreamRefreshCallback(callback);
    }

    public MethodResult startStream() {
        return this.finishBatch();
    }

    public void stopStream() {
        this.clientConnection.stopStream();
        this.removeParam("stream");
    }

    public void setStreamRefreshCallback(StreamQuantCallBack streamRefreshCallback) {
        this.clientConnection.setStreamRefreshCallback(streamRefreshCallback);
    }

    public void setStreamRefreshCallbackPureData(StreamQuantCallBackPureData streamRefreshCallbackPureData) {
        this.clientConnection.setStreamRefreshCallbackPureData(streamRefreshCallbackPureData);
    }

    public long getId() {
        return this.portfolioData.getPortfolioId();
    }

    public boolean isNaNFiltered() {
        return this.portfolioData.isNaNFiltered();
    }

    public void setNaNFiltered(boolean isNaNFiltered) {
        this.portfolioData.setNaNFiltered(isNaNFiltered);
    }

    public boolean isNaN2Zero() {
        return this.portfolioData.isNaN2Zero();
    }

    public void setNaN2Zero(boolean isNaN2Zero) {
        this.portfolioData.setNaN2Zero(isNaN2Zero);
    }
}

