/*
 * Decompiled with CFR 0.152.
 */
package org.openfast;

import java.io.ByteArrayOutputStream;
import org.openfast.QName;
import org.openfast.error.ErrorCode;
import org.openfast.error.ErrorHandler;

public final class Global {
    private static ErrorHandler errorHandler = ErrorHandler.DEFAULT;
    private static int currentImplicitId = (int)(System.currentTimeMillis() % 10000L);
    private static final ThreadLocal<ByteArrayOutputStream> buffers = new ThreadLocal();

    public static void setErrorHandler(ErrorHandler handler) {
        if (handler == null) {
            throw new NullPointerException();
        }
        errorHandler = handler;
    }

    public static void handleError(ErrorCode error, String message) {
        errorHandler.error(error, message);
    }

    public static void handleError(ErrorCode error, String message, Throwable source) {
        errorHandler.error(error, message, source);
    }

    public static QName createImplicitName(QName name) {
        return new QName(name + "@" + currentImplicitId++, name.getNamespace());
    }

    private Global() {
    }

    public static ByteArrayOutputStream getBuffer() {
        ByteArrayOutputStream buffer = buffers.get();
        if (buffer == null) {
            buffer = new ByteArrayOutputStream();
            buffers.set(buffer);
            return buffer;
        }
        buffer.reset();
        return buffer;
    }
}

