/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.examples.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.openfast.examples.xml.XmlToFastConverter;

public class XmlToFastMain {
    public static void main(String[] args) {
        InputStream in = System.in;
        OutputStream out = System.out;
        File xmlFile = null;
        File fastFile = null;
        if (args.length >= 1) {
            xmlFile = new File(args[0]);
            XmlToFastMain.assertTrue(xmlFile.exists(), "The file \"" + xmlFile.getAbsolutePath() + "\" does not exist.");
            XmlToFastMain.assertTrue(!xmlFile.isDirectory(), "The file \"" + xmlFile.getAbsolutePath() + "\" is a directory.");
            XmlToFastMain.assertTrue(xmlFile.canRead(), "The file \"" + xmlFile.getAbsolutePath() + "\" cannot be read.");
            try {
                in = new FileInputStream(xmlFile);
            }
            catch (FileNotFoundException e) {
                System.out.println(e.getMessage());
                System.exit(1);
            }
        }
        if (args.length >= 2) {
            fastFile = new File(args[1]);
            XmlToFastMain.assertTrue(!fastFile.isDirectory(), "The file \"" + fastFile.getAbsolutePath() + "\" is a directory.");
            if (!fastFile.exists()) {
                try {
                    XmlToFastMain.assertTrue(fastFile.createNewFile(), "The file \"" + fastFile.getAbsolutePath() + "\" could not be created.");
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                    System.exit(1);
                }
            }
            XmlToFastMain.assertTrue(fastFile.canWrite(), "The file \"" + fastFile.getAbsolutePath() + "\" cannot be written to.");
            try {
                out = new FileOutputStream(fastFile);
            }
            catch (FileNotFoundException e) {
                System.out.println(e.getMessage());
                System.exit(1);
            }
        }
        XmlToFastConverter converter = new XmlToFastConverter();
        converter.convert(in, out);
        if (xmlFile != null && fastFile != null) {
            System.out.println("Original XML size: " + xmlFile.length() + " bytes");
            System.out.println("Compressed FAST size: " + fastFile.length() + " bytes");
            double compressionRate = (double)fastFile.length() / (double)xmlFile.length();
            System.out.println(String.valueOf(XmlToFastMain.round(compressionRate * 100.0)) + "% compression rate");
        }
    }

    private static double round(double d) {
        return (double)((int)(d * 100.0)) / 100.0;
    }

    private static void assertTrue(boolean condition, String error) {
        if (!condition) {
            System.out.println(error);
            System.exit(1);
        }
    }
}

