/*
 * Decompiled with CFR 0.152.
 */
package com.portfolioeffect.quant.client.portfolio;

import com.portfolioeffect.quant.client.portfolio.ArrayCacheType;
import com.portfolioeffect.quant.client.util.Console;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Scanner;

public class ArrayCache {
    private File file;
    private int size;
    private ObjectInputStream inStream = null;
    private ObjectOutputStream outStream = null;
    private int[] dimensions = new int[]{1};
    private boolean isAllZero = true;
    private ArrayCacheType type;
    private int nanNumber = 0;
    private boolean isNaNFiltered = true;
    private boolean isNaN2Zero = false;
    private boolean inUse = false;

    public ArrayCache(ArrayCacheType type) throws IOException {
        this.type = type;
        this.size = 0;
        this.file = File.createTempFile("quant", "tmp");
        this.file.deleteOnExit();
        FileOutputStream out = new FileOutputStream(this.file);
        this.outStream = new ObjectOutputStream(new BufferedOutputStream(out));
    }

    public ArrayCache(double[] value) throws IOException {
        this(ArrayCacheType.DOUBLE_VECTOR);
        this.write(value);
        this.closeOut();
    }

    public ArrayCache(String[] value) throws IOException {
        this(ArrayCacheType.STRING_VECTOR);
        this.write(value);
        this.closeOut();
    }

    private void nanFilter(double value) {
        if (Double.isNaN(value)) {
            ++this.nanNumber;
        }
    }

    public ArrayCache(double[][] value) throws IOException {
        this(ArrayCacheType.DOUBLE_MATRIX);
        this.dimensions = new int[]{value[0].length};
        for (int i = 0; i < value.length; ++i) {
            this.write(value[i]);
        }
        this.closeOut();
    }

    public ArrayCache(float[] value) throws IOException {
        this(ArrayCacheType.DOUBLE_VECTOR);
        this.writeAsDouble(value);
        this.closeOut();
    }

    public ArrayCache(long[] value) throws IOException {
        this(ArrayCacheType.LONG_VECTOR);
        this.write(value);
        this.closeOut();
    }

    public ArrayCache(int[] value) throws IOException {
        this(ArrayCacheType.INT_VECTOR);
        this.write(value);
        this.closeOut();
    }

    public int getSize() {
        return this.size;
    }

    public void closeOut() throws IOException {
        if (this.outStream != null) {
            this.outStream.flush();
            this.outStream.close();
            this.outStream = null;
        }
    }

    public void openInput() throws IOException {
        if (this.outStream != null) {
            this.closeOut();
        }
        if (this.inUse) {
            this.closeInput();
            this.openInput();
            return;
        }
        this.inUse = true;
        try {
            FileInputStream in = new FileInputStream(this.file);
            this.inStream = new ObjectInputStream(new BufferedInputStream(in));
        }
        catch (Exception e) {
            Console.writeStackTrace(e);
        }
    }

    public double getNextDouble() throws IOException {
        if (this.type != ArrayCacheType.DOUBLE_VECTOR && this.type != ArrayCacheType.DOUBLE_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        return this.inStream.readDouble();
    }

    public void closeInput() throws IOException {
        if (this.inUse) {
            if (this.inStream != null) {
                this.inStream.close();
            }
            this.inStream = null;
        }
        this.inUse = false;
    }

    public void write(double[] value) throws IOException {
        if (this.type != ArrayCacheType.DOUBLE_VECTOR && this.type != ArrayCacheType.DOUBLE_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.size += value.length;
        for (double e : value) {
            this.nanFilter(e);
            this.isAllZero = this.isAllZero && e == 0.0;
            this.outStream.writeDouble(e);
        }
    }

    public void write(String[] value) throws IOException {
        if (this.type != ArrayCacheType.STRING_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.size += value.length;
        byte[] splitSymbol = new String("#-#").getBytes();
        for (String e : value) {
            this.outStream.write(e.getBytes());
            this.outStream.write(splitSymbol);
        }
    }

    public void write(float[] value) throws IOException {
        if (this.type != ArrayCacheType.FLOAT_VECTOR && this.type != ArrayCacheType.FLOAT_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.size += value.length;
        for (float e : value) {
            this.nanFilter(e);
            this.isAllZero = this.isAllZero && (double)e == 0.0;
            this.outStream.writeFloat(e);
        }
    }

    public void writeAsDouble(float[] value) throws IOException {
        if (this.type != ArrayCacheType.DOUBLE_VECTOR && this.type != ArrayCacheType.DOUBLE_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.size += value.length;
        for (int i = 0; i < value.length; ++i) {
            double x = value[i];
            this.nanFilter(x);
            this.isAllZero = this.isAllZero && x == 0.0;
            this.outStream.writeDouble(x);
        }
    }

    public void writeAsFloat(double[] value) throws IOException {
        if (this.type != ArrayCacheType.FLOAT_VECTOR && this.type != ArrayCacheType.FLOAT_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.size += value.length;
        for (double e : value) {
            this.nanFilter(e);
            this.isAllZero = this.isAllZero && e == 0.0;
            this.outStream.writeFloat((float)e);
        }
    }

    public void write(int[] value) throws IOException {
        if (this.type != ArrayCacheType.INT_VECTOR && this.type != ArrayCacheType.INT_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.size += value.length;
        for (int e : value) {
            this.isAllZero = this.isAllZero && e == 0;
            this.outStream.writeInt(e);
        }
    }

    public void writeAsLong(int[] value) throws IOException {
        if (this.type != ArrayCacheType.LONG_VECTOR && this.type != ArrayCacheType.LONG_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.size += value.length;
        for (int e : value) {
            this.isAllZero = this.isAllZero && e == 0;
            this.outStream.writeLong(e);
        }
    }

    public void write(long[] value) throws IOException {
        if (this.type != ArrayCacheType.LONG_VECTOR && this.type != ArrayCacheType.LONG_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.size += value.length;
        for (long e : value) {
            this.isAllZero = this.isAllZero && e == 0L;
            this.outStream.writeLong(e);
        }
    }

    public double[] getDoubleArray() throws IOException {
        this.closeOut();
        this.openInput();
        if (this.type != ArrayCacheType.DOUBLE_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        double[] value = this.isNaNFiltered ? new double[this.size - this.nanNumber] : new double[this.size];
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            double x = this.inStream.readDouble();
            if (this.isNaNFiltered && Double.isNaN(x)) continue;
            if (this.isNaN2Zero && Double.isNaN(x)) {
                x = 0.0;
            }
            value[j++] = x;
        }
        this.closeInput();
        return value;
    }

    public double[] getFloatArrayAsDouble() throws IOException {
        if (this.type != ArrayCacheType.FLOAT_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.closeOut();
        this.openInput();
        double[] value = this.isNaNFiltered ? new double[this.size - this.nanNumber] : new double[this.size];
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            float x = this.inStream.readFloat();
            if (this.isNaNFiltered && Double.isNaN(x)) continue;
            if (this.isNaN2Zero && Double.isNaN(x)) {
                x = 0.0f;
            }
            value[j++] = x;
        }
        this.closeInput();
        return value;
    }

    public float[] getDoubleAsFloatArray() throws IOException {
        if (this.type != ArrayCacheType.DOUBLE_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.closeOut();
        this.openInput();
        float[] value = this.isNaNFiltered ? new float[this.size - this.nanNumber] : new float[this.size];
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            float x = (float)this.inStream.readDouble();
            if (this.isNaNFiltered && Double.isNaN(x)) continue;
            if (this.isNaN2Zero && Double.isNaN(x)) {
                x = 0.0f;
            }
            value[j++] = x;
        }
        this.closeInput();
        return value;
    }

    public String[] getStringArray() throws IOException {
        this.closeOut();
        this.openInput();
        if (this.type != ArrayCacheType.STRING_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        String[] value = new String[this.size];
        Scanner scanner = new Scanner(this.inStream).useDelimiter("#-#");
        for (int i = 0; i < this.size; ++i) {
            value[i] = scanner.next();
        }
        this.closeInput();
        return value;
    }

    public double[][] getDoubleMatrix() throws IOException {
        this.closeOut();
        this.openInput();
        if (this.type != ArrayCacheType.DOUBLE_MATRIX) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        if (this.dimensions.length != 1) {
            throw new RuntimeException("Wrong format of result data.");
        }
        double[][] value = new double[this.size / this.dimensions[0]][this.dimensions[0]];
        for (int i = 0; i < value.length; ++i) {
            for (int j = 0; j < value[0].length; ++j) {
                value[i][j] = this.inStream.readDouble();
            }
        }
        this.closeInput();
        return value;
    }

    public int[] getIntArray() throws IOException {
        if (this.type != ArrayCacheType.INT_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.closeOut();
        this.openInput();
        int[] value = new int[this.size];
        for (int i = 0; i < this.size; ++i) {
            value[i] = this.inStream.readInt();
        }
        this.closeInput();
        return value;
    }

    public double[] getIntAsDoubleArray() throws IOException {
        if (this.type != ArrayCacheType.INT_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.closeOut();
        this.openInput();
        double[] value = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            value[i] = this.inStream.readInt();
        }
        this.closeInput();
        return value;
    }

    public long[] getLongArray(ArrayCache valuesCache) throws IOException {
        if (this.type != ArrayCacheType.LONG_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        if (valuesCache.type != ArrayCacheType.DOUBLE_VECTOR && valuesCache.type != ArrayCacheType.FLOAT_VECTOR) {
            this.closeOut();
            this.openInput();
            long[] value = new long[this.size];
            for (int i = 0; i < this.size; ++i) {
                value[i] = this.inStream.readLong();
            }
            this.closeInput();
            return value;
        }
        this.closeOut();
        this.openInput();
        valuesCache.openInput();
        long[] value = valuesCache.isNaNFiltered ? new long[this.size - valuesCache.nanNumber] : new long[this.size];
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            long t = this.inStream.readLong();
            double x = valuesCache.inStream.readDouble();
            if (valuesCache.isNaNFiltered && Double.isNaN(x)) continue;
            value[j++] = t;
        }
        this.closeInput();
        valuesCache.closeInput();
        return value;
    }

    public long[] getLongArray() throws IOException {
        if (this.type != ArrayCacheType.LONG_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.closeOut();
        this.openInput();
        long[] value = new long[this.size];
        for (int i = 0; i < this.size; ++i) {
            value[i] = this.inStream.readLong();
        }
        this.closeInput();
        return value;
    }

    public float[] getFloatArray() throws IOException {
        if (this.type == ArrayCacheType.DOUBLE_VECTOR) {
            return this.getDoubleAsFloatArray();
        }
        if (this.type != ArrayCacheType.FLOAT_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{this.type}));
        }
        this.closeOut();
        this.openInput();
        float[] value = this.isNaNFiltered ? new float[this.size - this.nanNumber] : new float[this.size];
        int j = 0;
        for (int i = 0; i < this.size; ++i) {
            float x = this.inStream.readFloat();
            if (this.isNaNFiltered && Double.isNaN(x)) continue;
            if (this.isNaN2Zero) {
                x = 0.0f;
            }
            value[j++] = x;
        }
        this.closeInput();
        return value;
    }

    public static ArrayCache[] splitBatchDouble(ArrayCache value, int batchSize) throws IOException {
        int k;
        if (value.type != ArrayCacheType.DOUBLE_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{value.type}));
        }
        ArrayCache[] batchValue = new ArrayCache[batchSize];
        for (int i = 0; i < batchSize; ++i) {
            batchValue[i] = new ArrayCache(ArrayCacheType.DOUBLE_VECTOR);
        }
        int len = 0;
        value.openInput();
        while (len < value.size) {
            for (k = 0; k < batchSize; ++k) {
                double x = value.inStream.readDouble();
                if (Double.isNaN(x)) {
                    ++batchValue[k].nanNumber;
                }
                batchValue[k].isAllZero = batchValue[k].isAllZero && x == 0.0;
                batchValue[k].outStream.writeDouble(x);
                ++batchValue[k].size;
                ++len;
            }
        }
        for (k = 0; k < batchSize; ++k) {
            batchValue[k].closeOut();
        }
        value.closeInput();
        return batchValue;
    }

    public static ArrayCache[] splitBatchDouble(ArrayCache value) throws IOException {
        int k;
        if (value.type != ArrayCacheType.DOUBLE_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{value.type}));
        }
        ArrayCache[] batchValue = new ArrayCache[value.dimensions.length];
        for (int i = 0; i < value.dimensions.length; ++i) {
            batchValue[i] = value.dimensions[i] == 1 ? new ArrayCache(ArrayCacheType.DOUBLE_VECTOR) : new ArrayCache(ArrayCacheType.DOUBLE_MATRIX);
            batchValue[i].setDimensions(new int[]{value.dimensions[i]});
        }
        int len = 0;
        value.openInput();
        while (len < value.size) {
            for (k = 0; k < value.dimensions.length; ++k) {
                for (int m = 0; m < value.dimensions[k]; ++m) {
                    double x = value.inStream.readDouble();
                    boolean bl = batchValue[k].isAllZero = batchValue[k].isAllZero && x == 0.0;
                    if (Double.isNaN(x)) {
                        ++batchValue[k].nanNumber;
                    }
                    batchValue[k].outStream.writeDouble(x);
                    ++batchValue[k].size;
                    ++len;
                }
            }
        }
        for (k = 0; k < value.dimensions.length; ++k) {
            batchValue[k].closeOut();
        }
        value.closeInput();
        return batchValue;
    }

    public static ArrayCache[] splitBatchDoubleToInt(ArrayCache value, int batchSize) throws IOException {
        int k;
        if (value.type != ArrayCacheType.DOUBLE_VECTOR) {
            throw new RuntimeException(String.format("Wrong type of data: %s", new Object[]{value.type}));
        }
        ArrayCache[] batchValue = new ArrayCache[batchSize];
        for (int i = 0; i < batchSize; ++i) {
            batchValue[i] = new ArrayCache(ArrayCacheType.INT_VECTOR);
        }
        int len = 0;
        value.openInput();
        while (len < value.size) {
            for (k = 0; k < batchSize; ++k) {
                int x = (int)value.inStream.readDouble();
                batchValue[k].isAllZero = batchValue[k].isAllZero && (double)x == 0.0;
                batchValue[k].outStream.writeInt(x);
                ++batchValue[k].size;
                ++len;
            }
        }
        for (k = 0; k < batchSize; ++k) {
            batchValue[k].closeOut();
        }
        value.closeInput();
        return batchValue;
    }

    public static ArrayCache copyArrayCacheLong(ArrayCache value) throws IOException {
        ArrayCache batchValue = new ArrayCache(value.type);
        value.openInput();
        for (int k = 0; k < value.size; ++k) {
            long x = value.inStream.readLong();
            batchValue.isAllZero = batchValue.isAllZero && (double)x == 0.0;
            batchValue.outStream.writeLong(x);
            ++batchValue.size;
        }
        batchValue.closeOut();
        value.closeInput();
        return batchValue;
    }

    protected void finalize() throws Throwable {
        if (this.outStream != null) {
            this.outStream.close();
        }
        if (this.inStream != null) {
            this.inStream.close();
        }
        this.outStream = null;
        this.inStream = null;
        this.file.delete();
        this.file = null;
        super.finalize();
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(int[] dimensions) {
        if (dimensions != null) {
            this.dimensions = dimensions;
        }
        if (dimensions.length == 1 && dimensions[0] > 1) {
            this.type = ArrayCacheType.DOUBLE_MATRIX;
        }
    }

    public boolean isAllZero() {
        return this.isAllZero;
    }

    public boolean isNaNFiltered() {
        return this.isNaNFiltered;
    }

    public void setNaNFiltered(boolean isNaNFiltered) {
        this.isNaNFiltered = isNaNFiltered;
    }

    public boolean isNaN2Zero() {
        return this.isNaN2Zero;
    }

    public void setNaN2Zero(boolean isNaN2Zero) {
        this.isNaN2Zero = isNaN2Zero;
    }

    public ArrayCacheType getType() {
        return this.type;
    }

    public int getNanNumber() {
        return this.nanNumber;
    }
}

