/*
 * Decompiled with CFR 0.152.
 */
package org.openfast.codec;

import java.io.IOException;
import java.io.InputStream;
import org.openfast.BitVector;
import org.openfast.BitVectorReader;
import org.openfast.BitVectorValue;
import org.openfast.Context;
import org.openfast.Message;
import org.openfast.codec.Coder;
import org.openfast.error.FastException;
import org.openfast.template.MessageTemplate;
import org.openfast.template.type.codec.TypeCodec;

public class FastDecoder
implements Coder {
    private final InputStream in;
    private final Context context;

    public FastDecoder(Context context, InputStream in) {
        this.in = in;
        this.context = context;
    }

    public Message readMessage() throws FastException {
        BitVectorValue bitVectorValue = (BitVectorValue)TypeCodec.BIT_VECTOR.decode(this.in);
        if (bitVectorValue == null) {
            return null;
        }
        BitVector pmap = bitVectorValue.value;
        BitVectorReader presenceMapReader = new BitVectorReader(pmap);
        int templateId = presenceMapReader.read() ? TypeCodec.UINT.decode(this.in).toInt() : this.context.getLastTemplateId();
        MessageTemplate template = this.context.getTemplate(templateId);
        if (template == null) {
            return null;
        }
        this.context.newMessage(template);
        this.context.setLastTemplateId(templateId);
        return template.decode(this.in, templateId, presenceMapReader, this.context);
    }

    public Message readMessage(int offset) {
        if (offset > 0) {
            try {
                this.in.skip(offset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.readMessage();
    }

    public void reset() {
        this.context.reset();
    }
}

