% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize.portfolio.R
\name{optimize.portfolio.parallel}
\alias{optimize.portfolio.parallel}
\title{Execute multiple optimize.portfolio calls, presumably in parallel}
\usage{
optimize.portfolio.parallel(
  R,
  portfolio,
  optimize_method = c("DEoptim", "random", "ROI", "pso", "GenSA", "CVXR"),
  search_size = 20000,
  trace = FALSE,
  ...,
  rp = NULL,
  momentFUN = "set.portfolio.moments",
  message = FALSE,
  nodes = 4
)
}
\arguments{
\item{R}{an xts, vector, matrix, data frame, timeSeries or zoo object of asset returns}

\item{portfolio}{an object of type "portfolio" specifying the constraints and objectives for the optimization}

\item{optimize_method}{one of "DEoptim", "random", "pso", "GenSA".}

\item{search_size}{integer, how many portfolios to test, default 20,000}

\item{trace}{TRUE/FALSE if TRUE will attempt to return additional information on the path or portfolios searched}

\item{\dots}{any other passthru parameters}

\item{rp}{matrix of random portfolio weights, default NULL, mostly for automated use by rebalancing optimization or repeated tests on same portfolios}

\item{momentFUN}{the name of a function to call to set portfolio moments, default \code{\link{set.portfolio.moments_v2}}}

\item{message}{TRUE/FALSE. The default is message=FALSE. Display messages if TRUE.}

\item{nodes}{how many processes to run in the foreach loop, default 4}
}
\value{
a list containing the optimal weights, some summary statistics, the function call, and optionally trace information
}
\description{
This function will not speed up optimization!
}
\details{
This function exists to run multiple copies of optimize.portfolio, presumabley in parallel using foreach.

This is typically done to test your parameter settings, specifically 
total population size, but also possibly to help tune your 
convergence settings, number of generations, stopping criteria,
etc.

If you want to use all the cores on your multi-core computer, use 
the parallel version of the apppropriate optimization engine, not 
this function.
}
\author{
Kris Boudt, Peter Carl, Brian G. Peterson
}
