% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{overviewByFS}
\alias{overviewByFS}
\title{generate an overview of the results by haploblock and by FS family}
\usage{
overviewByFS(haploblock, parents, FS, hapresults)
}
\arguments{
\item{haploblock}{a list of character vectors. The names are the names of the
haploblocks, the character vectors have the names of the markers in each
haploblock.}

\item{parents}{a matrix of two colums and one row per FS, containing the names
of the two parents of each FS}

\item{FS}{a list of character vectors with the names of the samples for
each FS}

\item{hapresults}{a list as returned by inferHaplotypes, with one
item per haploblock, containing at least all those in the list
specified by haploblock}
}
\value{
a list with two items:\cr
- ovw: an integer matrix with one row per haploblock and the following
columns:\cr
 * nmrk: the number of markers in the haploblock\cr
 * nhap: the number of different haplotypes assigned over all individuals
   (NA if no solution was found for this haplotype; the reason for that is
   listed in the first column of item messages of the return value)\cr
 * for each FS family a set of 6 columns:\cr
 + parmrk (0, 1 or 2: the number of parents with complete marker data)\cr
 + fit (0=FALSE or 1=TRUE), indicating if a solution for the FS was found
   based on polysomic inheritance)\cr
 + mrk: the number of FS progeny with complete marker data\cr
 + imp: the number of FS progeny where complete marker data were imputed\cr
 + hap: the number of FS progeny with assigned haplotype combinations.
   hap will be less than the mrk value if the same FS marker genotype can be
   produced with different combinations of haplotypes that are all compatible
   with the parental haplotype combinations) or if some FS marker genotypes
   cannot be produced by the inferred parental haplotype combinations\cr
 + P: the chi-squared P-value of the best fitting solution, even if this is
   discarded because of lack of fit).\cr
 * For "rest" (all individuals that are not part of the FS's or their
 parents) and "all" (all individuals) there are also columns mrk and hap,
 and for "all" there is also a column imp, similar to those for the
 FS families. The numbers for "all" are the sums
 of those for the FS families, the FS parents (some FS may share a parent
 but shared parents are counted only one) and the "rest".\cr
- messages  : a character matrix with one row per haploblock and the following
columns:\cr
 * haploblock: the reason why there is no solution for the
 haploblock ("" if there is a solution)
 * one column for each FS family with a possible message or "". A message
 can indicate a failure to find a solution for the FS family but may also
 describe less significant problems, such as some progeny with unexpected
 marker dosages etc.
}
\description{
generate an overview of the results by haploblock and by
FS family
}
\examples{
data(PolyHaplotyper_small)
overviewByFS(haploblock=phblocks, parents=phpar, FS=phFS,
            hapresults=phresults)
}
