% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PolyHaplotyper.R
\name{mrkdid2mrkdos}
\alias{mrkdid2mrkdos}
\title{get the marker dosages from mrkdids (marker dosage IDs)}
\usage{
mrkdid2mrkdos(dosageIDs, nmrk, ploidy, mrknames=NULL)
}
\arguments{
\item{dosageIDs}{vector of marker-dosage-combination IDs (mrkdid)}

\item{nmrk}{character vector of marker names in the haploblock}

\item{ploidy}{the ploidy level, a single positive integer}

\item{mrknames}{a vector of nmrk marker names (default NULL): if not NULL
these are used as rownames of the returned matrix}
}
\value{
a matrix with in columns the marker dosages corresponding to the
marker dosageIDs, with these mrkdids as colnames, and one row per marker,
with marker names as rownames if mrknames are specified
}
\description{
get the marker dosages from mrkdids (marker dosage IDs)
}
\examples{
# dosages of 3 markers in 3 tetraploid individuals:
mrkdosg <-
 matrix(c(1,2,2, 4,0,0, 3,0,2), nrow=3,
        dimnames=list(c("mrkA", "mrkB", "mrkC"), c("indiv1", "indiv2", "indiv3")))
# get the "marker dosage IDs":
dids <- mrkdos2mrkdid(mrkDosage=mrkdosg, ploidy=4)
# convert dids back to marker dosages:
mrkdid2mrkdos(dosageIDs=dids, nmrk=3, ploidy=4, mrknames=c("mrkA", "mrkB", "mrkC"))
}
