% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ftir.R
\name{plot_ftir}
\alias{plot_ftir}
\title{Plot FTIR Spectra Overlaid}
\usage{
plot_ftir(
  ftir,
  plot_title = "FTIR Spectra",
  legend_title = "Sample ID",
  lang = NA
)
}
\arguments{
\item{ftir}{A data.frame in long format with columns `sample_id`,
  `wavenumber`, and `absorbance`. The `absorbance` column may be replaced by
  a `transmittance` column for transmittance plots. The code determines the
  correct y axis units and labels the plot/adjusts the margins appropriately.

  Un data.frame au format long avec les colonnes `sample_id`, `wavenumber`,
  et `absorbance`. La colonne `absorbance` peut être remplacée par une
  colonne `transmittance` pour les tracés de transmission. Le code détermine
  les unités correctes de l'axe y et étiquette le tracé/ajuste les marges de
  manière appropriée.}

\item{plot_title}{A title for a plot. Defaults to "FTIR Spectra". If a vector
  length two, the second element will be used for a subtitle.

  Un titre pour une trace. La valeur par défaut est «FTIR Spectra». Si un
  vecteur mesure deux, le deuxième élément sera utilisé pour un sous-titre.}

\item{legend_title}{A title for the legend. Defaults to "Sample ID".

  Un titre pour la légende. La valeur par défaut est «Sample ID».}

\item{lang}{An optional argument for language. If set to one of `fr`,
  `french`, `francais`, or `français` the axis and default plot and legend
  titles will change to french. If non-default legend or plot titles are
  provided they are used as-is. You can also provide `en`, `english` or
  `anglais`, or (the default) `NA` will use the default language from user
  options. To set a permanent default, set `options("PlotFTIR.lang" = "en")`
  or `options("PlotFTIR.lang" = "fr")` for English or French, respectively.

  Un argument optionnel pour la langue. S'il vaut `Fr`, `French`, `Francais`,
  ou `Français`, l'axe et les titres par défaut de le tracé et du légende
  seront en français. Si des titres du légende ou de tracé autres que ceux
  par défaut sont fournis, ils seront utilisés tels quels. Vous pouvez aussi
  fournir `en`, `english` ou `anglais`, ou (le défaut) `NA` qui utilisera le
  langue par défaut des options de l'utilisateur. Pour définir une valeur
  par défaut permanente, mettez `options("PlotFTIR.lang" = "en")` ou
  `options("PlotFTIR.lang" = "fr")` pour l'anglais ou le français,
  respectivement.}
}
\value{
a ggplot object containing a  FTIR spectral plot. The plot and legend
  titles are as provided, with each sample provided a different default
  color. Because this is a ggplot object, any other ggplot modifiers, layers,
  or changes can be applied to the returned object. Further manipulations can
  be performed by this package. Peut également fournir `en`, `english` ou
  `anglais`.

  un objet ggplot contenant un tracé spectral IRTF. Les titres de le tracé et
  de la légende sont tels que fournis, avec une couleur par défaut différente
  pour chaque échantillon. Puisqu'il s'agit d'un objet ggplot, tous les
  autres modificateurs, calques ou changements ggplot peuvent être appliqués
  à l'objet retourné. D'autres manipulations peuvent être effectuées par ce
  package.
}
\description{
Produce a basic spectra overlay plot for all samples found in
the FTIR dataset provided.

Produisez un tracé de base de superposition de spectres pour tous les
échantillons trouvés dans l'ensemble de données IRTF fourni.
}
\examples{
if (requireNamespace("ggplot2", quietly = TRUE)) {
  # Plot a basic FTIR Spectra overlay from the `sample_spectra` data set with default titles
  plot_ftir(sample_spectra)
}
}
