% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_circos.R
\name{VDJ_circos}
\alias{VDJ_circos}
\title{Plots a Circos diagram from an adjacency matrix. Uses the Circlize chordDiagram function. Is called by VDJ_clonotype_clusters_circos(), VDJ_alpha_beta_Vgene_circos() and VDJ_VJ_usage_circos() functions or works on its own when supplied with an adjacency matrix.}
\usage{
VDJ_circos(
  Adj_matrix,
  platy.theme,
  group,
  grid.col,
  label.threshold,
  axis,
  c.count.label,
  arr.col,
  arr.direction,
  gene.label.size,
  gene.label,
  c.count.label.size
)
}
\arguments{
\item{Adj_matrix}{Adjacency matrix to be plotted. Rownames and Colnames correspond to genes to be matched and entries determine the weight of the connection between the genes (eg. number of clonotypes expressing these two genes).}

\item{platy.theme}{Allows plotting in the new "pretty" theme or the older "spiky" theme without group labels and radial arrangement of gene.labels. Default = "pretty".}

\item{group}{Named list of genes, with list elements corresponding to group-names, and element names being the gene-names. Is generated by VDJ_VJ_usage and VDJ_alpha_beta_Vgene_circos.}

\item{grid.col}{Named list of genes, with list elements corresponding to color and element names being gene-names. If not supplied it is generated randomly within the function. Is also generated by VDJ_VJ_usage and VDJ_alpha_beta_Vgene_circos.}

\item{label.threshold}{Genes are only labeled if the count is larger then the label.threshold. By default all label.threshold = 0 (all genes are labeled).}

\item{axis}{Option to choose the count axis for each gene. "default", "percent" or "max"  possible. Default: "max".}

\item{c.count.label}{Boolean, lets the user decide if the gene and count labels should be plotted or not. Default = T.}

\item{arr.col}{Data.frame with three columns where the first two indicate the names of genes, clonotypes or clusters to be connected, and the third corresponds to the color of the arrow. Default set to data.frame(c("dummy.clonotype"), c("dummy.cluster"), c("dummy.color")), so no arrow is drawn.}

\item{arr.direction}{Either 1 or -1 and determines the direction of the arrow. Default=1.}

\item{gene.label.size}{Determines the font size of the gene labels. By default the labelsize is automatically adjusted to 0.7 for labels with two or less digits, 0.6 for labels between 2 and 6 digits, and 0.4 for all longer labels. A manually defined font size will be the same for all labels!}

\item{gene.label}{Boolean, lets the user decide if the gene labels should be plotted or not.}

\item{c.count.label.size}{Determines the font size of the gene labels. By default the font size for count labels is 0.6.}
}
\value{
Returns a circos plot.
}
\description{
Plots a Circos diagram from an adjacency matrix. Uses the Circlize chordDiagram function. Is called by VDJ_clonotype_clusters_circos(), VDJ_alpha_beta_Vgene_circos() and VDJ_VJ_usage_circos() functions or works on its own when supplied with an adjacency matrix.
}
\examples{
\donttest{
try({
VDJ_circos(Adj_matrix =  VDJ_alpha_beta_Vgene_circos_output[[2]][[1]],
  grid.col = VDJ_alpha_beta_Vgene_circos_output[[3]],
  group = VDJ_alpha_beta_Vgene_circos_output[[4]],
  c.count.label.size = 0.4,
  gene.label.size = 0.5,
  arr.col = data.frame(c("TRBV10"),c("TRBJ2-7"), c("black")),
  axis="percent")
})
}
}
