% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spatial_module_expression.R
\name{Spatial_module_expression}
\alias{Spatial_module_expression}
\title{Plotting the expression of a gene module on the spatial image with or without a threshold.}
\usage{
Spatial_module_expression(
  sample_names,
  gene.set,
  GEX.out.directory.list,
  bcs_merge,
  images_tibble,
  title,
  size,
  threshold,
  legend_title
)
}
\arguments{
\item{sample_names}{Character vector containing the name of the sample.}

\item{gene.set}{Charcter vector containing the markers name.}

\item{GEX.out.directory.list}{Character vector that give the path to filtered_feature_bc_matrix data.}

\item{bcs_merge}{Data frame containing imagerow, imagecol and barcode of the cells belonging to the spatial image. It can also be created by the function scaling_spatial_image_parameter by selecting the output parameter 10.}

\item{images_tibble}{Tbl-df containing the sample name, grob, height and width of the spatial image. It can also be created by the function scaling_spatial_image_parameter by selecting the output parameter 5.}

\item{title}{Character vector to name the plot.}

\item{size}{Number, to define the size of the text, default = 15.}

\item{threshold}{Number, to define the threshold. If threshold = No, plot of the module and if threshold is a number, plot show the cells above the threshold.}

\item{legend_title}{Character vector to name the legend scale.}
}
\value{
Returns a ggplot of gene module expression.
}
\description{
Plotting the expression of a gene module on the spatial image with or without a threshold.
}
\examples{
\dontrun{
gene.set <- list() # make empty list
gene.set[[1]] <- c("CD19","XBP1","SDC1") # put gene set in list

#Without expression threshold
Spatial_module_expression(sample_names = sample_names,gene.set = gene.set,
GEX.out.directory.list = GEX.out.directory.list[[1]],bcs_merge = scaling_parameters[[10]],
images_tibble = scaling_parameters[[5]], threshold = "No")

#With expression threshold
Spatial_module_expression(sample_names = sample_names,gene.set = gene.set,
GEX.out.directory.list = GEX.out.directory.list[[1]],bcs_merge = scaling_parameters[[10]],
images_tibble = scaling_parameters[[5]], threshold = 1)
}
}
