% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VDJ_GEX_clonotype_clusters_circos.R
\name{VDJ_clonotype_clusters_circos}
\alias{VDJ_clonotype_clusters_circos}
\title{Circos plot for clonotype - GEX cluster pairings}
\usage{
VDJ_clonotype_clusters_circos(
  VDJ,
  topX,
  label.threshold,
  axis,
  c.count,
  n_cluster,
  platypus.version
)
}
\arguments{
\item{VDJ}{The output of the VDJ_GEX_integrate function (Platypus platypus.version v2). A list of data frames for each sample containing the clonotype information and cluster membership information. For Platypus platypus.version v3, the VDJ output of the VDJ_GEX_matrix function (VDJ_GEX_matrix.output[[1]]) has to be supplied.}

\item{topX}{Plots only the top X most expanded clonotypes. By default all clonotypes are shown.}

\item{label.threshold}{Minimal amount of clonotypes per gene neccessary to add a gene label to the sector. Default: 0.}

\item{axis}{Character. Defaults to "max". Passed to VDJ_circos}

\item{c.count}{Show clonotype or cell count on Circos plot. Default = T.}

\item{n_cluster}{Integer. No default.}

\item{platypus.version}{Which platypus.version of platypus is being used. Default = "v3".}
}
\value{
Returns list of plots. The first n elements contain the circos plot of the n datasets from the VDJ.analyze function. The n+1 element contains a list of the n adjancey matrices for each dataset.
}
\description{
Makes a Circos plot from the VDJ_GEX_integrate output. Connects the clonotypes with the corresponding clusters.
}
\examples{
#Platypus version 3
#prepare the small toy dataset
small_vgm <- Platypus::small_vgm
small_vgm[[1]]$clonotype_id_10x <- "clonotype1"
small_vgm[[1]]$clonotype_frequency <- nrow(small_vgm[[1]])
VDJ_clonotype_clusters_circos(small_vgm[[1]], topX=100, label.threshold=5
, platypus.version = "v3", n_cluster = 2)

}
