% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nicfi_utils.R
\name{aria2c_download_paths}
\alias{aria2c_download_paths}
\title{Format Mosaic and Quad weblinks to serve as input to the 'aria2c_bulk_donwload' function}
\usage{
aria2c_download_paths(mosaic_output, mosaic_id, quads_output, img_type = "tif")
}
\arguments{
\item{mosaic_output}{this parameter must be the output list of the 'nicfi_mosaics()' function}

\item{mosaic_id}{a character string specifying the mosaic-id as appears in the output column 'id' of the 'nicfi_mosaics()' function}

\item{quads_output}{this parameter must be the output list of the 'nicfi_quads_bbox()' function}

\item{img_type}{a character string specifying the image type to download. One of 'tif' or 'thumbnail'. The 'thumbnail' come with a .png image extension}
}
\value{
a character vector
}
\description{
Format Mosaic and Quad weblinks to serve as input to the 'aria2c_bulk_donwload' function
}
\details{
The 'thumbnail' are smaller in size and it might be a good idea to download these images first (just for an overview) before proceeding to the download of the .tif files (which are more than 100 MB each)
}
\examples{

\dontrun{

require(PlanetNICFI)

#....................................
# first extract the available Mosaics
#....................................

api_key = 'use_your_planet_nicfi_API_key'

mosaic_files = nicfi_mosaics(planet_api_key = api_key,
                             type = 'monthly',
                             crs_bbox = 4326,
                             URL = 'https://api.planet.com/basemaps/v1/mosaics',
                             verbose = TRUE)

#....................................
# keep the mosaic of 'September 2020'
#....................................

keep_idx = 1
mosaic_ID = mosaic_files$dtbl_mosaic$id[keep_idx]


#.....................................................
# then extract the available Quad files for the Mosaic
#.....................................................

wkt_file = system.file('data_files/Sugar_Cane_Bolivia.wkt', package = "PlanetNICFI")
WKT = readLines(wkt_file, warn = FALSE)

quad_files = nicfi_quads_bbox(planet_api_key = api_key,
                              mosaic_id = mosaic_ID,
                              bbox_AOI = NULL,
                              wkt_AOI = WKT,
                              page_size = 10,
                              crs_bbox = 4326,
                              verbose = TRUE)

#.............................
# download the .png thumbnails  (smaller size for overview)
#.............................

web_links_aria2c = aria2c_download_paths(mosaic_output = mosaic_files,
                                         mosaic_id = mosaic_ID,
                                         quads_output = quad_files,
                                         img_type = 'thumbnail')

#........................
# download the .tif files
#........................

web_links_aria2c = aria2c_download_paths(mosaic_output = mosaic_files,
                                         mosaic_id = mosaic_ID,
                                         quads_output = quad_files,
                                         img_type = 'tif')
}
}
