% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pltree-summaries.R
\name{pltree-summaries}
\alias{pltree-summaries}
\alias{coef.pltree}
\alias{vcov.pltree}
\alias{AIC.pltree}
\alias{predict.pltree}
\title{Plackett-Luce Tree Summaries}
\usage{
\method{coef}{pltree}(object, node = NULL, drop = TRUE, ...)

\method{vcov}{pltree}(object, node = nodeids(object, terminal = TRUE),
  ...)

\method{AIC}{pltree}(object, newdata = NULL, ...)

\method{predict}{pltree}(object, newdata = NULL, type = c("itempar",
  "rank", "best", "node"), ...)
}
\arguments{
\item{object}{a fitted model object of class \code{"pltree"}.}

\item{node}{a vector of node ids specifying the nodes to summarise, by
default the ids of the terminal nodes.}

\item{drop}{if \code{TRUE} return the coefficients as a vector when only one
node is selected.}

\item{...}{additional arguments passed to
\code{\link[=itempar.PlackettLuce]{itempar}} by \code{predict}, and to
\code{\link{model.frame}} by \code{AIC}.}

\item{newdata}{an optional data frame to use instead of the
original data. For \code{AIC} this must include the response variable.}

\item{type}{the type of prediction to return for each group, one of:
\code{"itempar"} to give the result of \code{\link{itempar}} (by default the
fitted probability of each item being ranked first out of all objects),
\code{"rank"} the corresponding rank, \code{"best"} the topped ranked item,
or \code{"node"} the node of the tree the group belongs to.}
}
\description{
Obtain the coefficients, variance-covariance matrix, AIC, or predictions
from a Plackett-Luce tree fitted by \code{\link[=pltree]{pltree()}}.
}
\details{
\code{AIC} computes \eqn{-2L + 2p}{-2 * L + 2 * p} where \eqn{L} is the
joint likelihood of the observed rankings under the tree model and
\eqn{p} is the degrees of freedom used to fit the tree model.
}
\examples{
data(beans)
# fit tree based on pairwise comparisons with variety B
pairB <- data.frame(Winner = ifelse(beans$var_b == "Worse",
                                    "Local", beans$variety_b),
                    Loser = ifelse(beans$var_b == "Worse",
                                   beans$variety_b, "Local"),
                    stringsAsFactors = FALSE, row.names = NULL)
beans$G <- as.rankings(pairB, input = "ordering",
                       index = rep(seq(nrow(beans)), 1))

mod <- pltree(G ~ ., data = beans[c("G", "maxTN")])

coef(mod, node = 3)
AIC(mod)

# treat first row from each year as new data
newdata <- beans[!duplicated(beans$year),]

## fitted probabilities
predict(mod, newdata)

## fitted log-abilities, with Local as reference
predict(mod, newdata, log = TRUE, ref = "Local")

## variety ranks
predict(mod, newdata, type = "rank")

## top ranked variety
predict(mod, newdata, type = "best")

## node the trial belongs to
predict(mod, newdata, type = "node")
}
