% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shutoff.R
\name{is.in.ranges}
\alias{is.in.ranges}
\title{Check wether parameters are in ranges.}
\usage{
is.in.ranges(p, min, max)
}
\arguments{
\item{min}{list of minimum values for the parameters}

\item{max}{list of maximum values for the parameters}

\item{params}{list of parameters with the correct structure}
}
\value{
boolean
}
\description{
\code{is.in.ranges.params} checks whether calculated parameters in the EM are
in the defined ranges.
}
\details{
######################################################
## Finite parameters ?
######################################################

is.finite.params.BM <- function(params) {
  if (params$root.state$random) {
    return(is.finite.params.BM.randroot(params))
  } else {
    return(is.finite.params.BM.fixedroot(params))
  }
}

is.finite.params.BM.randroot <- function(params) {
  if (is.finite(params$variance) &&
        is.finite(params$root.state$exp.root) &&
        is.finite(params$root.state$var.root) ) {
    return(TRUE)
  } else {
    return(FALSE)
  }
}

is.finite.params.BM.fixedroot <- function(params) {
  if ( is.finite(params$variance) &&
         is.finite(params$root.state$value.root) ) {
    return(TRUE)
  } else {
    return(FALSE)
  }
}

is.finite.params.OU <- function(stationary.root, shifts_at_nodes, alpha_known){
  if (stationary.root && shifts_at_nodes && alpha_known) {
    return(is.finite.params.OU.specialCase)
  } else if (stationary.root && shifts_at_nodes) {
    return(is.finite.params.OU.stationary.root_AND_shifts_at_nodes)
  } else {
    stop("The EM algorithm for the OU is only defined (for the moment) for a stationary root and shifts at nodes !")
  }
}

is.finite.params.OU.specialCase <- function(params) {
  if (is.finite(params$variance) &&
        is.finite(params$root.state$exp.root) &&
        is.finite(params$root.state$var.root) ) {
    return(TRUE)
  } else {
    return(FALSE)
  }
}

is.finite.params.OU.stationary.root_AND_shifts_at_nodes <- function(params) {
  if (is.finite(params$variance) &&
        is.finite(params$root.state$exp.root) &&
        is.finite(params$root.state$var.root) &&
        is.finite(params$selection.strength)) {
    return(TRUE)
  } else {
    return(FALSE)
  }
}


This function is used to test the convergence of the algorithm.
}
\keyword{internal}
