% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genDNAStringSet.R
\name{genDNAStringSet}
\alias{genDNAStringSet}
\title{Generate a DNA String Set}
\usage{
genDNAStringSet(DNABin)
}
\arguments{
\item{DNABin}{A DNA bin object.}
}
\value{
A DNA string set
}
\description{
Create a DNA string set object using a DNA bin object to write and read a FASTA file.
}
\examples{
# generate a DNA string set object using the taxon 'Antheraea polyphemus'
specdf_Anth <- querySpecData("Antheraea polyphemus")[1:10,]

DNABin_Anth <- genDNABin(specdf_Anth)

DNAStringset_Anth <- genDNAStringSet(DNABin_Anth)
}
