# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Simulates repitions of an Adaptive Eff-Tox Trial.
#'
#' This function simulates repititions of an adaptive Eff-Tox Trial and returns a list containing the optimal dose chosen
#' @param DoseStart Dose to start enrolling cohorts of patients at.
#' @param Dose Vector containing the standardized doses considered.
#' @param Hypermeans Vector containing prior hypermeans of length 6 for Eff-Tox parameters.
#' @param Hypervars Vector containing prior hypervariances of length 6 for Eff-Tox parameters.
#' @param Contour Vector containing 4 entries used to make the desireability function. Contour[1] contains a desired toxicity probability given efficacy, Countour[2] contains a desired efficacy probability given toxicity, and (Contour[3],Contour[4]) is an equally desireable pair of efficacy and toxicity probabilities that are non-zero or one.
#' @param PiLim Vector of length two with PiLim[1] containing the acceptable lower limit on efficacy probability and PiLim[2] containing the acceptable upper limit on toxicity probability.
#' @param ProbLim Vector of length two with ProbLim[1] containing the probability cutoff for acceptable efficacy probability and ProbLim[2] containing the probability cutoff for acceptable toxicity probability.
#' @param B Number of iterations to perform in the MCMC.
#' @param cohort Size of each patient cohort.
#' @param NET Maximum sample size for phase I/II.
#' @param NF Number of patients to assign optimal doses prior to adaptive randomization.
#' @param nSims Number of simulated trials to run.
#' @param PETrue True vector of efficacy probabilities for each dose.
#' @param PTTrue True vector of toxicity probabilities for each dose.
#' @return List containing the vector of optimal doses chosen, a matrix of posterior desireability scores for each trial, and a matrix consisting of patient dose assignments and Toxicity and Efficacy indicators, with each Nmax rows corresponding to a separate trial. Trials that are stopped due to excessive toxicity probabilty or small efficacy probabilities are not included in the final results.
#' @examples
#' ##Doses, YE,YT
#' ##Starting Dose
#' DoseStart=1
#'##Vector of Numerical Doses
#'Dose = c(1,2,3,3.5,5)
#'Dose=(Dose-mean(Dose))/sd(Dose)
#'## Contour Vector
#'Contour = c(.35, .75,.7,.4)
#'##Hypermeans
#'Hypermeans = c(.022,3.45,0,-4.23,3.1,0)
#'Hypervars = c(2.6761, 2.6852, .2, 3.1304, 3.1165, 1)
#'Hypervars=Hypervars^2
#'##Acceptability Criteria
#'PiLim = c(.3,.4)
#'ProbLim=c(.1,.1)
#'##Cohort Size, N^F and N_ET
#'cohort=3
#'NF=15
#'NET=30
#'PTTrue = c(.1,.15,.25,.35,.5)
#'PETrue=c(.2,.4,.6,.65,.7)
#'##Number of iterations for MCMC
#'B=2000
#'### Number of Simulations
#'nSims=1
#'RunAdaptiveEffToxTrial(DoseStart,Dose, Hypermeans,  Hypervars,
#'Contour, PiLim, ProbLim,  cohort, NET,  NF, B, nSims, PETrue, PTTrue )
#'@export
RunAdaptiveEffToxTrial <- function(DoseStart, Dose, Hypermeans, Hypervars, Contour, PiLim, ProbLim, cohort, NET, NF, B, nSims, PETrue, PTTrue) {
    .Call('Phase123_RunAdaptiveEffToxTrial', PACKAGE = 'Phase123', DoseStart, Dose, Hypermeans, Hypervars, Contour, PiLim, ProbLim, cohort, NET, NF, B, nSims, PETrue, PTTrue)
}

#' Determines the optimal dose to assign the next patient cohort.
#'
#' This function returns the optimal acceptable dose number to assign the next patient cohort or stops the trial if no dose is deemed acceptable.
#' @param YE   Vector containing observed efficacy indicators.
#' @param YT   Vector containing observed toxicity indicators.
#' @param Doses Vector containing numbered Doses of patients in trial.
#' @param Dose Vector containing the standardized doses considered.
#' @param DosesTried Binary vector corresponding to which doses have been tried.
#' @param Hypermeans Vector containing prior hypermeans of length 6 for Eff-Tox parameters.
#' @param Hypervars Vector containing prior hypervariances of length 6 for Eff-Tox parameters.
#' @param Contour Vector containing 4 entries used to make the desireability function. Contour[1] contains a desired toxicity probability given efficacy, Countour[2] contains a desired efficacy probability given toxicity, and (Contour[3],Contour[4]) is an equally desireable pair of efficacy and toxicity probabilities that are non-zero or one.
#' @param PiLim Vector of length two with PiLim[1] containing the acceptable lower limit on efficacy probability and PiLim[2] containing the acceptable upper limit on toxicity probability.
#' @param ProbLim Vector of length two with ProbLim[1] containing the probability cutoff for acceptable efficacy probability and ProbLim[2] containing the probability cutoff for acceptable toxicity probability.
#' @param B Number of iterations to perform in the MCMC.
#' @return The optimal dose level to administer the next patient cohort.
#'@examples
#'##Doses, YE,YT
#'Doses= c(1,1,1,2,2,2,1,1,1,3,3,3,1,1,1,2,2,2)
#'YE = c(0,0,1,1,1,0,0,0,0,1,1,1,0,0,1,1,1,0)
#'YT=c(0,0,0,1,1,0,1,0,0,1,1,1,0,0,0,1,0,0)
#'##Vector of Numerical Doses
#'Dose = c(1,2,3,3.5,5)
#'Dose=(Dose-mean(Dose))/sd(Dose)
#'##Five doses, but only 3 tried so we have
#'DosesTried=c(1,1,1,0,0)
#'## Contour Vector
#'Contour = c(.35, .75,.7,.4)
#'##Hypermeans
#'Hypermeans = c(.022,3.45,0,-4.23,3.1,0)
#'Hypervars = c(2.6761, 2.6852, .2, 3.1304, 3.1165, 1)
#'Hypervars=Hypervars^2
#'##Acceptability Criteria
#'PiLim = c(.3,.4)
#'ProbLim=c(.1,.1)
#'##Number of iterations
#'B=2000
#'AssignEffTox(YE,YT, Doses, Dose, DosesTried, Hypermeans,  Hypervars, Contour, PiLim,  ProbLim, B )
#'@export
AssignEffTox <- function(YE, YT, Doses, Dose, DosesTried, Hypermeans, Hypervars, Contour, PiLim, ProbLim, B) {
    .Call('Phase123_AssignEffTox', PACKAGE = 'Phase123', YE, YT, Doses, Dose, DosesTried, Hypermeans, Hypervars, Contour, PiLim, ProbLim, B)
}

#' Randomizes Eff-Tox dose proportional to posterior desireability scores.
#'
#' This function returns a random acceptable dose number to assign the next patient cohort or stops the trial if no dose is deemed acceptable.
#' @param YE   Vector containing observed efficacy indicators.
#' @param YT   Vector containing observed toxicity indicators.
#' @param Doses Vector containing numbered Doses of patients in trial.
#' @param Dose Vector containing the standardized doses considered.
#' @param DosesTried Binary vector corresponding to which doses have been tried.
#' @param Hypermeans Vector containing prior hypermeans of length 6 for Eff-Tox parameters.
#' @param Hypervars Vector containing prior hypervariances of length 6 for Eff-Tox parameters.
#' @param Contour Vector containing 4 entries used to make the desireability function. Contour[1] contains a desired toxicity probability given efficacy, Countour[2] contains a desired efficacy probability given toxicity, and (Contour[3],Contour[4]) is an equally desireable pair of efficacy and toxicity probabilities that are non-zero or one.
#' @param PiLim Vector of length two with PiLim[1] containing the acceptable lower limit on efficacy probability and PiLim[2] containing the acceptable upper limit on toxicity probability.
#' @param ProbLim Vector of length two with ProbLim[1] containing the probability cutoff for acceptable efficacy probability and ProbLim[2] containing the probability cutoff for acceptable toxicity probability.
#' @param B Number of iterations to perform in the MCMC.
#' @return A random dose level to administer the next patient cohort.
#'@examples
#'##Doses, YE,YT
#'Doses= c(1,1,1,2,2,2,1,1,1,3,3,3,1,1,1,2,2,2)
#'YE = c(0,0,1,1,1,0,0,0,0,1,1,1,0,0,1,1,1,0)
#'YT=c(0,0,0,1,1,0,1,0,0,1,1,1,0,0,0,1,0,0)
#'##Vector of Numerical Doses
#'Dose = c(1,2,3,3.5,5)
#'Dose=(Dose-mean(Dose))/sd(Dose)
#'##Five doses, but only 3 tried so we have
#'DosesTried=c(1,1,1,0,0)
#'## Contour Vector
#'Contour = c(.35, .75,.7,.4)
#'##Hypermeans
#'Hypermeans = c(.022,3.45,0,-4.23,3.1,0)
#'Hypervars = c(2.6761, 2.6852, .2, 3.1304, 3.1165, 1)
#'Hypervars=Hypervars^2
#'##Acceptability Criteria
#'PiLim = c(.3,.4)
#'ProbLim=c(.1,.1)
#'##Number of iterations
#'B=2000
#'RandomEffTox(YE,YT, Doses, Dose, DosesTried, Hypermeans,  Hypervars, Contour, PiLim,  ProbLim, B )
#'@export
RandomEffTox <- function(YE, YT, Doses, Dose, DosesTried, Hypermeans, Hypervars, Contour, PiLim, ProbLim, B) {
    .Call('Phase123_RandomEffTox', PACKAGE = 'Phase123', YE, YT, Doses, Dose, DosesTried, Hypermeans, Hypervars, Contour, PiLim, ProbLim, B)
}

#' Returns posterior distribution for key mixture model parameters
#'
#' This function performs MCMC with Metropolis-Hastings-Green steps for the baseline hazard function and is used in the functions Reoptimize, SimPhase123 and SimPhase3.
#' @param Y Patient survival or followup times.
#' @param I Patient event indicators.
#' @param YE Vector of indicators for patient efficacy.
#' @param YT Vector of indicators for patient toxicity.
#' @param Doses Vector of standardized doses given to patients.
#' @param Dose Vector of standardized doses considered in trial.
#' @param B Number of iterations to perform in MCMC.
#' @param prob  length(Doses) X 4 matrix containing the estimated posterior probabilities for each dose and each (Efficacy, Toxicity) outcomes.
#' @param MaxObs length(Doses) X 4 matrix containing the maximum observed survival time we want to evaluate the means to.
#'@return Returns a list containing a matrix of posterior means for each dose, regression coefficients in the cox models, locations of the split points, log hazard heights on each interval, and the number of intervals in the baseline hazard.
#'@examples
#'n=100
#'Y=rexp(n,1)
#'I = rbinom(n,1,.9)
#'YE = rbinom(n,1,.5)
#'YT = rbinom(n,1,.5)
#'Dose = c(1,2,3,3.5,5)
#'Dose=(Dose-mean(Dose))/sd(Dose)
#'Doses = sample(1:5,n,replace=TRUE)
#'Doses=Dose[Doses]
#'B=2000
#'MaxObs = matrix(rep(0,length(Dose)*4),nrow=4)
#'prob=matrix(rep(0,length(Dose)*4),ncol=4)
#'prob=prob+1/4
#'MaxObs=MaxObs+max(Y)
#'G=PieceMCMC(Y,I,YE,YT,Doses,Dose,B,prob,MaxObs)
#'@export
PieceMCMC <- function(Y, I, YE, YT, Doses, Dose, B, prob, MaxObs) {
    .Call('Phase123_PieceMCMC', PACKAGE = 'Phase123', Y, I, YE, YT, Doses, Dose, B, prob, MaxObs)
}

#' Obtains estimated posterior probabilities of the four outcomes of (YE,YT) for each dose.
#'
#' This function is used in Reoptimize, SimPhase123 and SimPhase3, here we estimate the mixture probabilities over the four outcomes for efficacy and toxicity.
#' @param YE   Vector containing observed efficacy indicators.
#' @param YT   Vector containing observed toxicity indicators.
#' @param Doses Vector containing Standardized doses of patients in trial.
#' @param Dose Vector containing the standardized doses considered.
#' @param Hypermeans Vector containing prior hypermeans of length 6 for Eff-Tox parameters.
#' @param Hypervars Vector containing prior hypervariances of length 6 for Eff-Tox parameters.
#' @param B Number of iterations to perform in the MCMC.
#' @return The posterior probability matrix for the events (YE,YT) in each row corresponding to a dose level.
#'@examples
#'##Doses, YE,YT
#'Doses= c(1,1,1,2,2,2,1,1,1,3,3,3,1,1,1,2,2,2)
#'YE = c(0,0,1,1,1,0,0,0,0,1,1,1,0,0,1,1,1,0)
#'YT=c(0,0,0,1,1,0,1,0,0,1,1,1,0,0,0,1,0,0)
#'##Vector of Numerical Doses
#'Dose = c(1,2,3,3.5,5)
#'Dose=(Dose-mean(Dose))/sd(Dose)
#'Doses=Dose[Doses]
#'##Hypermeans
#'Hypermeans = c(.022,3.45,0,-4.23,3.1,0)
#'Hypervars = c(2.6761, 2.6852, .2, 3.1304, 3.1165, 1)
#'Hypervars=Hypervars^2
#'##Number of iterations
#'B=2000
#'EFFTOX(YE,YT, Doses, Dose, Hypermeans,  Hypervars, B )
#'@export
EFFTOX <- function(YE, YT, Doses, Dose, Hypermeans, Hypervars, B) {
    .Call('Phase123_EFFTOX', PACKAGE = 'Phase123', YE, YT, Doses, Dose, Hypermeans, Hypervars, B)
}

