% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table.AnnualizedReturns.R
\name{table.AnnualizedReturns}
\alias{table.AnnualizedReturns}
\title{Annualized Returns Summary: Statistics and Stylized Facts}
\usage{
table.AnnualizedReturns(R, scale = NA, Rf = 0, geometric = TRUE, digits = 4)
}
\arguments{
\item{R}{an xts, vector, matrix, data frame, timeSeries or zoo object of
asset returns}

\item{scale}{number of periods in a year (daily scale = 252, monthly scale =
12, quarterly scale = 4)}

\item{Rf}{risk free rate, in same period as your returns}

\item{geometric}{utilize geometric chaining (TRUE) or simple/arithmetic chaining (FALSE) to aggregate returns,
default TRUE}

\item{digits}{number of digits to round results to}
}
\description{
Table of Annualized Return, Annualized Std Dev, and Annualized Sharpe
}
\examples{

data(managers)
table.AnnualizedReturns(managers[,1:8])

require("Hmisc")
result = t(table.AnnualizedReturns(managers[,1:8], Rf=.04/12))

textplot(format.df(result, na.blank=TRUE, numeric.dollar=FALSE, 
         cdec=c(3,3,1)), rmar = 0.8, cmar = 2,  max.cex=.9, 
         halign = "center", valign = "top", row.valign="center", 
         wrap.rownames=20, wrap.colnames=10, col.rownames=c("red", 
         rep("darkgray",5), rep("orange",2)), mar = c(0,0,3,0)+0.1)
         
title(main="Annualized Performance")

}
\seealso{
\code{\link{Return.annualized}} \cr \code{\link{StdDev.annualized}}
\cr \code{\link{SharpeRatio.annualized}}
}
\author{
Peter Carl
}
