% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.conf.mat.R
\name{plotConfmat}
\alias{plotConfmat}
\title{generate heat map for a matrix}
\usage{
plotConfmat(conf.mat, ordering = NA, labels = FALSE, ...)
}
\arguments{
\item{conf.mat}{an N-by-N matrix. Either a conflict matrix or 
a win-loss probability matrix (the second element from \code{conductance} output)}

\item{ordering}{a reordering of the rows/columns, specified by a permutation of 1:N}

\item{labels}{if TRUE, displaying the agent names as 
specified in the \code{rownames()} of \code{conf.mat()} on the heatmap}

\item{...}{Further argument may be supplied and processed by \code{lattice::levelplot}.}
}
\value{
A heatmap
}
\description{
\code{plotConfmat} generate heat map for a matrix or a win-loss probability matrix
}
\examples{
# convert an edgelist to conflict matrix
confmatrix <- as.conflictmat(sampleEdgelist)
# find win-loss probability matrix
perm2 <- conductance(confmatrix, 2)
# plotting
plotConfmat(perm2$p.hat)
}
\seealso{
\code{\link{as.conflictmat}}, \code{\link{conductance}}
}

