% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/PerMallows.R
\name{lgmm.theta}
\alias{lgmm.theta}
\title{MLE for theta - Generalized Mallows Model}
\usage{
lgmm.theta(sample, sigma_0 = identity.permutation(dim(sample)[2]),
  dist.name = "kendall")
}
\arguments{
\item{sample}{the matrix with the permutations to estimate}

\item{sigma_0}{optional the initial guess for the consensus permutation. If not given it is assumed to be the identity permutation}

\item{dist.name}{optional name of the distance used by the GMM. One of: kendall (default), cayley, hamming}
}
\value{
The MLE for the dispersion parameter
}
\description{
Compute the MLE for the dispersion parameter (theta) given a sample of n permutations
and a central permutation
}
\examples{
sample <- matrix(c(1,2,3,4, 1,4,3,2, 1,2,4,3), nrow = 3, ncol = 4, byrow = TRUE)
lgmm.theta(sample, dist.name="kendall")
lgmm.theta(sample, dist.name="cayley")
lgmm.theta(sample, dist.name="cayley", sigma_0=c(1,4,3,2))
lgmm.theta(sample, dist.name="hamming")
}

