% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zScales.R
\name{zScales}
\alias{zScales}
\title{Compute the Z-scales of a protein sequence}
\usage{
zScales(seq)
}
\arguments{
\item{seq}{An amino-acids sequence}
}
\value{
The computed average of Z-scales of all the amino acids in the corresponding peptide sequence. Each Z scale represent an amino-acid property as follows:
\itemize{
\item{Z1:} Lipophilicity
\item{Z2:} Steric properties (Steric bulk/Polarizability)
\item{Z3:} Electronic properties (Polarity / Charge) 
\item{Z4 and Z5:} They relate electronegativity, heat of formation, electrophilicity and hardness.
}
}
\description{
Z-scales are based on physicochemical properties of the AAs including NMR data and thin-layer chromatography (TLC) data.
}
\examples{
zScales(seq = "QWGRRCCGWGPGRRYCVRWC")
# [[1]]
#  Z1      Z2      Z3      Z4      Z5 
# 0.6200  0.0865  0.0665  0.7280 -0.8740 
}
\references{
Sandberg M, Eriksson L, Jonsson J, Sjostrom M, Wold S: New chemical descriptors relevant for the design of biologically active peptides. A multivariate characterization of 87 amino acids. J Med Chem 1998, 41:2481-2491.
}
