% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDemographicsQuery.R
\name{addPriorObservationQuery}
\alias{addPriorObservationQuery}
\title{Query to add the number of days of prior observation in the current
observation period at a certain date}
\usage{
addPriorObservationQuery(
  x,
  indexDate = "cohort_start_date",
  priorObservationName = "prior_observation",
  priorObservationType = "days"
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{indexDate}{Variable in x that contains the date to compute the prior
observation.}

\item{priorObservationName}{name of the new column to be added.}

\item{priorObservationType}{Whether to return a "date" or the number of
"days".}
}
\value{
cohort table with added column containing prior observation of the
individuals.
}
\description{
`r lifecycle::badge("experimental")`
Same as `addPriorObservation()`, except query is not computed to a table.
}
\examples{
\donttest{
cdm <- mockPatientProfiles()

cdm$cohort1 |>
  addPriorObservationQuery()

mockDisconnect(cdm = cdm)
}
}
