% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting.R
\name{plotVariableScatterplot}
\alias{plotVariableScatterplot}
\title{Plot the variable importance scatterplot}
\usage{
plotVariableScatterplot(
  covariateSummary,
  saveLocation = NULL,
  fileName = "VariableScatterplot.png"
)
}
\arguments{
\item{covariateSummary}{A prediction object as generated using the
\code{\link{runPlp}} function.}

\item{saveLocation}{Directory to save plot (if NULL plot is not saved)}

\item{fileName}{Name of the file to save to plot, for example
'plot.png'. See the function \code{ggsave} in the ggplot2 package for
supported file formats.}
}
\value{
A ggplot object. Use the \code{\link[ggplot2]{ggsave}} function to save to file in a different
format.
}
\description{
Plot the variable importance scatterplot
}
\details{
Create a plot showing the variable importance scatterplot
#'
}
\examples{
\dontshow{if (rlang::is_installed("ggplot2")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{ \dontshow{ # takes too long }
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n=1000)
saveLoc <- file.path(tempdir(), "plotVariableScatterplot")
results <- runPlp(plpData, outcomeId = 3, saveDirectory = saveLoc)
plotVariableScatterplot(results$covariateSummary)
# clean up
}
\dontshow{\}) # examplesIf}
}
