% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addIterations.R
\name{addIterations}
\alias{addIterations}
\title{Run Additional Optimization Iterations}
\usage{
addIterations(
  optObj,
  iters.n = 1,
  iters.k = 1,
  otherHalting = list(timeLimit = Inf, minUtility = 0),
  bounds = optObj$bounds,
  acq = optObj$optPars$acq,
  kappa = optObj$optPars$kappa,
  eps = optObj$optPars$eps,
  gsPoints = optObj$optPars$gsPoints,
  convThresh = optObj$optPars$convThresh,
  acqThresh = optObj$optPars$acqThresh,
  errorHandling = "stop",
  saveFile = optObj$saveFile,
  parallel = FALSE,
  plotProgress = FALSE,
  verbose = 1,
  ...
)
}
\arguments{
\item{optObj}{an object of class \code{bayesOpt}.}

\item{iters.n}{The total number of additional times to sample the scoring function.}

\item{iters.k}{integer that specifies the number of times to sample FUN
at each Epoch (optimization step). If running in parallel, good practice
is to set \code{iters.k} to some multiple of the number of cores you have designated
for this process. Must belower than, and preferrably some multiple of \code{iters.n}.}

\item{otherHalting}{Same as \code{bayesOpt()}}

\item{bounds}{Same as \code{bayesOpt()}}

\item{acq}{Same as \code{bayesOpt()}}

\item{kappa}{Same as \code{bayesOpt()}}

\item{eps}{Same as \code{bayesOpt()}}

\item{gsPoints}{Same as \code{bayesOpt()}}

\item{convThresh}{Same as \code{bayesOpt()}}

\item{acqThresh}{Same as \code{bayesOpt()}}

\item{errorHandling}{Same as \code{bayesOpt()}}

\item{saveFile}{Same as \code{bayesOpt()}}

\item{parallel}{Same as \code{bayesOpt()}}

\item{plotProgress}{Same as \code{bayesOpt()}}

\item{verbose}{Same as \code{bayesOpt()}}

\item{...}{Same as \code{bayesOpt()}}
}
\value{
An object of class \code{bayesOpt} having run additional iterations.
}
\description{
Use this function to continue optimization of a bayesOpt object.
}
\details{
By default, this function uses the original parameters used to create
\code{optObj}, however the parameters (including the bounds) can be customized.
If new bounds are used which cause some of the prior runs to fall outside of
the bounds, these samples are removed from the optimization procedure, but
will remain in \code{scoreSummary}. \code{FUN} should return the same elements
and accept the same inputs as the original, or this function may fail.
}
\examples{
scoringFunction <- function(x) {
  a <- exp(-(2-x)^2)*1.5
  b <- exp(-(4-x)^2)*2
  c <- exp(-(6-x)^2)*1
  return(list(Score = a+b+c))
}

bounds <- list(x = c(0,8))

Results <- bayesOpt(
    FUN = scoringFunction
  , bounds = bounds
  , initPoints = 3
  , iters.n = 1
  , gsPoints = 10
)
Results <- addIterations(Results,iters.n=1)
}
