% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/listwise_delete.R
\name{lwd_refinement}
\alias{lwd_refinement}
\title{lwd_refinement
master function that performs refinement with listwise deletion = TRUE}
\usage{
lwd_refinement(
  msets,
  global.data,
  treated.ts,
  treated.ids,
  lag,
  time.id,
  unit.id,
  lead,
  refinement.method,
  treatment,
  size.match,
  match.missing,
  covs.formula,
  verbose,
  outcome.var,
  e.sets,
  use.diag.covmat
)
}
\arguments{
\item{msets}{}

\item{global.data}{data.frame. needs to be fully prepped/parsed data set that is internally balanced, full of NAs likely}

\item{treated.ts}{vector of the times of treatment for treated observations}

\item{treated.ids}{vector of unit identifiers of treated observations}

\item{lag}{}

\item{time.id}{string specifying}

\item{unit.id}{}

\item{lead}{vector of lead values}

\item{refinement.method}{string specifying refinement method}

\item{treatment}{string specifying treatment variable}

\item{size.match}{maximum number of units to give non-zero weight to when using matching refinement method}

\item{match.missing}{logical. indicates whether or not to allow the package to match units on missingness in treatment history}

\item{covs.formula}{see PanelMatch documentation for descriptions}

\item{verbose}{see PanelMatch documentation for descriptions}

\item{outcome.var}{string specifying outcome variable}

\item{e.sets}{empty sets (treated observations with no matched controls)}

\item{use.diag.covmat}{see PanelMatch documentation for descriptions}
}
\value{
matched.set object with refined matched sets.
}
\description{
lwd_refinement
master function that performs refinement with listwise deletion = TRUE
}
\keyword{internal}
