% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6-File.R
\name{File}
\alias{File}
\title{R6 File class}
\description{
Class representing a file containing code.
}
\examples{
fetchedRepo <- tryCatch(
  {
    # Set dir to clone repository to.
    tempDir <- tempdir()
    pathToRepo <- file.path(tempDir, "glue")

    # Clone repo
    git2r::clone(
      url = "https://github.com/tidyverse/glue.git",
      local_path = pathToRepo
    )

    # Create instance of Repository object.
    repo <- PaRe::Repository$new(path = pathToRepo)

    # Set fetchedRepo to TRUE if all goes well.
    TRUE
  },
  error = function(e) {
    # Set fetchedRepo to FALSE if an error is encountered.
    FALSE
  },
  warning = function(w) {
    # Set fetchedRepo to FALSE if a warning is encountered.
    FALSE
  }
)

if (fetchedRepo) {
  files <- repo$getRFiles()
  files[[1]]
}
}
\seealso{
Other Representations: 
\code{\link{Code}},
\code{\link{Function}},
\code{\link{Repository}}
}
\concept{Representations}
\section{Super class}{
\code{PaRe::Code} -> \code{File}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-File-new}{\code{File$new()}}
\item \href{#method-File-getFunctions}{\code{File$getFunctions()}}
\item \href{#method-File-getFunctionTable}{\code{File$getFunctionTable()}}
\item \href{#method-File-getType}{\code{File$getType()}}
\item \href{#method-File-getFilePath}{\code{File$getFilePath()}}
\item \href{#method-File-getBlameTable}{\code{File$getBlameTable()}}
\item \href{#method-File-clone}{\code{File$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="PaRe" data-topic="Code" data-id="getLines"><a href='../../PaRe/html/Code.html#method-Code-getLines'><code>PaRe::Code$getLines()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PaRe" data-topic="Code" data-id="getNLines"><a href='../../PaRe/html/Code.html#method-Code-getNLines'><code>PaRe::Code$getNLines()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PaRe" data-topic="Code" data-id="getName"><a href='../../PaRe/html/Code.html#method-Code-getName'><code>PaRe::Code$getName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="PaRe" data-topic="Code" data-id="print"><a href='../../PaRe/html/Code.html#method-Code-print'><code>PaRe::Code$print()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-File-new"></a>}}
\if{latex}{\out{\hypertarget{method-File-new}{}}}
\subsection{Method \code{new()}}{
Initializer method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{File$new(repoPath, filePath)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{repoPath}}{(\link[base]{character})\cr
Path to repository.}

\item{\code{filePath}}{(\link[base]{character})\cr
Relative path to file}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{invisible(self)}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-File-getFunctions"></a>}}
\if{latex}{\out{\hypertarget{method-File-getFunctions}{}}}
\subsection{Method \code{getFunctions()}}{
Get method to get a list of Function objects
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{File$getFunctions()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\link[base]{list})\cr
List of \link[PaRe]{Function} objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-File-getFunctionTable"></a>}}
\if{latex}{\out{\hypertarget{method-File-getFunctionTable}{}}}
\subsection{Method \code{getFunctionTable()}}{
Get method to retrieve the function table.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{File$getFunctionTable()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\link[base]{data.frame})\tabular{ll}{
   column \tab data type \cr
   name \tab \link[base]{character} \cr
   lineStart \tab \link[base]{integer} \cr
   lineEnd \tab \link[base]{numeric} \cr
   nArgs \tab \link[base]{integer} \cr
   cycloComp \tab \link[base]{integer} \cr
}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-File-getType"></a>}}
\if{latex}{\out{\hypertarget{method-File-getType}{}}}
\subsection{Method \code{getType()}}{
Gets type of file
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{File$getType()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\link[base]{character})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-File-getFilePath"></a>}}
\if{latex}{\out{\hypertarget{method-File-getFilePath}{}}}
\subsection{Method \code{getFilePath()}}{
Gets relative file path
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{File$getFilePath()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\link[base]{character})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-File-getBlameTable"></a>}}
\if{latex}{\out{\hypertarget{method-File-getBlameTable}{}}}
\subsection{Method \code{getBlameTable()}}{
Gets table of git blame
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{File$getBlameTable()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
(\link[dplyr]{tibble})
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-File-clone"></a>}}
\if{latex}{\out{\hypertarget{method-File-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{File$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
