% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncertainty.R
\name{plr_bootstrap_output}
\alias{plr_bootstrap_output}
\title{Bootstrap: Resampling from individual Models}
\usage{
plr_bootstrap_output(
  df,
  var_list,
  model,
  by = "month",
  fraction = 0.65,
  n = 1000,
  predict_data = NULL,
  np = NA,
  power_var = "power_var",
  time_var = "time_var",
  ref_irrad = 900,
  irrad_range = 10
)
}
\arguments{
\item{df}{A dataframe containing pv data.}

\item{var_list}{A list of the dataframe's standard variable names, obtained from
the plr_variable_check output.}

\item{model}{The model you would like to calculate the uncertainty of. Use
"xbx", "xbx+utc", "pvusa", or "6k".}

\item{by}{String indicating time step count per year for the regression. 
Use "day", "month", or "year". See \code{\link{plr_weighted_regression}}.}

\item{fraction}{The size of each sample relative to the total dataset.}

\item{n}{Number of samples to take.}

\item{predict_data}{passed to predict_data in model call. See \code{\link{plr_xbx_model}}
for example.}

\item{np}{The system's reported name plate power. See \code{\link{plr_6k_model}}.}

\item{power_var}{The name of the power variable after being put through a Performance
Loss Rate (PLR) determining test. Typically "power_var".}

\item{time_var}{The name of the time variable after being put through a PLR
determining test. Typically "time_var".}

\item{ref_irrad}{The irradiance value at which to calculate the universal
temperature coefficient. Since irradiance is a much stronger influencer on power generation
than temperature, it is important to specify a small range of irradiance data 
from which to estimate the effect of temperature.}

\item{irrad_range}{The range of the subset used to calculate the universal
temperature coefficient. See above.}
}
\value{
Returns PLR value and uncertainty calculated with bootstrap of data from power correction models
}
\description{
This function determines uncertainty of a PLR measurement
by sampling results from invididual models. Specify the model you would like
to find the uncertainty of, and the function will put the dataframe through the
selected model and return the uncertainties of the model's results.
}
\examples{
# build var_list
\donttest{
var_list <- plr_build_var_list(time_var = "timestamp",
                               power_var = "power",
                               irrad_var = "g_poa",
                               temp_var = "mod_temp",
                               wind_var = NA)
# Clean Data
test_dfc <- plr_cleaning(test_df, var_list, irrad_thresh = 100,
                         low_power_thresh = 0.01, high_power_cutoff = NA)

xbx_mbm_plr_output_uncertainty <- plr_bootstrap_output(test_dfc, var_list,
                                                       model = "xbx", fraction = 0.65,
                                                       n = 10, power_var = 'power_var',
                                                       time_var = 'time_var', ref_irrad = 900,
                                                       irrad_range = 10, by = "month",
                                                       np = NA, pred = NULL)
}

}
