% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/redlichpetersonanalysis.R
\name{redlichpetersonanalysis}
\alias{redlichpetersonanalysis}
\title{Redlich-Peterson Isotherm Nonlinear Analysis}
\usage{
redlichpetersonanalysis(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the adsorbed capacity}
}
\value{
the nonlinear regression, parameters for Redlich-Peterson isotherm, and model error analysis
}
\description{
Redlich-Peterson isotherm model has an exponential function which
can be found in the denominator and in the numerator, it has a linear dependence
on the concentration denoting the adsorption equilibrium depending on a wide
range of concentration
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
redlichpetersonanalysis(Ce,Qe)
}
\references{
Peterson, D. L. and Redlich, O.(1959) <doi:10.1021/j150576a611> A useful adsorption isotherm.
J PhysChem US;63(6):1024. Research, vol. 6, no. 1, pp. 265-276, 2012.
}
\author{
Keith T. Ostan

Chester C. Deocaris
}
