% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/koblecorriganLM.R
\name{koblecarrigan.LM}
\alias{koblecarrigan.LM}
\title{Koble-Carrigan Isotherm Linear Analysis}
\usage{
koblecarrigan.LM(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the adsorbed capacity}
}
\value{
the linear regression, parameters for Koble-Carrigan isotherm,
and model error analysis
}
\description{
It is three-parameter isotherm model equation that incorporates
both Freundlich and Langmuir isotherms for representing equilibrium adsorption
data. Koble-Corrigan isotherm model appeared to have advantages over both the
Langmuir and Freundlich equations in that it expresses adsorption data over
very wide ranges of pressures and temperatures.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
koblecarrigan.LM(Ce, Qe)
}
\references{
Corrigan, T. E., and Koble, R. A.(1952) <doi:10.1021/ie50506a049>
Adsorption isotherms for pure hydrocarbons Ind. Eng. Chem. 44 383-387.
}
\author{
Keith T. Ostan

Chester C. Deocaris
}
