% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webervanvlietanalysis.r
\name{webervanvlietanalysis}
\alias{webervanvlietanalysis}
\title{Weber-Van Vliet Isotherm Nonlinear Analysis}
\usage{
webervanvlietanalysis(Qe, Ce)
}
\arguments{
\item{Qe}{the numerical value for the adsorbed capacity}

\item{Ce}{the numerical value for the equilibrium capacity}
}
\value{
the nonlinear regression and the parameters for Weber-Van-Vliet
Isotherm Analysis
}
\description{
It provides an excellent description of data patterns for a broad
range of systems. This model is suitable for batch rate and fixed-bed modelling
procedures as it gives a direct parameter evaluation.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
webervanvlietanalysis(Qe,Ce)
}
\references{
Van Vliet, B.M., Weber Jr., Hozumi, H.. (1979) <doi:10.1016/0043-1354(80)90107-4> Modeling and
prediction of specific compound adsorption by activated carbon and synthetic
adsorbents. Water Research Vol.14, pp. 1719 to 1728.
}
\author{
Keith T. Ostan

Chester C. Deocaris
}
