% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/langmuiranalysis.R, R/temkinanalysis.r,
%   R/tothanalysis.R
\name{temkinanalysis}
\alias{temkinanalysis}
\alias{langmuiranalysis}
\alias{tothanalysis}
\title{Langmuir Isotherm Nonlinear Analysis}
\usage{
langmuiranalysis(Ce, Qe)

temkinanalysis(Ce, Qe, Temp)

tothanalysis(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the fractional coverage}

\item{Temp}{temperature}
}
\value{
the nonlinear regression, parameters for Langmuir isotherm, and model
error analysis

the nonlinear regression, parameters for Temkin isotherm, and model
error analysis

the nonlinear regression, parameters for Toth isotherm, and
model error analysis
}
\description{
The Langmuir isotherm is described to be the most useful and
simplest isotherm for both chemical adsorption and physical adsorption. It
assumes that there is uniform adsorption energy onto the monolayer surface
and that there would be no interaction between the adsorbate and the surface.

Temkin isotherm  is a monolayer adsorption isotherm model which
takes into account the effects that the indirect interaction amongst adsorbate
molecules could have on the adsorption process.

Another empirical modification of the Langmuir equation with the
aim of reducing the error between experimental data and predicted value of
equilibrium data.
}
\examples{
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
langmuiranalysis(Ce,Qe)
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
Temp <- 298
temkinanalysis(Ce, Qe, Temp)
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
tothanalysis(Ce,Qe)
}
\references{
Langmuir, I. (1918) <doi:10.1021/ja01269a066> The adsorption of gases on plane surfaces of
glass, mics and platinum. Journal of the American Chemical Society, 1361-1403.

Temkin, M.J., and Pyzhev, V. (1940). Kinetics of ammonia synthesis
on promoted iron catalyst. Acta Phys. Chim. USSR 12, 327-356.

Toth, J. (1971). State equations of the solid gas interface layer.
Acta Chem. Acad. Hung. 69:311-317
}
\author{
Keith T. Ostan

Chester C. Deocaris

Keith T. Ostan

Chester C. Deocaris

Keith T. Ostan

Chester C. Deocaris
}
