% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kiselevanalysis.R
\name{kiselevanalysis}
\alias{kiselevanalysis}
\title{Kiselev Isotherm Non linear Analysis}
\usage{
kiselevanalysis(theta, Ce)
}
\arguments{
\item{theta}{is the fractional surface coverage}

\item{Ce}{the numerical value for equilibrium capacity}
}
\value{
the nonlinear regression, parameters for the Kiselev isotherm, and
model error analysis
}
\description{
It is also known as localized monomolecular layer model and is
only valid for surface coverage theta > 0.68.
}
\examples{
theta <- c(0.19729, 0.34870, 0.61475, 0.74324, 0.88544, 0.89007, 0.91067, 0.91067, 0.96114)
Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
kiselevanalysis(theta, Ce)
}
\references{
Kiselev, A. V. (1958). "Vapor adsorption in the formation of
adsorbate molecule complexes on the surface," Kolloid Zhur, vol. 20, pp. 338-348.
}
\author{
Paul Angelo C. Manlapaz

Chester C. Deocaris
}
